/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.time.LocalDate;

public final class CustomerInvoiceRecurrenceUtils {
    private CustomerInvoiceRecurrenceUtils() {
    }

    public static boolean isRecurrenceTotalValid(LocalDate beginDate, LocalDate endDate, String recurrenceIntervalCode, int totalRecurrenceNumber) {
        int totalRecurrences = CustomerInvoiceRecurrenceUtils.calculateTotalRecurrences(beginDate, endDate, recurrenceIntervalCode);
        return totalRecurrences == totalRecurrenceNumber;
    }

    public static int calculateTotalRecurrences(LocalDate beginDate, LocalDate endDate, String recurrenceIntervalCode) {
        int totalRecurrences = 0;
        int addCounter = 0;
        if ("M".equals(recurrenceIntervalCode)) {
            addCounter = 1;
        }
        if ("Q".equals(recurrenceIntervalCode)) {
            addCounter = 3;
        }
        while (!beginDate.isAfter(endDate)) {
            beginDate = beginDate.plusMonths(addCounter);
            ++totalRecurrences;
            LocalDate nextDate = beginDate.plusMonths(addCounter);
            if (!endDate.isAfter(beginDate) || !endDate.isBefore(nextDate)) continue;
            ++totalRecurrences;
            break;
        }
        return totalRecurrences;
    }

    public static LocalDate calculateEndDateByTotalRecurrences(LocalDate beginDate, String intervalCode, int totalRecurrences) {
        int addCounter = 0;
        if ("M".equals(intervalCode)) {
            addCounter = -1;
            addCounter += totalRecurrences;
        }
        if ("Q".equals(intervalCode)) {
            addCounter = -3;
            addCounter += totalRecurrences * 3;
        }
        return beginDate.plusMonths(addCounter);
    }
}

