/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.document.authorization.AccountingDocumentAuthorizerBase;

public class ContractsGrantsInvoiceDocumentAuthorizer
extends AccountingDocumentAuthorizerBase {
    protected void addRoleQualification(Object businessObject, Map<String, String> attributes) {
        super.addRoleQualification(businessObject, attributes);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = (ContractsGrantsInvoiceDocument)businessObject;
        if (ObjectUtils.isNotNull((Object)((Object)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail())) && ObjectUtils.isNotNull((Object)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber())) {
            attributes.put("proposalNumber", contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
        }
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.isAuthorizedByTemplate((BusinessObject)document, "KFS-SYS", "Edit Document", user.getPrincipalId());
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        String nameSpaceCode = "KFS-SYS";
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("principalId", user.getPrincipalId());
        permissionDetails.put("documentTypeName", documentTypeName);
        return ContractsGrantsInvoiceDocumentAuthorizer.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), nameSpaceCode, "Initiate Document", permissionDetails, qualificationDetails);
    }

    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActionsFromPresentationController) {
        boolean canErrorCorrect = documentActionsFromPresentationController.contains("canErrorCorrect");
        Set documentActionsAfterProcessing = super.getDocumentActions(document, user, documentActionsFromPresentationController);
        if (canErrorCorrect) {
            documentActionsAfterProcessing.add("canErrorCorrect");
        }
        return documentActionsAfterProcessing;
    }
}

