/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.authorization.CustomerInvoiceDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.service.FinancialSystemWorkflowHelperService;
import org.kuali.kfs.sys.service.UniversityDateService;

public class ContractsGrantsInvoiceDocumentPresentationController
extends CustomerInvoiceDocumentPresentationController {
    private static final String FUNDS_MANAGER_ROUTE_NODE = "FundsManager";
    protected UniversityDateService universityDateService;
    private FinancialSystemWorkflowHelperService financialSystemWorkflowHelperService;

    @Override
    public boolean canErrorCorrect(FinancialSystemTransactionalDocument document) {
        DocumentHeader documentHeader = document.getDocumentHeader();
        boolean invoiceReversal = ((ContractsGrantsInvoiceDocument)document).isInvoiceReversal();
        DateTime dateApproved = null;
        WorkflowDocument workflowDocument = documentHeader.getWorkflowDocument();
        if (ObjectUtils.isNotNull((Object)workflowDocument)) {
            dateApproved = workflowDocument.getDateApproved();
        }
        return this.canErrorCorrect((ContractsGrantsInvoiceDocument)document, documentHeader, invoiceReversal, dateApproved);
    }

    protected boolean canErrorCorrect(ContractsGrantsInvoiceDocument document, DocumentHeader documentHeader, boolean invoiceReversal, DateTime dateApproved) {
        if (this.hasBeenCorrected(documentHeader)) {
            return false;
        }
        if (invoiceReversal) {
            return false;
        }
        if (ObjectUtils.isNotNull((Object)dateApproved) && dateApproved.isBefore((ReadableInstant)this.getStartOfCurrentFiscalYear().toInstant())) {
            return false;
        }
        return this.isDocFinalWithNoAppliedAmountsExceptDiscounts(document);
    }

    private boolean hasBeenCorrected(DocumentHeader documentHeader) {
        return StringUtils.isNotBlank((CharSequence)documentHeader.getCorrectedByDocumentId());
    }

    protected DateTime getStartOfCurrentFiscalYear() {
        Date today = new DateTime().toDate();
        Integer fiscalYear = this.getUniversityDateService().getFiscalYear(today);
        Date firstDateOfFiscalYear = this.getUniversityDateService().getFirstDateOfFiscalYear(fiscalYear);
        return new DateTime((Object)firstDateOfFiscalYear);
    }

    public boolean canEdit(Document document) {
        ContractsGrantsInvoiceDocument contractsGrantsInvoice;
        boolean canEdit = super.canEdit(document);
        if (canEdit && ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)(contractsGrantsInvoice = (ContractsGrantsInvoiceDocument)document).getInvoiceGeneralDetail().getAward())) {
            return false;
        }
        return canEdit;
    }

    public boolean canEditDocumentOverview(Document document) {
        if (this.fundManagerApproving(document)) {
            return true;
        }
        return super.canEditDocumentOverview(document);
    }

    private boolean fundManagerApproving(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        Set currentNodeNames = workflowDocument.getCurrentNodeNames();
        boolean isAtFundsManagerNode = currentNodeNames.contains(FUNDS_MANAGER_ROUTE_NODE);
        return isAtFundsManagerNode && workflowDocument.isApprovalRequested() && !this.isAdhocApprovalRequestedForPrincipal(workflowDocument) && !((ContractsGrantsInvoiceDocument)document).isCorrectionDocument();
    }

    private boolean isAdhocApprovalRequestedForPrincipal(WorkflowDocument workflowDocument) {
        return this.getFinancialSystemWorkflowHelperService().isAdhocApprovalRequestedForPrincipal(workflowDocument, GlobalVariables.getUserSession().getPrincipalId());
    }

    public boolean canProrate(ContractsGrantsInvoiceDocument document) {
        return this.canEdit((Document)document) && this.getParameterService().getParameterValueAsBoolean("KFS-AR", "ContractsGrantsInvoice", "PRORATE_BILL_IND") != false && !ArConstants.BillingFrequencyValues.isMilestone(document.getInvoiceGeneralDetail()) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling(document.getInvoiceGeneralDetail());
    }

    public boolean canModifyTransmissionDate(ContractsGrantsInvoiceDocument document) {
        if (document.hasInvoiceBeenCorrected()) {
            return false;
        }
        if (document.isInvoiceReversal()) {
            return false;
        }
        if (ArConstants.BillingFrequencyValues.isLetterOfCredit(document.getInvoiceGeneralDetail())) {
            return false;
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return ObjectUtils.isNotNull((Object)workflowDocument) && (workflowDocument.isProcessed() || workflowDocument.isFinal());
    }

    @Override
    public Set<String> getEditModes(Document document) {
        WorkflowDocument workflowDocument;
        Set<String> editModes = super.getEditModes(document);
        ContractsGrantsInvoiceDocument cinv = (ContractsGrantsInvoiceDocument)document;
        if (this.canModifyTransmissionDate(cinv)) {
            editModes.add("modifyTransmissionDate");
        }
        if (this.canEdit(document) || this.fundManagerApproving(document)) {
            editModes.add("editFinalBillIndicator");
        }
        if ((workflowDocument = cinv.getDocumentHeader().getWorkflowDocument()).isApproved() && !cinv.isInvoiceReversal()) {
            editModes.add("updateFinalBillIndicator");
        }
        return editModes;
    }

    @Override
    public Set<String> getDocumentActions(Document document) {
        Set<String> documentActions = super.getDocumentActions(document);
        documentActions.remove("canCopy");
        return documentActions;
    }

    public UniversityDateService getUniversityDateService() {
        if (this.universityDateService == null) {
            this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        }
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public FinancialSystemWorkflowHelperService getFinancialSystemWorkflowHelperService() {
        if (this.financialSystemWorkflowHelperService == null) {
            this.financialSystemWorkflowHelperService = (FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class);
        }
        return this.financialSystemWorkflowHelperService;
    }

    public void setFinancialSystemWorkflowHelperService(FinancialSystemWorkflowHelperService financialSystemWorkflowHelperService) {
        this.financialSystemWorkflowHelperService = financialSystemWorkflowHelperService;
    }
}

