/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;

public final class FinalBilledIndicatorValidationService {
    private DocumentService documentService;

    public boolean validateDocument(Document document) {
        boolean valid = true;
        List<FinalBilledIndicatorEntry> invoiceEntries = ((FinalBilledIndicatorDocument)document).getInvoiceEntries();
        if (CollectionUtils.isEmpty(invoiceEntries)) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.no.invoice", new String[0]);
            valid = false;
        } else {
            for (FinalBilledIndicatorEntry entry : invoiceEntries) {
                valid &= this.validateEntry(entry);
            }
        }
        return valid;
    }

    public boolean validateEntry(FinalBilledIndicatorEntry entry) {
        if (ObjectUtils.isNull((Object)((Object)entry)) || ObjectUtils.isNull((Object)entry.getInvoiceDocumentNumber())) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.no.invoice", new String[0]);
            return false;
        }
        return this.validContractsGrantsInvoiceValidation(entry);
    }

    private boolean validContractsGrantsInvoiceValidation(FinalBilledIndicatorEntry entry) {
        String docNumber = entry.getInvoiceDocumentNumber();
        if (this.documentService.documentExists(docNumber)) {
            Document testDocument = this.documentService.getByDocumentHeaderId(docNumber);
            if (!testDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("CINV")) {
                GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invalid.invoice", new String[0]);
                return false;
            }
            return this.entryValidations((ContractsGrantsInvoiceDocument)testDocument);
        }
        GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invalid.invoice", new String[0]);
        return false;
    }

    private boolean entryValidations(ContractsGrantsInvoiceDocument document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!workflowDocument.isFinal() && !workflowDocument.isProcessed()) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invoice.not.final", new String[0]);
            return false;
        }
        if (!document.getInvoiceGeneralDetail().isFinalBillIndicator()) {
            GlobalVariables.getMessageMap().putError("document.invoiceEntries", "error.final.billed.indicator.invoice.not.marked.final.bill", new String[0]);
            return false;
        }
        return true;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

