/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.time.LocalDate;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceRecurrenceUtils;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceBothEndDateAndTotalRecurrenceNumberValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;

    public boolean validate(AttributedDocumentEvent event) {
        String intervalCode;
        LocalDate endDate;
        if (ObjectUtils.isNull((Object)((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails()))) {
            return true;
        }
        if (ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate()) || ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode()) || ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate()) || ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        CustomerInvoiceRecurrenceDetails recurrenceDetails = this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails();
        LocalDate beginDate = recurrenceDetails.getDocumentRecurrenceBeginDate().toLocalDate();
        boolean isRecurrenceValid = CustomerInvoiceRecurrenceUtils.isRecurrenceTotalValid(beginDate, endDate = recurrenceDetails.getDocumentRecurrenceEndDate().toLocalDate(), intervalCode = recurrenceDetails.getDocumentRecurrenceIntervalCode(), recurrenceDetails.getDocumentTotalRecurrenceNumber());
        if (!isRecurrenceValid) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentRecurrenceEndDate", "error.document.invoiceRecurrenceMaintenance.endDateAndTotalNumberOfRecurrencesNotValid", new String[0]);
            return false;
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }
}

