/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceCustomerAddressValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private CustomerAddressService customerAddressService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        String customerNumber = this.customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber();
        if (ObjectUtils.isNotNull((Object)this.customerInvoiceDocument.getCustomerShipToAddressIdentifier())) {
            success = this.isCustomerAddressValid(customerNumber, this.customerInvoiceDocument.getCustomerShipToAddressIdentifier(), true);
            success &= this.isCustomerAddressActive(customerNumber, this.customerInvoiceDocument.getCustomerShipToAddressIdentifier(), true);
        }
        if (ObjectUtils.isNotNull((Object)this.customerInvoiceDocument.getCustomerBillToAddressIdentifier())) {
            success &= this.isCustomerAddressValid(customerNumber, this.customerInvoiceDocument.getCustomerBillToAddressIdentifier(), false);
            success &= this.isCustomerAddressActive(customerNumber, this.customerInvoiceDocument.getCustomerBillToAddressIdentifier(), false);
        }
        return success;
    }

    protected boolean isCustomerAddressValid(String customerNumber, Integer customerAddressIdentifier, boolean isShipToAddress) {
        if (!this.customerAddressService.customerAddressExists(customerNumber, customerAddressIdentifier)) {
            if (isShipToAddress) {
                GlobalVariables.getMessageMap().putError("document.customerShipToAddressIdentifier", "error.document.customerInvoiceDocument.invalidShipToAddressIdentifier", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("document.customerBillToAddressIdentifier", "error.document.customerInvoiceDocument.invalidBillToAddressIdentifier", new String[0]);
            }
            return false;
        }
        return true;
    }

    protected boolean isCustomerAddressActive(String customerNumber, Integer customerAddressIdentifier, boolean isShipToAddress) {
        if (!this.customerAddressService.customerAddressActive(customerNumber, customerAddressIdentifier)) {
            if (isShipToAddress) {
                GlobalVariables.getMessageMap().putError("document.customerShipToAddressIdentifier", "error.document.customerInvoiceDocument.inactiveShipToAddressIdentifier", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("document.customerBillToAddressIdentifier", "error.document.customerInvoiceDocument.inactiveBillToAddressIdentifier", new String[0]);
            }
            return false;
        }
        return true;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }
}

