/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.SuspensionCategoryBase;

public class InvoiceAmountLessThanInvoiceMinimumSuspensionCategory
extends SuspensionCategoryBase {
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;

    @Override
    public boolean shouldSuspend(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        this.ensureTotalInvoiceAmountIsUpToDate(contractsGrantsInvoiceDocument);
        KualiDecimal minInvoiceAmount = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward().getMinInvoiceAmount();
        KualiDecimal totalInvoiceAmount = this.contractsGrantsInvoiceDocumentService.getTotalAmountForInvoice(contractsGrantsInvoiceDocument);
        return this.shouldSuspend(minInvoiceAmount, totalInvoiceAmount);
    }

    private boolean shouldSuspend(KualiDecimal minInvoiceAmount, KualiDecimal invoiceAmount) {
        if (minInvoiceAmount == null) {
            return false;
        }
        return invoiceAmount.isLessThan((AbstractKualiDecimal)minInvoiceAmount);
    }

    private void ensureTotalInvoiceAmountIsUpToDate(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (!ArConstants.BillingFrequencyValues.isMilestone(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail()) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail())) {
            this.contractsGrantsInvoiceDocumentService.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocument);
        }
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }
}

