/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.time.LocalDate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceRecurrenceUtils;
import org.kuali.kfs.sys.context.SpringContext;

public class InvoiceRecurrencePreRules
extends PromptBeforeValidationBase {
    private static final Logger LOG = LogManager.getLogger();

    public boolean doPrompts(Document document) {
        boolean preRulesOK = this.setCustomerNumberIfInvoiceIsEntered(document);
        preRulesOK &= this.setEndDateIfTotalRecurrenceNumberIsEntered(document);
        return preRulesOK &= this.setTotalRecurrenceNumberIfEndDateIsEntered(document);
    }

    protected boolean setCustomerNumberIfInvoiceIsEntered(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        InvoiceRecurrence newInvoiceRecurrence = (InvoiceRecurrence)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getInvoiceNumber()) || ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getCustomerNumber())) {
            return true;
        }
        try {
            if (((DocumentService)SpringContext.getBean(DocumentService.class)).documentExists(newInvoiceRecurrence.getInvoiceNumber())) {
                CustomerInvoiceDocument customerInvoiceDocument = (CustomerInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(newInvoiceRecurrence.getInvoiceNumber());
                newInvoiceRecurrence.setCustomerNumber(customerInvoiceDocument.getCustomer().getCustomerNumber());
            }
        }
        catch (UnknownDocumentIdException ex) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = newInvoiceRecurrence::getInvoiceNumber;
            LOG.error("Document {} does not exist.", supplierArray);
        }
        return true;
    }

    protected boolean setEndDateIfTotalRecurrenceNumberIsEntered(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        InvoiceRecurrence newInvoiceRecurrence = (InvoiceRecurrence)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentRecurrenceEndDate()) && ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        LocalDate beginDate = newInvoiceRecurrence.getDocumentRecurrenceBeginDate().toLocalDate();
        Integer documentTotalRecurrenceNumber = newInvoiceRecurrence.getDocumentTotalRecurrenceNumber();
        String intervalCode = newInvoiceRecurrence.getDocumentRecurrenceIntervalCode();
        LocalDate endDate = CustomerInvoiceRecurrenceUtils.calculateEndDateByTotalRecurrences(beginDate, intervalCode, documentTotalRecurrenceNumber);
        newInvoiceRecurrence.setDocumentRecurrenceEndDate(Date.valueOf(endDate));
        return true;
    }

    protected boolean setTotalRecurrenceNumberIfEndDateIsEntered(Document document) {
        String intervalCode;
        LocalDate endDate;
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        InvoiceRecurrence newInvoiceRecurrence = (InvoiceRecurrence)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getDocumentRecurrenceEndDate())) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentRecurrenceEndDate()) && ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        LocalDate beginDate = newInvoiceRecurrence.getDocumentRecurrenceBeginDate().toLocalDate();
        int totalRecurrences = CustomerInvoiceRecurrenceUtils.calculateTotalRecurrences(beginDate, endDate = newInvoiceRecurrence.getDocumentRecurrenceEndDate().toLocalDate(), intervalCode = newInvoiceRecurrence.getDocumentRecurrenceIntervalCode());
        if (totalRecurrences > 0) {
            newInvoiceRecurrence.setDocumentTotalRecurrenceNumber(totalRecurrences);
        }
        return true;
    }
}

