/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.lang.invoke.CallSite;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.springframework.transaction.annotation.Transactional;

public class ContractsGrantsAgingReportServiceImpl
implements ContractsGrantsAgingReportService {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected BusinessObjectService businessObjectService;
    protected PersonService personService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected DateTimeService dateTimeService;
    protected LookupService lookupService;

    @Override
    @Transactional
    public Map<String, List<ContractsGrantsInvoiceDocument>> filterContractsGrantsAgingReport(Map fieldValues, Date begin, Date end) throws ParseException {
        List<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs = this.retrieveMatchingContractsGrantsInvoiceDocuments(fieldValues, begin, end);
        return this.generateMapFromContractsGrantsInvoiceDocuments(contractsGrantsInvoiceDocs);
    }

    protected List<ContractsGrantsInvoiceDocument> retrieveMatchingContractsGrantsInvoiceDocuments(Map fieldValues, Date begin, Date end) {
        String billingDateCriteria;
        Person fundManagerUser;
        String reportOption = (String)fieldValues.get("reportOption");
        String orgCode = (String)fieldValues.get("organizationCode");
        String chartCode = (String)fieldValues.get("processingOrBillingChartCode");
        String customerNumber = (String)fieldValues.get("customerNumber");
        String customerName = (String)fieldValues.get("customerName");
        String accountNumber = (String)fieldValues.get("accountNumber");
        String accountChartOfAccountsCode = (String)fieldValues.get("accountChartOfAccountsCode");
        String fundManager = (String)fieldValues.get("lookupFundMgrPerson.principalName");
        String proposalNumber = (String)fieldValues.get("proposalNumber");
        String collectorPrincName = (String)fieldValues.get("collector.principalName");
        String collectorPrincipalId = null;
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs = new ArrayList<ContractsGrantsInvoiceDocument>();
        if (StringUtils.isNotBlank((CharSequence)collectorPrincName)) {
            Person collUser = this.personService.getPersonByPrincipalName(collectorPrincName);
            if (ObjectUtils.isNull((Object)collUser)) {
                return contractsGrantsInvoiceDocs;
            }
            collectorPrincipalId = collUser.getPrincipalId();
        }
        if (StringUtils.isNotBlank((CharSequence)fundManager) && ObjectUtils.isNull((Object)(fundManagerUser = this.getPersonService().getPersonByPrincipalName(fundManager)))) {
            return contractsGrantsInvoiceDocs;
        }
        String awardDocumentNumber = (String)fieldValues.get("awardDocumentNumber");
        String markedAsFinal = (String)fieldValues.get("markedAsFinal");
        String invoiceNumber = (String)fieldValues.get("invoiceNumber");
        String invoiceDateFromString = (String)fieldValues.get("rangeLowerBoundKeyPrefix_invoiceDate");
        String invoiceDateToString = (String)fieldValues.get("invoiceDate");
        String invoiceDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(invoiceDateFromString, invoiceDateToString, true);
        String responsibilityId = (String)fieldValues.get("contractsAndGrantsAccountResponsibilityId");
        String awardEndFromDate = (String)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndDate");
        String awardEndToDate = (String)fieldValues.get("awardEndDate");
        HashMap<String, String> fieldValuesForInvoice = new HashMap<String, String>();
        fieldValuesForInvoice.put("openInvoiceIndicator", "true");
        fieldValuesForInvoice.put("documentHeader.workflowDocumentTypeName", "CINV");
        if (ObjectUtils.isNotNull((Object)reportOption)) {
            if (reportOption.equalsIgnoreCase("Processing Organization") && StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
                fieldValuesForInvoice.put("accountsReceivableDocumentHeader.processingOrganizationCode", orgCode);
                fieldValuesForInvoice.put("accountsReceivableDocumentHeader.processingChartOfAccountCode", chartCode);
            }
            if (reportOption.equalsIgnoreCase("Billing Organization") && StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
                fieldValuesForInvoice.put("billedByOrganizationCode", orgCode);
                fieldValuesForInvoice.put("billByChartOfAccountCode", chartCode);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)customerNumber)) {
            fieldValuesForInvoice.put("accountsReceivableDocumentHeader.customerNumber", customerNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)customerName)) {
            fieldValuesForInvoice.put("accountsReceivableDocumentHeader.customer.customerName", customerName);
        }
        if (StringUtils.isNotBlank((CharSequence)proposalNumber)) {
            fieldValuesForInvoice.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)markedAsFinal)) {
            if (markedAsFinal.equalsIgnoreCase("Y")) {
                fieldValuesForInvoice.put("invoiceGeneralDetail.finalBillIndicator", "true");
            } else if (markedAsFinal.equalsIgnoreCase("N")) {
                fieldValuesForInvoice.put("invoiceGeneralDetail.finalBillIndicator", "false");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceNumber)) {
            fieldValuesForInvoice.put("documentNumber", invoiceNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)responsibilityId)) {
            fieldValuesForInvoice.put("sourceAccountingLines.account.contractsAndGrantsAccountResponsibilityId", responsibilityId);
        }
        if (StringUtils.isNotBlank((CharSequence)accountChartOfAccountsCode)) {
            fieldValuesForInvoice.put("sourceAccountingLines.chartOfAccountsCode", accountChartOfAccountsCode);
        }
        if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            fieldValuesForInvoice.put("sourceAccountingLines.accountNumber", accountNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceDateCriteria)) {
            fieldValuesForInvoice.put("documentHeader.workflowCreateDate", invoiceDateCriteria);
        }
        String billingBeginDateString = null;
        if (begin != null) {
            billingBeginDateString = this.getDateTimeService().toDateString((java.util.Date)begin);
        }
        String billingEndDateString = null;
        if (end != null) {
            billingEndDateString = this.getDateTimeService().toDateString((java.util.Date)end);
        }
        if (StringUtils.isNotBlank((CharSequence)(billingDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(billingBeginDateString, billingEndDateString, false)))) {
            fieldValuesForInvoice.put("billingDate", billingDateCriteria);
        }
        Set<String> awardIds = this.lookupBillingAwards(awardDocumentNumber, awardEndFromDate, awardEndToDate, fundManager);
        contractsGrantsInvoiceDocs.addAll(this.getLookupService().findCollectionBySearch(ContractsGrantsInvoiceDocument.class, fieldValuesForInvoice));
        this.filterContractsGrantsInvoiceDocumentsByAwardAndCollector(contractsGrantsInvoiceDocs, collectorPrincipalId, awardIds);
        return contractsGrantsInvoiceDocs;
    }

    protected void filterContractsGrantsInvoiceDocumentsByAwardAndCollector(Collection<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs, String collectorPrincipalId, Set<String> awardIds) {
        Person user = this.getUserSession().getPerson();
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocs)) {
            Iterator<ContractsGrantsInvoiceDocument> iter = contractsGrantsInvoiceDocs.iterator();
            while (iter.hasNext()) {
                ContractsGrantsInvoiceDocument document = iter.next();
                if (ObjectUtils.isNotNull((Object)((Object)document.getInvoiceGeneralDetail())) && ObjectUtils.isNotNull((Object)document.getInvoiceGeneralDetail().getAward()) && awardIds != null && !awardIds.contains(document.getInvoiceGeneralDetail().getAward().getProposalNumber())) {
                    iter.remove();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)collectorPrincipalId)) {
                    if (this.contractsGrantsInvoiceDocumentService.canViewInvoice(document, collectorPrincipalId)) continue;
                    iter.remove();
                    continue;
                }
                if (this.contractsGrantsInvoiceDocumentService.canViewInvoice(document, user.getPrincipalId())) continue;
                iter.remove();
            }
        }
    }

    protected Map<String, List<ContractsGrantsInvoiceDocument>> generateMapFromContractsGrantsInvoiceDocuments(Collection<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs) {
        HashMap cgMapByCustomer = null;
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocs)) {
            cgMapByCustomer = new HashMap();
            for (ContractsGrantsInvoiceDocument cgDoc : contractsGrantsInvoiceDocs) {
                String customerNm;
                String customerNbr = cgDoc.getCustomer().getCustomerNumber();
                String key = customerNbr + "-" + (customerNm = cgDoc.getCustomer().getCustomerName());
                List cgInvoiceDocs = cgMapByCustomer.containsKey(key) ? (List)cgMapByCustomer.get(key) : new ArrayList();
                cgInvoiceDocs.add(cgDoc);
                cgMapByCustomer.put((CallSite)((Object)key), cgInvoiceDocs);
            }
        }
        return cgMapByCustomer;
    }

    protected Set<String> lookupBillingAwards(String awardDocumentNumber, String awardEndFromDate, String awardEndToDate, String fundManager) {
        String awardEnd;
        if (StringUtils.isBlank((CharSequence)awardDocumentNumber) && StringUtils.isBlank((CharSequence)awardEndFromDate) && StringUtils.isBlank((CharSequence)awardEndToDate) && StringUtils.isBlank((CharSequence)fundManager)) {
            return null;
        }
        Set<String> fundManagerIds = this.getContractsGrantsReportHelperService().lookupPrincipalIds(fundManager);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)awardDocumentNumber)) {
            fieldValues.put("awardDocumentNumber", awardDocumentNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(awardEnd = this.getContractsGrantsReportHelperService().fixDateCriteria(awardEndFromDate, awardEndToDate, false)))) {
            fieldValues.put("awardEndingDate", awardEnd);
        }
        fieldValues.put("active", "Y");
        List awards = this.getContractsAndGrantsModuleBillingService().lookupAwards(fieldValues, true);
        HashSet<String> billingAwardIds = new HashSet<String>();
        for (ContractsAndGrantsAward award : awards) {
            ContractsAndGrantsBillingAward cgbAward;
            if (!(award instanceof ContractsAndGrantsBillingAward) || !ObjectUtils.isNull((Object)(cgbAward = (ContractsAndGrantsBillingAward)award).getAwardPrimaryFundManager()) && !fundManagerIds.isEmpty() && !fundManagerIds.contains(cgbAward.getAwardPrimaryFundManager().getPrincipalId())) continue;
            billingAwardIds.add(cgbAward.getProposalNumber());
        }
        return billingAwardIds;
    }

    @Override
    public List<ContractsGrantsInvoiceDocument> lookupContractsGrantsInvoiceDocumentsForAging(Map<String, String> fieldValues) {
        try {
            java.util.Date today = this.getDateTimeService().getCurrentDate();
            String reportRunDateStr = fieldValues.get("reportRunDate");
            java.util.Date reportRunDate = ObjectUtils.isNull((Object)reportRunDateStr) || reportRunDateStr.isEmpty() ? today : this.getDateTimeService().convertToDate(reportRunDateStr);
            return this.retrieveMatchingContractsGrantsInvoiceDocuments(fieldValues, null, new Date(reportRunDate.getTime()));
        }
        catch (ParseException ex) {
            throw new RuntimeException("Could not parse report run date for lookup", ex);
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }
}

