/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectConsolidation;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.module.ar.dataaccess.CostCategoryDao;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CostCategoryServiceImpl
implements CostCategoryService {
    protected CostCategoryDao costCategoryDao;
    protected BusinessObjectService businessObjectService;
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public CostCategoryDetail isCostCategoryObjectConsolidationUnique(CostCategoryObjectConsolidation objectConsolidation) {
        CostCategoryDetail detail = this.getCostCategoryDao().retrieveMatchingCostCategoryConsolidationAmongConsolidations(objectConsolidation);
        if (ObjectUtils.isNotNull((Object)detail)) {
            return detail;
        }
        detail = this.getCostCategoryDao().retrieveMatchingCostCategoryConsolidationAmongLevels(objectConsolidation);
        if (ObjectUtils.isNotNull((Object)detail)) {
            return detail;
        }
        return this.getCostCategoryDao().retrieveMatchingCostCategoryConsolidationAmongCodes(objectConsolidation);
    }

    @Override
    public CostCategoryDetail isCostCategoryObjectLevelUnique(CostCategoryObjectLevel objectLevel) {
        CostCategoryDetail detail = this.getCostCategoryDao().retrieveMatchingCostCategoryLevelAmongLevels(objectLevel);
        if (ObjectUtils.isNotNull((Object)detail)) {
            return detail;
        }
        detail = this.getCostCategoryDao().retrieveMatchingCostCategoryLevelAmongConsolidations(objectLevel);
        if (ObjectUtils.isNotNull((Object)detail)) {
            return detail;
        }
        return this.getCostCategoryDao().retrieveMatchingCostCategoryLevelAmongCodes(objectLevel);
    }

    @Override
    public CostCategoryDetail isCostCategoryObjectCodeUnique(CostCategoryObjectCode objectCode) {
        CostCategoryDetail detail = this.getCostCategoryDao().retrieveMatchingCostCategoryObjectCodeAmongCodes(objectCode);
        if (ObjectUtils.isNotNull((Object)detail)) {
            return detail;
        }
        detail = this.getCostCategoryDao().retrieveMatchingCostCategoryObjectCodeAmongLevels(objectCode);
        if (ObjectUtils.isNotNull((Object)detail)) {
            return detail;
        }
        return this.getCostCategoryDao().retrieveCostCategoryObjectCodeAmongConsolidations(objectCode);
    }

    @Override
    public List<Balance> getBalancesForCostCategory(Integer fiscalYear, String chartOfAccountsCode, String accountNumber, String balanceType, Collection<String> objectTypeCodes, CostCategory costCategory) {
        Supplier[] supplierArray = new Supplier[6];
        supplierArray[0] = costCategory::getCategoryCode;
        supplierArray[1] = () -> fiscalYear;
        supplierArray[2] = () -> chartOfAccountsCode;
        supplierArray[3] = () -> accountNumber;
        supplierArray[4] = () -> balanceType;
        supplierArray[5] = () -> objectTypeCodes;
        LOG.debug("Retrieving balances for cost category: {}; fiscal year = {}; chart: {}; account number: {}; balance type: {}; object type codes: {}", supplierArray);
        return this.getCostCategoryDao().getBalancesForCostCategory(fiscalYear, chartOfAccountsCode, accountNumber, balanceType, objectTypeCodes, costCategory);
    }

    @Override
    public CostCategory getCostCategoryForObjectCode(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode) {
        return this.getCostCategoryDao().getCostCategoryForObjectCode(universityFiscalYear, chartOfAccountsCode, financialObjectCode);
    }

    @Override
    public ObjectCodeCurrent findObjectCodeForChartAndCategory(String chartOfAccountsCode, String categoryCode) {
        CostCategory costCategory = (CostCategory)this.getBusinessObjectService().findBySinglePrimaryKey(CostCategory.class, (Object)categoryCode);
        if (ObjectUtils.isNull((Object)((Object)costCategory))) {
            return null;
        }
        ObjectCodeCurrent foundObjectCode = null;
        if (!CollectionUtils.isEmpty(costCategory.getObjectCodes())) {
            foundObjectCode = this.findMatchingObjectCodeByObjectCode(chartOfAccountsCode, costCategory.getObjectCodes());
        }
        if (ObjectUtils.isNull(foundObjectCode) && !CollectionUtils.isEmpty(costCategory.getObjectLevels())) {
            foundObjectCode = this.findMatchingObjectCodeByObjectLevel(chartOfAccountsCode, costCategory.getObjectLevels());
        }
        if (ObjectUtils.isNull(foundObjectCode) && !CollectionUtils.isEmpty(costCategory.getObjectConsolidations())) {
            foundObjectCode = this.findMatchingObjectCodeByObjectConsolidation(chartOfAccountsCode, costCategory.getObjectConsolidations());
        }
        return foundObjectCode;
    }

    protected ObjectCodeCurrent findMatchingObjectCodeByObjectCode(String chartOfAccountsCode, List<CostCategoryObjectCode> categoryObjectCodes) {
        for (CostCategoryObjectCode costCategoryObjectCode : categoryObjectCodes) {
            if (!StringUtils.equals((CharSequence)costCategoryObjectCode.getChartOfAccountsCode(), (CharSequence)chartOfAccountsCode)) continue;
            return costCategoryObjectCode.getObjectCodeCurrent();
        }
        return null;
    }

    protected ObjectCodeCurrent findMatchingObjectCodeByObjectLevel(String chartOfAccountsCode, List<CostCategoryObjectLevel> categoryObjectLevels) {
        for (CostCategoryObjectLevel costCategoryObjectLevel : categoryObjectLevels) {
            if (!StringUtils.equals((CharSequence)costCategoryObjectLevel.getChartOfAccountsCode(), (CharSequence)chartOfAccountsCode)) continue;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
            fieldValues.put("financialObjectLevelCode", costCategoryObjectLevel.getFinancialObjectLevelCode());
            Collection objectCodes = this.getBusinessObjectService().findMatching(ObjectCodeCurrent.class, fieldValues);
            if (CollectionUtils.isEmpty((Collection)objectCodes)) continue;
            return (ObjectCodeCurrent)TransactionalServiceUtils.retrieveFirstAndExhaustIterator(objectCodes.iterator());
        }
        return null;
    }

    protected ObjectCodeCurrent findMatchingObjectCodeByObjectConsolidation(String chartOfAccountsCode, List<CostCategoryObjectConsolidation> categoryObjectConsolidations) {
        for (CostCategoryObjectConsolidation costCategoryObjectConsolidation : categoryObjectConsolidations) {
            if (!StringUtils.equals((CharSequence)costCategoryObjectConsolidation.getChartOfAccountsCode(), (CharSequence)chartOfAccountsCode)) continue;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
            fieldValues.put("financialObjectLevel.financialConsolidationObjectCode", costCategoryObjectConsolidation.getFinConsolidationObjectCode());
            Collection objectCodes = this.getBusinessObjectService().findMatching(ObjectCodeCurrent.class, fieldValues);
            if (CollectionUtils.isEmpty((Collection)objectCodes)) continue;
            return (ObjectCodeCurrent)TransactionalServiceUtils.retrieveFirstAndExhaustIterator(objectCodes.iterator());
        }
        return null;
    }

    public CostCategoryDao getCostCategoryDao() {
        return this.costCategoryDao;
    }

    public void setCostCategoryDao(CostCategoryDao costCategoryDao) {
        this.costCategoryDao = costCategoryDao;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

