/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.module.ar.batch.vo.CustomersVO;
import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;

public class CustomerLoadInputFileType
extends XmlBatchInputFileTypeBase<CustomersVO> {
    private static final Logger LOG = LogManager.getLogger();
    private static final String FILE_NAME_PREFIX = "customer_load";
    private static final String FILE_NAME_DELIM = "_";
    private CustomerLoadService customerLoadService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        return this.customerLoadService.getFileName(principalName, fileUserIdentifier, FILE_NAME_PREFIX, FILE_NAME_DELIM);
    }

    public String getFileTypeIdentifier() {
        return "customerLoadInputFileType";
    }

    public boolean validate(Object parsedFileContents) {
        try {
            CustomersVO customersVO = (CustomersVO)parsedFileContents;
            return this.customerLoadService.validate(customersVO.getCustomerVOs());
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = parsedFileContents::getClass;
            LOG.error("Could not convert the passed-in parsedFileContents of type [{}] to CustomersVO.", supplierArray);
            throw new RuntimeException("Could not convert the passed-in parsedFileContents of type [" + parsedFileContents.getClass().toString() + "] to CustomersVO.", e);
        }
    }

    public void process(String fileName, Object parsedFileContents) {
        super.process(fileName, parsedFileContents);
    }

    public String getTitleKey() {
        return "message.ar.customerLoad.batchUpload.xml.title";
    }

    public void setCustomerLoadService(CustomerLoadService customerLoadService) {
        this.customerLoadService = customerLoadService;
    }

    public String getAuthorPrincipalName(File file) {
        String[] fileNameParts = StringUtils.split((String)file.getName(), (String)FILE_NAME_DELIM);
        if (fileNameParts.length > 3) {
            return fileNameParts[2];
        }
        return null;
    }
}

