/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadBatchError;

public class CustomerLoadBatchErrors {
    private final Map<String, List<CustomerLoadBatchError>> batchErrors = new TreeMap<String, List<CustomerLoadBatchError>>();
    private int errorCount;

    public CustomerLoadBatchErrors() {
        this.errorCount = 0;
    }

    public CustomerLoadBatchErrors(CustomerLoadBatchError error) {
        this.errorCount = 0;
        if (error == null) {
            return;
        }
        this.batchErrors.put(error.getCustomerName(), new ArrayList());
        this.batchErrors.get(error.getCustomerName()).add(error);
        ++this.errorCount;
    }

    public CustomerLoadBatchErrors(List<CustomerLoadBatchError> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        this.addErrors(errors);
    }

    public void addAll(CustomerLoadBatchErrors otherErrors) {
        if (otherErrors == null) {
            throw new IllegalArgumentException("Parameter otherErrors passed in was null.");
        }
        for (String customerName : otherErrors.getCompanyNames()) {
            List<CustomerLoadBatchError> customerErrors = otherErrors.getErrorsByCompany(customerName);
            for (CustomerLoadBatchError customerLoadBatchError : customerErrors) {
                this.addError(customerLoadBatchError);
            }
        }
    }

    public void addError(CustomerLoadBatchError error) {
        if (error == null) {
            throw new IllegalArgumentException("Parameter 'error' passed in was null.");
        }
        if (!this.batchErrors.containsKey(error.getCustomerName())) {
            this.batchErrors.put(error.getCustomerName(), new ArrayList());
        }
        this.batchErrors.get(error.getCustomerName()).add(error);
        ++this.errorCount;
    }

    public void addError(String customerName, String propertyName, Class<?> propertyClass, String value, String description) {
        if (StringUtils.isBlank((CharSequence)customerName)) {
            throw new IllegalArgumentException("Parameter customerName was empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new IllegalArgumentException("Parameter propertyName was empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)description)) {
            throw new IllegalArgumentException("Parameter description was empty or null.");
        }
        CustomerLoadBatchError error = new CustomerLoadBatchError(customerName, propertyName, propertyClass, value, description);
        this.addError(error);
    }

    public void addErrors(List<CustomerLoadBatchError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException("Parameter 'error' passed in was null.");
        }
        for (CustomerLoadBatchError error : errors) {
            this.addError(error);
        }
    }

    public Set<String> getCompanyNames() {
        return this.batchErrors.keySet();
    }

    public List<CustomerLoadBatchError> getErrorsByCompany(String companyName) {
        if (!this.batchErrors.containsKey(companyName)) {
            return null;
        }
        return this.batchErrors.get(companyName);
    }

    public boolean isEmpty() {
        return this.batchErrors.isEmpty();
    }

    public Set<String> getErrorStrings() {
        TreeSet<String> errors = new TreeSet<String>();
        for (String companyName : this.batchErrors.keySet()) {
            for (CustomerLoadBatchError error : this.batchErrors.get(companyName)) {
                errors.add(error.toString());
            }
        }
        return errors;
    }

    public int getCompaniesWithErrors() {
        return this.batchErrors.size();
    }

    public int getTotalErrors() {
        return this.errorCount;
    }
}

