/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.MaintenanceDocumentBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.CustomerLoadStep;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadBatchErrors;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadFileResult;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadResult;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.module.ar.batch.vo.CustomerVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerVOAdapter;
import org.kuali.kfs.module.ar.batch.vo.CustomersVO;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerRule;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.InitiateDirectoryBase;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.exception.ParseException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.AutoPopulatingList;

@Transactional
public class CustomerLoadServiceImpl
extends InitiateDirectoryBase
implements CustomerLoadService {
    private static final Logger LOG = LogManager.getLogger();
    private static final String RECORDS_PER_BATCH_PARM_NM = "RECORDS_PER_BATCH";
    private static final String WORKFLOW_DOC_ID_PREFIX = " - WITH WORKFLOW DOCID: ";
    private BatchInputFileService batchInputFileService;
    private CustomerService customerService;
    private ConfigurationService configService;
    private DocumentService docService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;
    private List<BatchInputFileType> batchInputFileTypes;
    private CustomerVOAdapter adapter;
    private String reportsDirectory;

    @Override
    public boolean loadFiles() {
        LOG.info("Beginning processing of all available files for AR Customer Batch Upload.");
        boolean result = true;
        ArrayList<CustomerLoadFileResult> fileResults = new ArrayList<CustomerLoadFileResult>();
        ArrayList<String> routedDocumentNumbers = new ArrayList<String>();
        ArrayList<String> failedDocumentNumbers = new ArrayList<String>();
        Map<String, BatchInputFileType> fileNamesToLoad = this.getListOfFilesToProcess();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = fileNamesToLoad::size;
        LOG.info("Found {} file(s) to process.", supplierArray);
        ArrayList<String> processedFiles = new ArrayList<String>();
        for (String inputFileName : fileNamesToLoad.keySet()) {
            LOG.info("Beginning processing of filename: {}.", (Object)inputFileName);
            CustomerLoadFileResult reporter = new CustomerLoadFileResult(inputFileName);
            fileResults.add(reporter);
            if (this.loadFile(inputFileName, reporter, fileNamesToLoad.get(inputFileName), routedDocumentNumbers, failedDocumentNumbers)) {
                result = true;
                reporter.addFileInfoMessage("File successfully completed processing.");
                processedFiles.add(inputFileName);
                continue;
            }
            reporter.addFileErrorMessage("File failed to process successfully.");
            result = false;
        }
        this.removeDoneFiles(processedFiles);
        this.writeReportPDF(fileResults);
        return result;
    }

    protected Map<String, BatchInputFileType> getListOfFilesToProcess() {
        LinkedHashMap<String, BatchInputFileType> inputFileTypeMap = new LinkedHashMap<String, BatchInputFileType>();
        for (BatchInputFileType batchInputFileType : this.batchInputFileTypes) {
            List inputFileNames = this.batchInputFileService.listInputFileNamesWithDoneFile(batchInputFileType);
            if (inputFileNames == null) {
                this.criticalError("BatchInputFileService.listInputFileNamesWithDoneFile(" + batchInputFileType.getFileTypeIdentifier() + ") returned NULL which should never happen.");
                continue;
            }
            for (String inputFileName : inputFileNames) {
                if (StringUtils.isBlank((CharSequence)inputFileName)) {
                    this.criticalError("One of the file names returned as ready to process [" + inputFileName + "] was blank.  This should not happen, so throwing an error to investigate.");
                }
                inputFileTypeMap.put(inputFileName, batchInputFileType);
            }
        }
        return inputFileTypeMap;
    }

    protected void removeDoneFiles(List<String> dataFileNames) {
        for (String dataFileName : dataFileNames) {
            File doneFile = new File(StringUtils.substringBeforeLast((String)dataFileName, (String)".") + ".done");
            if (!doneFile.exists()) continue;
            doneFile.delete();
        }
    }

    @Override
    public boolean loadFile(String fileName, CustomerLoadFileResult reporter, BatchInputFileType batchInputFileType, List<String> routedDocumentNumbers, List<String> failedDocumentNumbers) {
        Object parsedObject;
        byte[] fileByteContent = this.safelyLoadFileBytes(fileName);
        LOG.info("Attempting to parse the file using JAXB.");
        try {
            parsedObject = this.batchInputFileService.parse(batchInputFileType, fileByteContent);
        }
        catch (ParseException e) {
            String errorMessage = "Error parsing batch file: " + e.getMessage();
            reporter.addFileErrorMessage(errorMessage);
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage);
        }
        if (!(parsedObject instanceof List) && !(parsedObject instanceof CustomersVO)) {
            String errorMessage = String.format("Parsed file was not of the expected type.  Expected [%s] or [%s] but got [%s].", List.class, CustomersVO.class, parsedObject.getClass());
            reporter.addFileErrorMessage(errorMessage);
            this.criticalError(errorMessage);
        }
        List<CustomerVO> customerVOs = parsedObject instanceof List ? (List<CustomerVO>)parsedObject : ((CustomersVO)parsedObject).getCustomerVOs();
        ArrayList<MaintenanceDocument> readyTransientDocs = new ArrayList<MaintenanceDocument>();
        LOG.info("Beginning validation and preparation of batch file.");
        boolean result = this.validateCustomers(customerVOs, readyTransientDocs, reporter, false);
        return result &= this.sendDocumentsIntoWorkflow(readyTransientDocs, routedDocumentNumbers, failedDocumentNumbers, reporter);
    }

    protected boolean sendDocumentsIntoWorkflow(List<MaintenanceDocument> readyTransientDocs, List<String> routedDocumentNumbers, List<String> failedDocumentNumbers, CustomerLoadFileResult reporter) {
        boolean result = true;
        for (MaintenanceDocument readyTransientDoc : readyTransientDocs) {
            result &= this.sendDocumentIntoWorkflow(readyTransientDoc, routedDocumentNumbers, failedDocumentNumbers, reporter);
        }
        return result;
    }

    protected boolean sendDocumentIntoWorkflow(MaintenanceDocument readyTransientDoc, List<String> routedDocumentNumbers, List<String> failedDocumentNumbers, CustomerLoadFileResult reporter) {
        String customerName = ((Customer)readyTransientDoc.getNewMaintainableObject().getBusinessObject()).getCustomerName();
        MaintenanceDocument realMaintDoc = (MaintenanceDocument)this.docService.getNewDocument(this.getCustomerMaintenanceDocumentTypeName());
        realMaintDoc.getNewMaintainableObject().setBusinessObject(readyTransientDoc.getNewMaintainableObject().getBusinessObject());
        realMaintDoc.getOldMaintainableObject().setBusinessObject(readyTransientDoc.getOldMaintainableObject().getBusinessObject());
        realMaintDoc.getNewMaintainableObject().setMaintenanceAction(readyTransientDoc.getNewMaintainableObject().getMaintenanceAction());
        realMaintDoc.getDocumentHeader().setDocumentDescription(readyTransientDoc.getDocumentHeader().getDocumentDescription());
        Customer customer = (Customer)realMaintDoc.getNewMaintainableObject().getBusinessObject();
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = customer::getCustomerNumber;
        supplierArray[1] = customer::getCustomerName;
        LOG.info("Routing Customer Maintenance document for [{}] {}", supplierArray);
        this.docService.routeDocument((org.kuali.kfs.krad.document.Document)realMaintDoc, "Routed Edit/Update Customer Maintenance from CustomerLoad Batch Process", null);
        reporter.setCustomerSuccessResult(customerName);
        reporter.setCustomerWorkflowDocId(customerName, realMaintDoc.getDocumentNumber());
        routedDocumentNumbers.add(realMaintDoc.getDocumentNumber());
        return true;
    }

    protected String getCustomerMaintenanceDocumentTypeName() {
        return "CUS";
    }

    protected void addError(CustomerLoadBatchErrors batchErrors, String customerName, String propertyName, Class<?> propertyClass, String origValue, String description) {
        batchErrors.addError(customerName, propertyName, propertyClass, origValue, description);
    }

    protected void addBatchErrorsToGlobalVariables(CustomerLoadBatchErrors batchErrors) {
        Set<String> errorMessages = batchErrors.getErrorStrings();
        for (String errorMessage : errorMessages) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save", new String[]{errorMessage});
        }
    }

    protected void addBatchErrorstoCustomerLoadResult(CustomerLoadBatchErrors batchErrors, CustomerLoadResult result) {
        Set<String> errorMessages = batchErrors.getErrorStrings();
        for (String errorMessage : errorMessages) {
            result.addErrorMessage(errorMessage);
        }
    }

    protected byte[] safelyLoadFileBytes(String fileName) {
        byte[] fileByteContent;
        try {
            FileInputStream fileContents = new FileInputStream(fileName);
            fileByteContent = IOUtils.toByteArray((InputStream)fileContents);
        }
        catch (FileNotFoundException fnfe) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> fileName;
            supplierArray[1] = fnfe::getMessage;
            LOG.error("Batch file not found [{}]. {}", supplierArray);
            throw new RuntimeException("Batch File not found [" + fileName + "]. " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> fileName;
            supplierArray[1] = ioe::getMessage;
            LOG.error("IO Exception loading: [{}]. {}", supplierArray);
            throw new RuntimeException("IO Exception loading: [" + fileName + "]. " + ioe.getMessage());
        }
        return fileByteContent;
    }

    @Override
    public boolean validate(List<CustomerVO> customerUploads) {
        return this.validateAndPrepare(customerUploads, new ArrayList<MaintenanceDocument>(), true);
    }

    @Override
    public boolean validateAndPrepare(List<CustomerVO> customerUploads, List<MaintenanceDocument> customerMaintDocs, boolean useGlobalMessageMap) {
        return this.validateCustomers(customerUploads, customerMaintDocs, new CustomerLoadFileResult(), useGlobalMessageMap);
    }

    protected boolean validateCustomers(List<CustomerVO> customerUploads, List<MaintenanceDocument> customerMaintDocs, CustomerLoadFileResult reporter, boolean useGlobalMessageMap) {
        if (customerUploads == null) {
            LOG.error("Null list of Customer upload objects.  This should never happen.");
            throw new IllegalArgumentException("Null list of Customer upload objects.  This should never happen.");
        }
        if (customerUploads.isEmpty()) {
            reporter.addFileErrorMessage("An empty list of Customer uploads was passed in for validation.  As a result, no validation can be done.");
            if (useGlobalMessageMap) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save", new String[]{"An empty list of Customer uploads was passed in for validation.  As a result, no validation was done."});
            }
            return false;
        }
        boolean groupSucceeded = true;
        String maxRecordsString = this.parameterService.getParameterValueAsString(CustomerLoadStep.class, RECORDS_PER_BATCH_PARM_NM);
        if (StringUtils.isBlank((CharSequence)maxRecordsString) || !StringUtils.isNumeric((CharSequence)maxRecordsString)) {
            this.criticalError("Expected 'Max Records Per Document' System Parameter is not available.");
        }
        Integer maxRecords = new Integer(maxRecordsString);
        if (customerUploads.size() > maxRecords) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = customerUploads::size;
            supplierArray[1] = () -> maxRecords;
            LOG.error("Too many records passed in for this file.  {} were passed in, and the limit is {}.  As a result, no validation was done.", supplierArray);
            reporter.addFileErrorMessage("Too many records passed in for this file.  " + customerUploads.size() + " were passed in, and the limit is " + maxRecords + ".  As a result, no validation was done.");
            if (useGlobalMessageMap) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.save", new String[]{"Too many records passed in for this file.  " + customerUploads.size() + " were passed in, and the limit is " + maxRecords + ".  As a result, no validation was done."});
            }
            return false;
        }
        MaintenanceDocument oneRealMaintDoc = null;
        CustomerLoadBatchErrors fileBatchErrors = new CustomerLoadBatchErrors();
        for (CustomerVO customerVO : customerUploads) {
            boolean docSucceeded = true;
            String customerName = customerVO.getCustomerName();
            LOG.info("Beginning conversion and validation for [{}].", (Object)customerName);
            reporter.addCustomerInfoMessage(customerName, "Beginning conversion and validation.");
            CustomerLoadResult result = reporter.getCustomer(customerName);
            CustomerLoadBatchErrors customerBatchErrors = new CustomerLoadBatchErrors();
            LOG.info("Beginning conversion from VO to BO.");
            Customer customer = this.adapter.convert(customerVO, customerBatchErrors);
            if (!customerBatchErrors.isEmpty()) {
                LOG.info("The customer [{}] was not processed due to errors in uploading and conversion.", (Object)customerName);
                customerBatchErrors.addError(customerName, "Global", Object.class, "", "This document was not processed due to errors in uploading and conversion.");
                this.addBatchErrorstoCustomerLoadResult(customerBatchErrors, result);
                reporter.setCustomerFailureResult(customerName);
                docSucceeded = false;
                groupSucceeded = false;
                continue;
            }
            Customer existingCustomer = this.customerAlreadyExists(customer);
            boolean isNew = existingCustomer == null;
            boolean isUpdate = !isNew;
            this.processBeforeValidating(customer, existingCustomer, isUpdate);
            MaintenanceDocument transientMaintDoc = this.createTransientMaintDoc();
            oneRealMaintDoc = this.createRealMaintDoc(oneRealMaintDoc);
            transientMaintDoc.setDocumentNumber(oneRealMaintDoc.getDocumentNumber());
            transientMaintDoc.setDocumentHeader(oneRealMaintDoc.getDocumentHeader());
            transientMaintDoc.getDocumentHeader().setDocumentDescription("AR Customer Load Batch Transient");
            transientMaintDoc.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)customer);
            transientMaintDoc.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)(existingCustomer == null ? new Customer() : existingCustomer));
            if (isNew) {
                transientMaintDoc.getNewMaintainableObject().setMaintenanceAction("New");
            } else {
                transientMaintDoc.getNewMaintainableObject().setMaintenanceAction("Edit");
            }
            if (isNew) {
                reporter.addCustomerInfoMessage(customerName, "Customer record batched is a New Customer.");
            } else {
                reporter.addCustomerInfoMessage(customerName, "Customer record batched is an Update to an existing Customer.");
            }
            if (!this.validateSingle(transientMaintDoc, customerBatchErrors, customerName)) {
                groupSucceeded = false;
                docSucceeded = false;
                reporter.setCustomerFailureResult(customerName);
            }
            this.addBatchErrorstoCustomerLoadResult(customerBatchErrors, result);
            if (docSucceeded) {
                customerMaintDocs.add(transientMaintDoc);
                Customer customer2 = (Customer)transientMaintDoc.getNewMaintainableObject().getBusinessObject();
                reporter.addCustomerInfoMessage(customerName, "Customer Number is: " + customer2.getCustomerNumber());
                reporter.addCustomerInfoMessage(customerName, "Customer Name is:   " + customer2.getCustomerName());
                reporter.setCustomerSuccessResult(customerName);
            }
            fileBatchErrors.addAll(customerBatchErrors);
        }
        if (useGlobalMessageMap) {
            this.addBatchErrorsToGlobalVariables(fileBatchErrors);
        }
        return groupSucceeded;
    }

    protected void processBeforeValidating(Customer customer, Customer existingCustomer, boolean isUpdate) {
        if (isUpdate) {
            if (StringUtils.isBlank((CharSequence)customer.getCustomerNumber())) {
                customer.setCustomerNumber(existingCustomer.getCustomerNumber());
            }
            customer.setVersionNumber(existingCustomer.getVersionNumber());
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerTypeCode");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerTaxTypeCode");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerTaxNbr");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerCreditLimitAmount");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerCreditApprovedByName");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerParentCompanyNumber");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerPhoneNumber");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customer800PhoneNumber");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerContactName");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerContactPhoneNumber");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerFaxNumber");
            this.dontBlankOutFieldsOnUpdate(customer, existingCustomer, "customerBirthDate");
        }
        this.upperCaseKeyFields(customer);
        boolean batchHasPrimaryAddress = false;
        for (CustomerAddress address : customer.getCustomerAddresses()) {
            if (!"P".equalsIgnoreCase(address.getCustomerAddressTypeCode())) continue;
            batchHasPrimaryAddress = true;
        }
        if (isUpdate) {
            List<CustomerAddress> newCustomerAddresses = customer.getCustomerAddresses();
            ArrayList<CustomerAddress> stubAddresses = new ArrayList<CustomerAddress>();
            for (CustomerAddress batchAddress : newCustomerAddresses) {
                stubAddresses.add(new CustomerAddress());
            }
            for (CustomerAddress existingAddress : existingCustomer.getCustomerAddresses()) {
                boolean addressInBatchCustomer = false;
                for (CustomerAddress batchAddress : newCustomerAddresses) {
                    if (addressInBatchCustomer || existingAddress.compareTo(batchAddress) != 0) continue;
                    addressInBatchCustomer = true;
                }
                if (!addressInBatchCustomer) {
                    CustomerAddress clonedExistingAddress = this.cloneCustomerAddress(existingAddress);
                    if (batchHasPrimaryAddress && "P".equalsIgnoreCase(clonedExistingAddress.getCustomerAddressTypeCode())) {
                        clonedExistingAddress.setCustomerAddressTypeCode("A");
                    }
                    customer.getCustomerAddresses().add(clonedExistingAddress);
                    continue;
                }
                stubAddresses.remove(0);
            }
            stubAddresses.addAll(existingCustomer.getCustomerAddresses());
            existingCustomer.setCustomerAddresses(stubAddresses);
        }
        if (StringUtils.isBlank((CharSequence)customer.getCustomerParentCompanyNumber())) {
            customer.setCustomerParentCompanyNumber(null);
        }
    }

    private CustomerAddress cloneCustomerAddress(CustomerAddress address) {
        CustomerAddress clonedAddress;
        try {
            clonedAddress = (CustomerAddress)BeanUtils.cloneBean((Object)address);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error("Unable to clone address [{}]", (Object)address, (Object)ex);
            throw new RuntimeException("Unable to clone address [" + address + "]", ex);
        }
        return clonedAddress;
    }

    protected void upperCaseKeyFields(Customer customer) {
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerName())) {
            customer.setCustomerName(customer.getCustomerName().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerNumber())) {
            customer.setCustomerNumber(customer.getCustomerNumber().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerParentCompanyNumber())) {
            customer.setCustomerParentCompanyNumber(customer.getCustomerParentCompanyNumber().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerTaxTypeCode())) {
            customer.setCustomerTaxTypeCode(customer.getCustomerTaxTypeCode().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerTaxNbr())) {
            customer.setCustomerTaxNbr(customer.getCustomerTaxNbr().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerContactName())) {
            customer.setCustomerContactName(customer.getCustomerContactName().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerCreditApprovedByName())) {
            customer.setCustomerCreditApprovedByName(customer.getCustomerCreditApprovedByName().toUpperCase(Locale.US));
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerEmailAddress())) {
            customer.setCustomerEmailAddress(customer.getCustomerEmailAddress().toUpperCase(Locale.US));
        }
        for (CustomerAddress address : customer.getCustomerAddresses()) {
            if (address == null) continue;
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerNumber())) {
                address.setCustomerNumber(address.getCustomerNumber().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerAddressName())) {
                address.setCustomerAddressName(address.getCustomerAddressName().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerLine1StreetAddress())) {
                address.setCustomerLine1StreetAddress(address.getCustomerLine1StreetAddress().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerLine2StreetAddress())) {
                address.setCustomerLine2StreetAddress(address.getCustomerLine2StreetAddress().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerCityName())) {
                address.setCustomerCityName(address.getCustomerCityName().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerStateCode())) {
                address.setCustomerStateCode(address.getCustomerStateCode().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerZipCode())) {
                address.setCustomerZipCode(address.getCustomerZipCode().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerNumber())) {
                address.setCustomerNumber(address.getCustomerNumber().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerAddressInternationalProvinceName())) {
                address.setCustomerAddressInternationalProvinceName(address.getCustomerAddressInternationalProvinceName().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerInternationalMailCode())) {
                address.setCustomerInternationalMailCode(address.getCustomerInternationalMailCode().toUpperCase(Locale.US));
            }
            if (StringUtils.isNotBlank((CharSequence)address.getCustomerAddressTypeCode())) {
                address.setCustomerAddressTypeCode(address.getCustomerAddressTypeCode().toUpperCase(Locale.US));
            }
            address.getCustomerAddressEmails().forEach(customerAddressEmail -> customerAddressEmail.setCustomerEmailAddress(customerAddressEmail.getCustomerEmailAddress().toUpperCase(Locale.US)));
        }
    }

    protected void dontBlankOutFieldsOnUpdate(Customer batchCustomer, Customer existingCustomer, String propertyName) {
        try {
            Class propertyClass = PropertyUtils.getPropertyType((Object)((Object)batchCustomer), (String)propertyName);
            if (propertyClass == null) {
                throw new IllegalArgumentException("The propertyName specified [" + propertyName + "] doesn't exist on the Customer object.");
            }
            String batchValue = BeanUtils.getSimpleProperty((Object)((Object)batchCustomer), (String)propertyName);
            String existingValue = BeanUtils.getSimpleProperty((Object)((Object)existingCustomer), (String)propertyName);
            if (StringUtils.isBlank((CharSequence)batchValue) && StringUtils.isNotBlank((CharSequence)existingValue)) {
                Object typedValue = PropertyUtils.getProperty((Object)((Object)existingCustomer), (String)propertyName);
                BeanUtils.setProperty((Object)((Object)batchCustomer), (String)propertyName, (Object)typedValue);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Could not set properties on the Customer object", ex);
        }
    }

    protected boolean validateSingle(MaintenanceDocument maintDoc, CustomerLoadBatchErrors batchErrors, String customerName) {
        CustomerRule rule = new CustomerRule();
        boolean result = rule.processRouteDocument((org.kuali.kfs.krad.document.Document)maintDoc);
        this.extractGlobalVariableErrors(batchErrors, customerName);
        return result;
    }

    protected boolean extractGlobalVariableErrors(CustomerLoadBatchErrors batchErrors, String customerName) {
        boolean result = true;
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Set errorKeys = messageMap.getAllPropertiesWithErrors();
        for (String errorProperty : errorKeys) {
            AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty(errorProperty);
            for (ErrorMessage errorMessage : errorMessages) {
                String errorKeyString = this.configService.getPropertyValueAsString(errorMessage.getErrorKey());
                Object[] messageParams = errorMessage.getMessageParameters();
                String errorString = StringUtils.isBlank((CharSequence)errorKeyString) ? errorMessage.getErrorKey() : errorKeyString;
                while (errorString.matches("^.*\\{\\d\\}.*$")) {
                    errorString = MessageFormat.format(errorString, messageParams);
                }
                batchErrors.addError(customerName, errorProperty, Object.class, "", errorString);
                result = false;
            }
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        return result;
    }

    protected MaintenanceDocument createTransientMaintDoc() {
        return new MaintenanceDocumentBase(this.getCustomerMaintenanceDocumentTypeName());
    }

    protected MaintenanceDocument createRealMaintDoc(MaintenanceDocument document) {
        if (document == null) {
            document = (MaintenanceDocument)this.docService.getNewDocument(this.getCustomerMaintenanceDocumentTypeName());
        }
        return document;
    }

    protected Customer customerAlreadyExists(Customer customer) {
        Customer existingCustomer = null;
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerNumber()) && (existingCustomer = this.customerService.getByPrimaryKey(customer.getCustomerNumber())) != null) {
            return existingCustomer;
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerTaxNbr()) && (existingCustomer = this.customerService.getByTaxNumber(customer.getCustomerTaxNbr())) != null) {
            return existingCustomer;
        }
        if (StringUtils.isNotBlank((CharSequence)customer.getCustomerName()) && (existingCustomer = this.customerService.getCustomerByName(customer.getCustomerName())) != null) {
            return existingCustomer;
        }
        return existingCustomer;
    }

    protected void writeReportPDF(List<CustomerLoadFileResult> fileResults) {
        if (fileResults.isEmpty()) {
            return;
        }
        try (Document pdfDoc = new Document(PageSize.LETTER, 54.0f, 54.0f, 72.0f, 72.0f);){
            this.getPdfWriter(pdfDoc);
            pdfDoc.open();
            if (fileResults.isEmpty()) {
                this.writeFileNameSectionTitle(pdfDoc, "NO DOCUMENTS FOUND TO PROCESS");
                return;
            }
            for (CustomerLoadFileResult fileResult : fileResults) {
                String fileNameOnly = fileResult.getFilename().toUpperCase(Locale.US);
                fileNameOnly = fileNameOnly.substring(fileNameOnly.lastIndexOf("\\") + 1);
                this.writeFileNameSectionTitle(pdfDoc, fileNameOnly);
                this.writeMessageEntryLines(pdfDoc, fileResult.getMessages());
                for (String customerName : fileResult.getCustomerNames()) {
                    CustomerLoadResult result = fileResult.getCustomer(customerName);
                    this.writeCustomerSectionTitle(pdfDoc, customerName.toUpperCase(Locale.US));
                    String customerResultLine = result.getResultString() + (String)(CustomerLoadResult.ResultCode.SUCCESS.equals((Object)result.getResult()) ? WORKFLOW_DOC_ID_PREFIX + result.getWorkflowDocId() : "");
                    this.writeCustomerSectionResult(pdfDoc, customerResultLine);
                    this.writeMessageEntryLines(pdfDoc, result.getMessages());
                }
            }
        }
        catch (DocumentException | IOException ex) {
            throw new RuntimeException("Could not open file for results report", ex);
        }
    }

    protected void writeFileNameSectionTitle(Document pdfDoc, String filenameLine) {
        Font font = FontFactory.getFont((String)"Courier", (float)10.0f, (int)1);
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        Chunk chunk = new Chunk(filenameLine, font);
        chunk.setBackground(Color.LIGHT_GRAY, 5.0f, 5.0f, 5.0f, 5.0f);
        paragraph.add((Element)chunk);
        paragraph.add((Element)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error("iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    protected void writeCustomerSectionTitle(Document pdfDoc, String customerNameLine) {
        Font font = FontFactory.getFont((String)"Courier", (float)8.0f, (int)5);
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        paragraph.add((Element)new Chunk(customerNameLine, font));
        paragraph.add((Element)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error("iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    protected void writeCustomerSectionResult(Document pdfDoc, String resultLine) {
        Font font = FontFactory.getFont((String)"Courier", (float)8.0f, (int)1);
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        paragraph.add((Element)new Chunk(resultLine, font));
        paragraph.add((Element)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error("iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    protected void writeMessageEntryLines(Document pdfDoc, List<String[]> messageLines) {
        Font font = FontFactory.getFont((String)"Courier", (float)8.0f, (int)0);
        for (String[] messageLine : messageLines) {
            Paragraph paragraph = new Paragraph();
            paragraph.setAlignment(0);
            String messageEntry = StringUtils.rightPad((String)messageLine[0], (int)(12 - messageLine[0].length()), (String)" ") + " - " + messageLine[1].toUpperCase(Locale.US);
            paragraph.add((Element)new Chunk(messageEntry, font));
            paragraph.add((Element)new Chunk("", font));
            try {
                pdfDoc.add((Element)paragraph);
            }
            catch (DocumentException e) {
                LOG.error("iText DocumentException thrown when trying to write content.", (Throwable)e);
                throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
            }
        }
    }

    protected void getPdfWriter(Document pdfDoc) throws IOException, DocumentException {
        String reportDropFolder = this.reportsDirectory + "/ar/";
        String fileName = "ar_customer_load_" + new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(this.dateTimeService.getCurrentDate()) + ".pdf";
        File reportFile = new File(reportDropFolder + fileName);
        FileOutputStream fileOutStream = new FileOutputStream(reportFile);
        BufferedOutputStream buffOutStream = new BufferedOutputStream(fileOutStream);
        PdfWriter.getInstance((Document)pdfDoc, (OutputStream)buffOutStream);
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public void setConfigService(ConfigurationService configService) {
        this.configService = configService;
    }

    public void setDocService(DocumentService docService) {
        this.docService = docService;
    }

    public void setBatchInputFileTypes(List<BatchInputFileType> batchInputFileType) {
        this.batchInputFileTypes = batchInputFileType;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    @Override
    public String getFileName(String principalName, String fileUserIdentifer, String prefix, String delim) {
        StringBuilder fileName = new StringBuilder(delim);
        fileName.append(delim).append(principalName);
        if (StringUtils.isNotBlank((CharSequence)fileUserIdentifer)) {
            fileName.append(delim).append(fileUserIdentifer);
        }
        fileName.append(delim).append(this.dateTimeService.toString((Date)this.dateTimeService.getCurrentTimestamp(), "yyyyMMdd_HHmmss"));
        return StringUtils.remove((String)fileName.toString(), (String)" ");
    }

    private void criticalError(String errorMessage) {
        LOG.error(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    public List<String> getRequiredDirectoryNames() {
        ArrayList<String> directoryNames = new ArrayList<String>();
        if (ObjectUtils.isNotNull(this.batchInputFileTypes) && !CollectionUtils.isEmpty(this.batchInputFileTypes)) {
            for (BatchInputFileType batchInputFileType : this.batchInputFileTypes) {
                directoryNames.add(batchInputFileType.getDirectoryPath());
            }
        }
        return directoryNames;
    }

    public void setAdapter(CustomerVOAdapter adapter) {
        this.adapter = adapter;
    }
}

