/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;

public class ContractsGrantsInvoiceLookupResultAward
extends TransientBusinessObjectBase
implements Billable {
    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private String billingFrequencyCode;
    private String instrumentTypeDescription;
    private String invoicingOptionDescription;
    private KualiDecimal awardTotalAmount = KualiDecimal.ZERO;

    public ContractsGrantsInvoiceLookupResultAward() {
    }

    public ContractsGrantsInvoiceLookupResultAward(ContractsAndGrantsBillingAward award, ContractsAndGrantsBillingAwardAccount awardAccount) {
        this.setProposalNumber(award.getProposalNumber());
        this.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        this.setAccountNumber(awardAccount.getAccountNumber());
        this.setAwardBeginningDate(award.getAwardBeginningDate());
        this.setAwardEndingDate(award.getAwardEndingDate());
        this.setBillingFrequencyCode(award.getBillingFrequencyCode());
        this.setInvoicingOptionDescription(award.getInvoicingOptionDescription());
        this.setAwardTotalAmount(award.getAwardTotalAmount());
        if (ObjectUtils.isNotNull((Object)award.getInstrumentType())) {
            this.setInstrumentTypeDescription(award.getInstrumentType().getInstrumentTypeDescription());
        }
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Date getAwardBeginningDate() {
        return this.awardBeginningDate;
    }

    public void setAwardBeginningDate(Date awardBeginningDate) {
        this.awardBeginningDate = awardBeginningDate;
    }

    public Date getAwardEndingDate() {
        return this.awardEndingDate;
    }

    public void setAwardEndingDate(Date awardEndingDate) {
        this.awardEndingDate = awardEndingDate;
    }

    public String getBillingFrequencyCode() {
        return this.billingFrequencyCode;
    }

    public void setBillingFrequencyCode(String billingFrequencyCode) {
        this.billingFrequencyCode = billingFrequencyCode;
    }

    public String getInstrumentTypeDescription() {
        return this.instrumentTypeDescription;
    }

    public void setInstrumentTypeDescription(String instrumentTypeDescription) {
        this.instrumentTypeDescription = instrumentTypeDescription;
    }

    public String getInvoicingOptionDescription() {
        return this.invoicingOptionDescription;
    }

    public void setInvoicingOptionDescription(String invoicingOptionDescription) {
        this.invoicingOptionDescription = invoicingOptionDescription;
    }

    public KualiDecimal getAwardTotalAmount() {
        return this.awardTotalAmount;
    }

    public void setAwardTotalAmount(KualiDecimal awardTotalAmount) {
        this.awardTotalAmount = awardTotalAmount;
    }

    public String getObjectId() {
        if (ArConstants.BillingFrequencyValues.isMilestone(this) || ArConstants.BillingFrequencyValues.isPredeterminedBilling(this)) {
            return this.proposalNumber + "-" + this.chartOfAccountsCode + "-" + this.accountNumber;
        }
        return this.proposalNumber + "-*-*";
    }
}

