/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;

public class WriteoffTaxCustomerInvoiceDetail
extends CustomerInvoiceDetail {
    private final CustomerInvoiceDetail postable;
    private final CustomerInvoiceWriteoffDocument poster;
    private final boolean isUsingTaxLiabilityAdjustmentIndNo;

    public WriteoffTaxCustomerInvoiceDetail(CustomerInvoiceDetail postable, CustomerInvoiceWriteoffDocument poster) {
        this.postable = postable;
        this.poster = poster;
        String writeoffTaxGenerationOption = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "SALES_TAX_ADJUSTMENT_IND");
        this.isUsingTaxLiabilityAdjustmentIndNo = "N".equals(writeoffTaxGenerationOption);
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            this.poster.refreshReferenceObject("account");
            this.poster.refreshReferenceObject("chartOfAccounts");
            this.poster.refreshReferenceObject("subAccount");
            this.poster.refreshReferenceObject("financialObject");
            this.poster.refreshReferenceObject("financialSubObject");
            this.poster.refreshReferenceObject("project");
        } else {
            this.postable.refreshNonUpdateableReferences();
        }
    }

    public Account getAccount() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getAccount();
        }
        return this.postable.getAccount();
    }

    public String getAccountNumber() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getAccountNumber();
        }
        return this.postable.getAccountNumber();
    }

    public KualiDecimal getAmount() {
        return this.postable.getAmountOpen();
    }

    public String getChartOfAccountsCode() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getChartOfAccountsCode();
        }
        return this.postable.getChartOfAccountsCode();
    }

    public String getDocumentNumber() {
        return this.postable.getDocumentNumber();
    }

    public String getFinancialDocumentLineDescription() {
        return this.postable.getFinancialDocumentLineDescription();
    }

    public String getFinancialObjectCode() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getFinancialObjectCode();
        }
        return this.postable.getAccountsReceivableObjectCode();
    }

    public ObjectCode getObjectCode() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getFinancialObject();
        }
        return this.postable.getAccountsReceivableObject();
    }

    public String getFinancialSubObjectCode() {
        return AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode();
    }

    public String getOrganizationReferenceId() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getOrganizationReferenceIdentifier();
        }
        return this.postable.getOrganizationReferenceId();
    }

    public String getProjectCode() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getProjectCode();
        }
        return this.postable.getProjectCode();
    }

    public String getSubAccountNumber() {
        if (this.isUsingTaxLiabilityAdjustmentIndNo) {
            return this.poster.getSubAccountNumber();
        }
        return this.postable.getSubAccountNumber();
    }
}

