/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.datadictionary.Action;
import org.kuali.kfs.datadictionary.ActionType;
import org.kuali.kfs.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.TemplateBase;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.businessobject.actions.BusinessObjectActionsProvider;

public class TemplateActionsProvider
extends BusinessObjectActionsProvider {
    private KualiModuleService kualiModuleService;
    private String baseUrl;
    private String templateCodeKey;

    public List<Action> getActionLinks(BusinessObjectBase businessObject, Person user) {
        List actionLinks = super.getActionLinks(businessObject, user);
        BusinessObjectAdminService businessObjectAdminService = this.businessObjectDictionaryService.getBusinessObjectAdminService(businessObject.getClass());
        BusinessObjectEntry businessObjectEntry = this.businessObjectDictionaryService.getBusinessObjectEntry(businessObject.getClass().getName());
        if (businessObjectEntry.supportsAction(ActionType.EDIT) && businessObjectAdminService.allowsEdit(businessObject, user)) {
            String uploadUrl = this.generateUploadUrl(businessObject);
            Action upAction = new Action("Upload", "GET", uploadUrl);
            actionLinks.add(upAction);
            if (this.templateFileExists(((TemplateBase)businessObject).getFilename())) {
                String downloadUrl = this.generateDownloadUrl(businessObject);
                Action downAction = new Action("Download", "GET", downloadUrl);
                actionLinks.add(downAction);
            }
        }
        return actionLinks;
    }

    private String generateUploadUrl(BusinessObjectBase businessObject) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "start");
        parameters.put(this.templateCodeKey, ((TemplateBase)businessObject).getTemplateCode());
        return UrlFactory.parameterizeUrl((String)this.baseUrl, parameters);
    }

    private String generateDownloadUrl(BusinessObjectBase businessObject) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "download");
        parameters.put("fileName", ((TemplateBase)businessObject).getFilename());
        return UrlFactory.parameterizeUrl((String)this.baseUrl, parameters);
    }

    private boolean templateFileExists(String fileName) {
        ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
        String templateFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getTemplateFileDirectories().get("templates.directory");
        String filePath = templateFolderPath + File.separator + fileName;
        return new File(filePath).isFile();
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setTemplateCodeKey(String templateCodeKey) {
        this.templateCodeKey = templateCodeKey;
    }
}

