/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionActivityReport;
import org.kuali.kfs.module.ar.businessobject.lookup.CollectionsReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.report.service.CollectionActivityReportService;

public class CollectionActivityReportLookupableHelperServiceImpl
extends CollectionsReportLookupableHelperServiceImplBase {
    protected CollectionActivityReportService collectionActivityReportService;

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        List<CollectionActivityReport> results = this.collectionActivityReportService.filterEventsForCollectionActivity(fieldValues);
        return new CollectionIncomplete(results, Long.valueOf(results.size()));
    }

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        List<? extends BusinessObject> displayList = this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        boolean hasReturnableRow = false;
        Person user = GlobalVariables.getUserSession().getPerson();
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        for (BusinessObject businessObject : displayList) {
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)businessObject, user);
            if (ObjectUtils.isNotNull((Object)this.getColumns())) {
                List columns = this.getColumns();
                for (Object column : columns) {
                    Column col = (Column)column;
                    Formatter formatter = col.getFormatter();
                    Object prop = ObjectUtils.getPropertyValue((Object)businessObject, (String)col.getPropertyName());
                    String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)businessObject, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                    Class propClass = this.getPropertyClass(businessObject, col.getPropertyName());
                    if (ObjectUtils.isNotNull((Object)prop)) {
                        propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                    }
                    col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                    col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                    propValue = super.maskValueIfNecessary(businessObject, col.getPropertyName(), propValue, businessObjectRestrictions);
                    col.setPropertyValue(propValue);
                    if (col.getPropertyName().equals("invoiceNumber")) {
                        String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                        HashMap<String, String> fieldList = new HashMap<String, String>();
                        fieldList.put("invoiceNumber", propValue);
                        HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                        a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(this.getBusinessObjectClass()), (Class)this.getBusinessObjectClass(), fieldList));
                        col.setColumnAnchor((HtmlData)a);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                    col.setColumnAnchor(this.getInquiryUrl(businessObject, col.getPropertyName()));
                }
                ResultRow row = new ResultRow(columns, "", this.getActionUrls(businessObject, pkNames, businessObjectRestrictions));
                if (businessObject instanceof PersistableBusinessObject) {
                    row.setObjectId(((PersistableBusinessObject)businessObject).getObjectId());
                }
                boolean rowReturnable = this.isResultReturnable(businessObject);
                row.setRowReturnable(rowReturnable);
                if (rowReturnable) {
                    hasReturnableRow = true;
                }
                resultTable.add(row);
            }
            lookupForm.setHasReturnableRow(hasReturnableRow);
        }
        return displayList;
    }

    public CollectionActivityReportService getCollectionActivityReportService() {
        return this.collectionActivityReportService;
    }

    public void setCollectionActivityReportService(CollectionActivityReportService collectionActivityReportService) {
        this.collectionActivityReportService = collectionActivityReportService;
    }
}

