/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.dao.LookupDao;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceReport;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;

public class ContractsGrantsInvoiceReportLookupableHelperServiceImpl
extends ContractsGrantsReportLookupableHelperServiceImplBase {
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected DateTimeService dateTimeService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    private LookupDao lookupDao;

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        this.validateSearchParametersForOperatorAndValue(fieldValues, "ageInDays");
        this.validateSearchParametersForOperatorAndValue(fieldValues, "remainingAmount");
        String upperBoundInvoiceDueDate = fieldValues.get("invoiceDueDate");
        this.validateDateField(upperBoundInvoiceDueDate, "invoiceDueDate", this.getDateTimeService());
        String lowerBoundInvoiceDueDate = fieldValues.get("rangeLowerBoundKeyPrefix_invoiceDueDate");
        this.validateDateField(lowerBoundInvoiceDueDate, "rangeLowerBoundKeyPrefix_invoiceDueDate", this.getDateTimeService());
        String lowerBoundInvoiceDate = fieldValues.get("rangeLowerBoundKeyPrefix_invoiceDate");
        this.validateDateField(lowerBoundInvoiceDate, "rangeLowerBoundKeyPrefix_invoiceDate", this.getDateTimeService());
        String upperBoundInvoiceDate = fieldValues.get("invoiceDate");
        this.validateDateField(upperBoundInvoiceDate, "invoiceDate", this.getDateTimeService());
    }

    public Collection<ContractsGrantsInvoiceReport> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<ContractsGrantsInvoiceReport> displayList = new ArrayList<ContractsGrantsInvoiceReport>();
        Map<String, String> invoiceLookupFields = this.buildCriteriaForInvoiceLookup(lookupFormFields);
        invoiceLookupFields.put("openInvoiceIndicator", "Y");
        invoiceLookupFields.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.getFinancialSystemDocumentService().getSuccessfulDocumentStatuses(), (String)SearchOperator.OR.op()));
        ArrayList<CustomerInvoiceDocument> openInvoiceDocs = new ArrayList<CustomerInvoiceDocument>();
        if (GlobalVariables.getMessageMap().getErrorCount() == 0) {
            openInvoiceDocs.addAll(this.findInvoiceDocs(invoiceLookupFields));
        }
        String invoiceReportOption = (String)lookupForm.getFields().get("dummyBusinessObject.invoiceReportOption");
        java.util.Date today = new java.util.Date();
        ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue ageInDaysOperator = this.buildOperatorAndValueFromField(lookupFormFields, "ageInDays");
        ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue remainingAmountOperator = this.buildOperatorAndValueFromField(lookupFormFields, "remainingAmount");
        for (CustomerInvoiceDocument openCGInvoiceDoc : openInvoiceDocs) {
            if (invoiceReportOption.equals("Past Due Invoices") && !openCGInvoiceDoc.getInvoiceDueDate().before(today) || ObjectUtils.isNotNull((Object)ageInDaysOperator) && !ageInDaysOperator.applyComparison(openCGInvoiceDoc.getAge())) continue;
            KualiDecimal paymentAmount = this.getCustomerInvoiceDocumentService().calculateAppliedPaymentAmount(openCGInvoiceDoc);
            KualiDecimal remainingAmount = (KualiDecimal)openCGInvoiceDoc.getDocumentHeader().getFinancialDocumentTotalAmount().subtract((AbstractKualiDecimal)paymentAmount);
            if (ObjectUtils.isNotNull((Object)remainingAmountOperator) && !remainingAmountOperator.applyComparison((Number)remainingAmount)) continue;
            ContractsGrantsInvoiceReport cgInvoiceReport = new ContractsGrantsInvoiceReport();
            cgInvoiceReport.setDocumentNumber(openCGInvoiceDoc.getDocumentNumber());
            if (openCGInvoiceDoc instanceof ContractsGrantsInvoiceDocument) {
                cgInvoiceReport.setProposalNumber(((ContractsGrantsInvoiceDocument)openCGInvoiceDoc).getInvoiceGeneralDetail().getProposalNumber());
            }
            DocumentHeader documentHeader = openCGInvoiceDoc.getDocumentHeader();
            cgInvoiceReport.setInvoiceType(documentHeader.getWorkflowDocumentTypeName());
            Timestamp docCreateDate = documentHeader.getWorkflowCreateDate();
            cgInvoiceReport.setInvoiceDate(new Date(((java.util.Date)docCreateDate).getTime()));
            cgInvoiceReport.setInvoiceDueDate(openCGInvoiceDoc.getInvoiceDueDate());
            if (openCGInvoiceDoc.isOpenInvoiceIndicator()) {
                cgInvoiceReport.setOpenInvoiceIndicator("Open");
            } else {
                cgInvoiceReport.setOpenInvoiceIndicator("Close");
            }
            cgInvoiceReport.setCustomerNumber(openCGInvoiceDoc.getAccountsReceivableDocumentHeader().getCustomerNumber());
            cgInvoiceReport.setCustomerName(openCGInvoiceDoc.getAccountsReceivableDocumentHeader().getCustomer().getCustomerName());
            cgInvoiceReport.setInvoiceAmount(documentHeader.getFinancialDocumentTotalAmount());
            cgInvoiceReport.setPaymentAmount(paymentAmount);
            cgInvoiceReport.setRemainingAmount(remainingAmount);
            if (openCGInvoiceDoc.getAge() != null) {
                cgInvoiceReport.setAgeInDays(openCGInvoiceDoc.getAge().longValue());
            }
            displayList.add(cgInvoiceReport);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    private List<CustomerInvoiceDocument> findInvoiceDocs(Map<String, String> invoiceLookupFields) {
        ArrayList<CustomerInvoiceDocument> openInvoiceDocs = new ArrayList<CustomerInvoiceDocument>();
        boolean docTypeCriteriaSpecified = invoiceLookupFields.containsKey("documentHeader.workflowDocumentTypeName");
        if (!docTypeCriteriaSpecified) {
            invoiceLookupFields.put("documentHeader.workflowDocumentTypeName", "INV");
        }
        if (StringUtils.equals((CharSequence)invoiceLookupFields.get("documentHeader.workflowDocumentTypeName"), (CharSequence)"INV") && !invoiceLookupFields.containsKey("invoiceGeneralDetail.proposalNumber")) {
            openInvoiceDocs.addAll(this.lookupDao.findCollectionBySearchHelper(CustomerInvoiceDocument.class, invoiceLookupFields, true, false));
        }
        if (!docTypeCriteriaSpecified) {
            invoiceLookupFields.put("documentHeader.workflowDocumentTypeName", "CINV");
        }
        if (StringUtils.equals((CharSequence)invoiceLookupFields.get("documentHeader.workflowDocumentTypeName"), (CharSequence)"CINV")) {
            openInvoiceDocs.addAll(this.lookupDao.findCollectionBySearchHelper(ContractsGrantsInvoiceDocument.class, invoiceLookupFields, true, false));
        }
        return openInvoiceDocs;
    }

    private Map<String, String> buildCriteriaForInvoiceLookup(Map lookupFormFields) {
        String documentNumber;
        String proposalNumber;
        String invoiceType;
        String customerNumber;
        String invoiceAmount;
        HashMap<String, String> lookupFields = new HashMap<String, String>();
        String lowerBoundInvoiceDate = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_invoiceDate");
        String upperBoundInvoiceDate = (String)lookupFormFields.get("invoiceDate");
        String invoiceDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(lowerBoundInvoiceDate, upperBoundInvoiceDate, true);
        if (StringUtils.isNotBlank((CharSequence)invoiceDateCriteria)) {
            lookupFields.put("documentHeader.workflowCreateDate", invoiceDateCriteria);
        }
        if (StringUtils.isNotBlank((CharSequence)(invoiceAmount = (String)lookupFormFields.get("invoiceAmount")))) {
            lookupFields.put("documentHeader.financialDocumentTotalAmount", invoiceAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)(customerNumber = (String)lookupFormFields.get("customerNumber")))) {
            lookupFields.put("accountsReceivableDocumentHeader.customerNumber", customerNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(invoiceType = (String)lookupFormFields.get("invoiceType")))) {
            lookupFields.put("documentHeader.workflowDocumentTypeName", invoiceType);
        }
        String upperBoundInvoiceDueDate = (String)lookupFormFields.get("invoiceDueDate");
        String lowerBoundInvoiceDueDate = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_invoiceDueDate");
        String invoiceDueDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(lowerBoundInvoiceDueDate, upperBoundInvoiceDueDate, false);
        if (StringUtils.isNotBlank((CharSequence)invoiceDueDateCriteria)) {
            lookupFields.put("invoiceDueDate", invoiceDueDateCriteria);
        }
        if (StringUtils.isNotBlank((CharSequence)(proposalNumber = (String)lookupFormFields.get("proposalNumber")))) {
            lookupFields.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(documentNumber = (String)lookupFormFields.get("documentNumber")))) {
            lookupFields.put("documentNumber", documentNumber);
        }
        return lookupFields;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }
}

