/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsMilestoneReport;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsReportLookupableHelperServiceImplBase;

public class ContractsGrantsMilestoneReportLookupableHelperServiceImpl
extends ContractsGrantsReportLookupableHelperServiceImplBase {
    protected DateTimeService dateTimeService;

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<ContractsGrantsMilestoneReport> displayList = new ArrayList<ContractsGrantsMilestoneReport>();
        Map<String, String> lookupCriteria = this.buildCriteriaForLookup(lookupFormFields);
        Collection milestones = this.getLookupService().findCollectionBySearchHelper(Milestone.class, lookupCriteria, true);
        String awardChartOfAccountsCode = (String)lookupFormFields.get("chartOfAccountsCode");
        String awardAccountNumber = (String)lookupFormFields.get("accountNumber");
        for (Milestone milestone : milestones) {
            if (!this.isMilestoneMatchesChart(milestone, awardChartOfAccountsCode) || !this.isMilestoneMatchesAccount(milestone, awardAccountNumber)) continue;
            ContractsGrantsMilestoneReport cgMilestoneReport = new ContractsGrantsMilestoneReport();
            cgMilestoneReport.setProposalNumber(milestone.getProposalNumber());
            cgMilestoneReport.setAccountNumber(milestone.getAccountNumber());
            cgMilestoneReport.setChartOfAccountsCode(milestone.getChartOfAccountsCode());
            cgMilestoneReport.setMilestoneNumber(milestone.getMilestoneNumber());
            cgMilestoneReport.setMilestoneExpectedCompletionDate(milestone.getMilestoneExpectedCompletionDate());
            cgMilestoneReport.setMilestoneActualCompletionDate(milestone.getMilestoneActualCompletionDate());
            List<InvoiceMilestone> invoiceMilestones = milestone.getInvoiceMilestones();
            if (milestone.isBilled() && CollectionUtils.isNotEmpty(invoiceMilestones)) {
                Long latestDocumentNumber = invoiceMilestones.stream().mapToLong(m -> Long.parseLong(m.getDocumentNumber())).max().getAsLong();
                cgMilestoneReport.setDocumentNumber(String.valueOf(latestDocumentNumber));
            }
            cgMilestoneReport.setMilestoneAmount(milestone.getMilestoneAmount());
            cgMilestoneReport.setBilled(milestone.isBilled());
            cgMilestoneReport.setActive(milestone.isActive());
            displayList.add(cgMilestoneReport);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    protected Map<String, String> buildCriteriaForLookup(Map lookupFormFields) {
        String chartOfAccountsCode;
        String accountNumber;
        String active;
        String billed;
        HashMap<String, String> lookupCriteria = new HashMap<String, String>();
        String proposalNumber = (String)lookupFormFields.get("proposalNumber");
        if (StringUtils.isNotBlank((CharSequence)proposalNumber)) {
            lookupCriteria.put("proposalNumber", proposalNumber);
        }
        String lowerBoundMilestoneExpectedCompletionDate = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_milestoneExpectedCompletionDate");
        String upperBoundMilestoneExpectedCompletionDate = (String)lookupFormFields.get("milestoneExpectedCompletionDate");
        String milestoneExpectedCompletionDate = this.getContractsGrantsReportHelperService().fixDateCriteria(lowerBoundMilestoneExpectedCompletionDate, upperBoundMilestoneExpectedCompletionDate, false);
        if (StringUtils.isNotBlank((CharSequence)milestoneExpectedCompletionDate)) {
            lookupCriteria.put("milestoneExpectedCompletionDate", milestoneExpectedCompletionDate);
        }
        String lowerBoundMilestoneActualCompletionDate = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_milestoneActualCompletionDate");
        String upperBoundMilestoneActualCompletionDate = (String)lookupFormFields.get("milestoneActualCompletionDate");
        String milestoneActualCompletionDate = this.getContractsGrantsReportHelperService().fixDateCriteria(lowerBoundMilestoneActualCompletionDate, upperBoundMilestoneActualCompletionDate, false);
        if (StringUtils.isNotBlank((CharSequence)milestoneActualCompletionDate)) {
            lookupCriteria.put("milestoneActualCompletionDate", milestoneActualCompletionDate);
        }
        if (StringUtils.isNotBlank((CharSequence)(billed = (String)lookupFormFields.get("billed")))) {
            lookupCriteria.put("billed", billed);
        }
        if (StringUtils.isNotBlank((CharSequence)(active = (String)lookupFormFields.get("active")))) {
            lookupCriteria.put("active", active);
        }
        if (StringUtils.isNotBlank((CharSequence)(accountNumber = (String)lookupFormFields.get("accountNumber")))) {
            lookupCriteria.put("accountNumber", accountNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(chartOfAccountsCode = (String)lookupFormFields.get("chartOfAccountsCode")))) {
            lookupCriteria.put("chartOfAccountsCode", chartOfAccountsCode);
        }
        return lookupCriteria;
    }

    protected boolean isMilestoneMatchesChart(Milestone milestone, String chartOfAccountsCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            return true;
        }
        if (ObjectUtils.isNull((Object)milestone.getAward()) || ObjectUtils.isNull((Object)milestone.getAward().getActiveAwardAccounts()) || milestone.getAward().getActiveAwardAccounts().isEmpty()) {
            return true;
        }
        Pattern chartRegex = this.convertWildcardsToPattern(chartOfAccountsCode);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : milestone.getAward().getActiveAwardAccounts()) {
            Matcher chartMatch = chartRegex.matcher(awardAccount.getChartOfAccountsCode());
            if (!chartMatch.matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isMilestoneMatchesAccount(Milestone milestone, String accountNumber) {
        if (StringUtils.isBlank((CharSequence)accountNumber)) {
            return true;
        }
        if (ObjectUtils.isNull((Object)milestone.getAward()) || ObjectUtils.isNull((Object)milestone.getAward().getActiveAwardAccounts()) || milestone.getAward().getActiveAwardAccounts().isEmpty()) {
            return true;
        }
        Pattern accountRegex = this.convertWildcardsToPattern(accountNumber);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : milestone.getAward().getActiveAwardAccounts()) {
            Matcher accountMatch = accountRegex.matcher(awardAccount.getAccountNumber());
            if (!accountMatch.matches()) continue;
            return true;
        }
        return false;
    }

    protected Pattern convertWildcardsToPattern(String lookupFieldValue) {
        String lookupFieldValueRegex = lookupFieldValue.replaceAll("\\*", ".+");
        return Pattern.compile(lookupFieldValueRegex);
    }

    @Override
    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        for (Object entry : displayList) {
            BusinessObject element = (BusinessObject)entry;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                String propertyName = col.getPropertyName();
                if ("proposalNumber".equals(propertyName)) {
                    col.setColumnAnchor((HtmlData)this.generateInquiryUrl(ContractsAndGrantsBillingAward.class, element, "proposalNumber"));
                }
                if ("chartOfAccountsCode".equals(propertyName)) {
                    col.setColumnAnchor((HtmlData)this.generateInquiryUrl(Chart.class, element, "chartOfAccountsCode"));
                }
                if ("accountNumber".equals(propertyName)) {
                    col.setColumnAnchor((HtmlData)this.generateInquiryUrl(Account.class, element, "chartOfAccountsCode", "accountNumber"));
                }
                if (!col.getPropertyName().equals("documentNumber")) continue;
                String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                HashMap<String, String> fieldList = new HashMap<String, String>();
                fieldList.put("documentNumber", propValue);
                HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(ContractsGrantsMilestoneReport.class), (Class)this.getBusinessObjectClass(), fieldList));
                col.setColumnAnchor((HtmlData)a);
            }
            ResultRow row = new ResultRow(columns, "", "&nbsp;");
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean isRowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    protected HtmlData.AnchorHtmlData generateInquiryUrl(Class<?> businessObjectClass, BusinessObject businessObject, String ... propertyNames) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "start");
        parameters.put("mode", "standalone");
        parameters.put("businessObjectClassName", businessObjectClass.getName());
        for (String property : propertyNames) {
            parameters.put(property, ObjectUtils.getPropertyValue((Object)businessObject, (String)property).toString());
        }
        HtmlData.AnchorHtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "");
        inquiryHref.setHref(UrlFactory.parameterizeUrl((String)"inquiry.do", parameters));
        return inquiryHref;
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        String lowerBoundMilestoneExpectedCompletionDate = fieldValues.get("rangeLowerBoundKeyPrefix_milestoneExpectedCompletionDate");
        this.validateDateField(lowerBoundMilestoneExpectedCompletionDate, "rangeLowerBoundKeyPrefix_milestoneExpectedCompletionDate", this.getDateTimeService());
        String upperBoundMilestoneExpectedCompletionDate = fieldValues.get("milestoneExpectedCompletionDate");
        this.validateDateField(upperBoundMilestoneExpectedCompletionDate, "milestoneExpectedCompletionDate", this.getDateTimeService());
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

