/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsPredeterminedBillingReport;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsReportLookupableHelperServiceImplBase;

public class ContractsGrantsPredeterminedBillingReportLookupableHelperServiceImpl
extends ContractsGrantsReportLookupableHelperServiceImplBase {
    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        Collection bills = this.getLookupService().findCollectionBySearchHelper(Bill.class, lookupFormFields, true);
        List displayList = bills.stream().map(bill -> {
            ContractsGrantsPredeterminedBillingReport pdbr = new ContractsGrantsPredeterminedBillingReport();
            pdbr.setProposalNumber(bill.getProposalNumber());
            pdbr.setAccountNumber(bill.getAccountNumber());
            pdbr.setChartOfAccountsCode(bill.getChartOfAccountsCode());
            pdbr.setActive(bill.isActive());
            pdbr.setBillNumber(bill.getBillNumber());
            pdbr.setBillDescription(bill.getBillDescription());
            pdbr.setBillDate(bill.getBillDate());
            pdbr.setBilled(bill.isBilled());
            pdbr.setEstimatedAmount(bill.getEstimatedAmount());
            if (bill.isBilled()) {
                pdbr.setInvoiceDocumentNumber(bill.getMostRecentInvoiceDocumentNumber());
            }
            return pdbr;
        }).collect(Collectors.toList());
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    @Override
    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        for (Object entry : displayList) {
            BusinessObject element = (BusinessObject)entry;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                String propertyName = col.getPropertyName();
                if ("proposalNumber".equals(propertyName)) {
                    col.setColumnAnchor((HtmlData)this.generateInquiryUrl(ContractsAndGrantsBillingAward.class, element, "proposalNumber"));
                }
                if ("chartOfAccountsCode".equals(propertyName)) {
                    col.setColumnAnchor((HtmlData)this.generateInquiryUrl(Chart.class, element, "chartOfAccountsCode"));
                }
                if ("accountNumber".equals(propertyName)) {
                    col.setColumnAnchor((HtmlData)this.generateInquiryUrl(Account.class, element, "chartOfAccountsCode", "accountNumber"));
                }
                if (!col.getPropertyName().equals("invoiceDocumentNumber")) continue;
                String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                HashMap<String, String> fieldList = new HashMap<String, String>();
                fieldList.put("documentNumber", propValue);
                HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(ContractsGrantsPredeterminedBillingReport.class), ContractsGrantsPredeterminedBillingReport.class, fieldList));
                col.setColumnAnchor((HtmlData)a);
            }
            ResultRow row = new ResultRow(columns, "", "&nbsp;");
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean isRowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    protected HtmlData.AnchorHtmlData generateInquiryUrl(Class<?> boClass, BusinessObject bo, String ... propertyNames) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "start");
        parameters.put("businessObjectClassName", boClass.getName());
        for (String property : propertyNames) {
            parameters.put(property, ObjectUtils.getPropertyValue((Object)bo, (String)property).toString());
        }
        HtmlData.AnchorHtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "");
        inquiryHref.setHref(UrlFactory.parameterizeUrl((String)"inquiry.do", parameters));
        return inquiryHref;
    }
}

