/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectConsolidation;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;

public class CostCategoryMaintainableImpl
extends FinancialSystemMaintainable {
    public CostCategoryMaintainableImpl() {
        this.initiateInactiveRecordDisplay();
    }

    public CostCategoryMaintainableImpl(PersistableBusinessObject businessObject) {
        super(businessObject);
        this.initiateInactiveRecordDisplay();
    }

    protected void initiateInactiveRecordDisplay() {
        this.inactiveRecordDisplay.put("objectCodes", Boolean.FALSE);
        this.inactiveRecordDisplay.put("objectLevels", Boolean.FALSE);
        this.inactiveRecordDisplay.put("objectConsolidations", Boolean.FALSE);
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (StringUtils.equals((CharSequence)"multipleValues", (CharSequence)refreshCaller)) {
            String collectionName = (String)fieldValues.get("lookedUpCollectionName");
            CostCategory costCategory = (CostCategory)document.getNewMaintainableObject().getBusinessObject();
            if (StringUtils.equals((CharSequence)collectionName, (CharSequence)"objectCodes") && !CollectionUtils.isEmpty(costCategory.getObjectCodes())) {
                for (CostCategoryObjectCode objectCode : costCategory.getObjectCodes()) {
                    if (!StringUtils.isBlank((CharSequence)objectCode.getCategoryCode())) continue;
                    objectCode.setCategoryCode(costCategory.getCategoryCode());
                }
            }
            if (StringUtils.equals((CharSequence)collectionName, (CharSequence)"objectLevels") && !CollectionUtils.isEmpty(costCategory.getObjectLevels())) {
                for (CostCategoryObjectLevel objectLevel : costCategory.getObjectLevels()) {
                    if (!StringUtils.isBlank((CharSequence)objectLevel.getCategoryCode())) continue;
                    objectLevel.setCategoryCode(costCategory.getCategoryCode());
                }
            }
            if (StringUtils.equals((CharSequence)collectionName, (CharSequence)"objectConsolidations") && !CollectionUtils.isEmpty(costCategory.getObjectConsolidations())) {
                for (CostCategoryObjectConsolidation objectConsolidation : costCategory.getObjectConsolidations()) {
                    if (!StringUtils.isBlank((CharSequence)objectConsolidation.getCategoryCode())) continue;
                    objectConsolidation.setCategoryCode(costCategory.getCategoryCode());
                }
            }
            if (ObjectUtils.isNotNull((Object)document.getOldMaintainableObject()) && ObjectUtils.isNotNull((Object)document.getOldMaintainableObject().getBusinessObject())) {
                CostCategory oldCostCategory = (CostCategory)document.getOldMaintainableObject().getBusinessObject();
                if (!this.sameSize(oldCostCategory.getObjectCodes(), costCategory.getObjectCodes())) {
                    if (oldCostCategory.getObjectCodes() == null) {
                        oldCostCategory.setObjectCodes(new ArrayList<CostCategoryObjectCode>());
                    }
                    while (oldCostCategory.getObjectCodes().size() < costCategory.getObjectCodes().size()) {
                        CostCategoryObjectCode paddingObjectCode = new CostCategoryObjectCode();
                        paddingObjectCode.setCategoryCode(oldCostCategory.getCategoryCode());
                        oldCostCategory.getObjectCodes().add(paddingObjectCode);
                    }
                }
                if (!this.sameSize(oldCostCategory.getObjectLevels(), costCategory.getObjectLevels())) {
                    if (oldCostCategory.getObjectLevels() == null) {
                        oldCostCategory.setObjectLevels(new ArrayList<CostCategoryObjectLevel>());
                    }
                    while (oldCostCategory.getObjectLevels().size() < costCategory.getObjectLevels().size()) {
                        CostCategoryObjectLevel paddingObjectLevel = new CostCategoryObjectLevel();
                        paddingObjectLevel.setCategoryCode(oldCostCategory.getCategoryCode());
                        oldCostCategory.getObjectLevels().add(paddingObjectLevel);
                    }
                }
                if (!this.sameSize(oldCostCategory.getObjectConsolidations(), costCategory.getObjectConsolidations())) {
                    if (oldCostCategory.getObjectConsolidations() == null) {
                        oldCostCategory.setObjectConsolidations(new ArrayList<CostCategoryObjectConsolidation>());
                    }
                    while (oldCostCategory.getObjectConsolidations().size() < costCategory.getObjectConsolidations().size()) {
                        CostCategoryObjectConsolidation paddingConsolidation = new CostCategoryObjectConsolidation();
                        paddingConsolidation.setCategoryCode(oldCostCategory.getCategoryCode());
                        oldCostCategory.getObjectConsolidations().add(paddingConsolidation);
                    }
                }
            }
        }
    }

    protected boolean sameSize(Collection<?> a, Collection<?> b) {
        if (CollectionUtils.isEmpty(a)) {
            return CollectionUtils.isEmpty(b);
        }
        if (CollectionUtils.isEmpty(b)) {
            return false;
        }
        return a.size() == b.size();
    }

    public void processBeforeAddLine(String colName, Class colClass, BusinessObject bo) {
        super.processBeforeAddLine(colName, colClass, bo);
        if (bo instanceof CostCategoryObjectCode) {
            ((CostCategoryObjectCode)bo).setCategoryCode(((CostCategory)this.getBusinessObject()).getCategoryCode());
        } else if (bo instanceof CostCategoryObjectLevel) {
            ((CostCategoryObjectLevel)bo).setCategoryCode(((CostCategory)this.getBusinessObject()).getCategoryCode());
        } else if (bo instanceof CostCategoryObjectConsolidation) {
            ((CostCategoryObjectConsolidation)bo).setCategoryCode(((CostCategory)this.getBusinessObject()).getCategoryCode());
        }
    }
}

