/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;

public class CustomerInvoiceDocumentPresentationController
extends FinancialSystemTransactionalDocumentPresentationControllerBase {
    public Set<String> getDocumentActions(Document document) {
        Set documentActions = super.getDocumentActions(document);
        if (this.isDocErrorCorrectionMode((FinancialSystemTransactionalDocument)document)) {
            documentActions.remove("canEdit");
        }
        return documentActions;
    }

    public Set<String> getEditModes(Document document) {
        WorkflowDocument workflowDocument;
        Set editModes = super.getEditModes(document);
        if (!this.isDocErrorCorrectionMode((FinancialSystemTransactionalDocument)document)) {
            editModes.add("processingOrganizationMode");
        }
        if (ObjectUtils.isNotNull((Object)(workflowDocument = document.getDocumentHeader().getWorkflowDocument())) && (workflowDocument.isApproved() || workflowDocument.isProcessed() || workflowDocument.isFinal())) {
            editModes.add("displayPrintButton");
        } else {
            editModes.remove("displayPrintButton");
        }
        if (ObjectUtils.isNotNull((Object)workflowDocument) && workflowDocument.isEnroute()) {
            editModes.add("invoiceItemDescription");
        }
        return editModes;
    }

    public boolean canCopy(Document document) {
        CustomerInvoiceDocument ciDoc = (CustomerInvoiceDocument)document;
        boolean copyable = !ciDoc.getDocumentHeader().getWorkflowDocument().isInitiated();
        copyable &= !ciDoc.getDocumentHeader().getWorkflowDocument().isCanceled();
        return copyable &= !((CustomerInvoiceDocument)document).isInvoiceReversal();
    }

    public boolean canErrorCorrect(FinancialSystemTransactionalDocument document) {
        if (StringUtils.isNotBlank((CharSequence)document.getDocumentHeader().getCorrectedByDocumentId())) {
            return false;
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!this.isApprovalDateWithinFiscalYear(workflowDocument)) {
            return false;
        }
        if (((CustomerInvoiceDocument)document).isInvoiceReversal()) {
            return false;
        }
        return this.isDocFinalWithNoAppliedAmountsExceptDiscounts((CustomerInvoiceDocument)document);
    }

    protected boolean isDocFinalWithNoAppliedAmountsExceptDiscounts(CustomerInvoiceDocument document) {
        boolean isFinal = document.getDocumentHeader().getWorkflowDocument().isFinal() || document.getDocumentHeader().getWorkflowDocument().isProcessed();
        InvoicePaidAppliedService paidAppliedService = (InvoicePaidAppliedService)SpringContext.getBean(InvoicePaidAppliedService.class);
        boolean hasAppliedAmountsExcludingDiscounts = paidAppliedService.doesInvoiceHaveAppliedAmounts(document);
        return isFinal && !hasAppliedAmountsExcludingDiscounts;
    }

    protected boolean isDocErrorCorrectionMode(FinancialSystemTransactionalDocument document) {
        if (StringUtils.isNotBlank((CharSequence)document.getDocumentHeader().getCorrectedByDocumentId())) {
            return true;
        }
        if (((CustomerInvoiceDocument)document).isInvoiceReversal()) {
            return true;
        }
        return this.isDocFinalWithNoAppliedAmountsExceptDiscounts((CustomerInvoiceDocument)document);
    }
}

