/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.ArrayList;
import java.util.Set;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kim.api.role.RoleService;
import org.kuali.kfs.kim.api.services.KimApiServiceLocator;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.FinancialSystemMaintenanceDocumentPresentationControllerBase;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class OrganizationOptionsPresentationController
extends FinancialSystemMaintenanceDocumentPresentationControllerBase {
    protected static final String ACCOUNTS_RECEIVABLE_MANAGER_ROLE_NAME = "Accounts Receivable Manager";

    public Set<String> getConditionallyReadOnlySectionIds(MaintenanceDocument document) {
        Set readOnlySectionIds = super.getConditionallyReadOnlySectionIds(document);
        this.setRemitToAddressSectionEditable(readOnlySectionIds);
        return readOnlySectionIds;
    }

    public Set<String> getConditionallyReadOnlyPropertyNames(MaintenanceDocument document) {
        Set readOnlyPropertyNames = super.getConditionallyReadOnlyPropertyNames(document);
        this.setRemitToNameEditable(readOnlyPropertyNames);
        this.setOrgPostalZipCodeEditable(readOnlyPropertyNames);
        this.setBillingOrgFieldsEditable(readOnlyPropertyNames, document);
        this.setProcessingOrgFieldsEditable(readOnlyPropertyNames, document);
        return readOnlyPropertyNames;
    }

    protected void setBillingOrgFieldsEditable(Set<String> readOnlyPropertyNames, MaintenanceDocument document) {
        if (document.isEdit()) {
            readOnlyPropertyNames.add("chartOfAccountsCode");
            readOnlyPropertyNames.add("organizationCode");
        }
    }

    protected void setProcessingOrgFieldsEditable(Set<String> readOnlyPropertyNames, MaintenanceDocument document) {
        if (document.isEdit()) {
            RoleService rms = KimApiServiceLocator.getRoleService();
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            ArrayList<String> roleIds = new ArrayList<String>();
            roleIds.add(rms.getRoleIdByNamespaceCodeAndName("KFS-SYS", ACCOUNTS_RECEIVABLE_MANAGER_ROLE_NAME));
            if (!rms.principalHasRole(principalId, roleIds, null)) {
                readOnlyPropertyNames.add("processingChartOfAccountCode");
                readOnlyPropertyNames.add("processingOrganizationCode");
            }
        }
    }

    protected void setRemitToNameEditable(Set<String> readOnlyPropertyNames) {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        if (parameterService.getParameterValueAsBoolean(OrganizationOptions.class, "REMIT_TO_IND", Boolean.TRUE).booleanValue()) {
            readOnlyPropertyNames.add("organizationCheckPayableToName");
        }
    }

    protected void setOrgPostalZipCodeEditable(Set<String> readOnlyPropertyNames) {
        ParameterService service = (ParameterService)SpringContext.getBean(ParameterService.class);
        if (!service.getParameterValueAsBoolean(KfsParameterConstants.ACCOUNTS_RECEIVABLE_DOCUMENT.class, "SALES_TAX_IND", Boolean.FALSE).booleanValue()) {
            readOnlyPropertyNames.add("organizationPostalZipCode");
        }
    }

    protected void setRemitToAddressSectionEditable(Set<String> readOnlySectionIds) {
        ParameterService service = (ParameterService)SpringContext.getBean(ParameterService.class);
        String addressEditable = service.getParameterValueAsString(OrganizationOptions.class, "REMIT_TO_ADDRESS_IND");
        if ("N".equalsIgnoreCase(addressEditable)) {
            readOnlySectionIds.add("Edit Organization Remit To Address");
        }
    }
}

