/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.dataaccess.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kew.api.document.DocumentStatusCategory;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;

public class ContractsGrantsInvoiceDocumentDaoOjb
extends PlatformAwareDaoBaseOjb
implements ContractsGrantsInvoiceDocumentDao {
    @Override
    public Collection<ContractsGrantsInvoiceDocument> getMatchingInvoicesByCollection(Map fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)new ContractsGrantsInvoiceDocument());
        criteria.addNotEqualTo((Object)"documentHeader.financialDocumentStatusCode", (Object)"X");
        criteria.addNotEqualTo((Object)"documentHeader.financialDocumentStatusCode", (Object)"D");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(ContractsGrantsInvoiceDocument.class, (Criteria)criteria, (boolean)true));
    }

    @Override
    public Collection<ContractsGrantsInvoiceDocument> getCollectionEligibleContractsGrantsInvoicesByProposalNumber(String proposalNumber) {
        if (proposalNumber == null) {
            throw new IllegalArgumentException("Cannot find Contracts & Grants Invoices for blank proposal number");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("invoiceGeneralDetail.proposalNumber", (Object)proposalNumber);
        HashSet<String> successfulDocumentStatuses = new HashSet<String>();
        for (Object docStatus : DocumentStatus.getStatusesForCategory((DocumentStatusCategory)DocumentStatusCategory.SUCCESSFUL)) {
            successfulDocumentStatuses.add(docStatus.getCode());
        }
        HashSet<String> unsuccessfulDocumentStatuses = new HashSet<String>();
        for (DocumentStatus docStatus : DocumentStatus.getStatusesForCategory((DocumentStatusCategory)DocumentStatusCategory.UNSUCCESSFUL)) {
            unsuccessfulDocumentStatuses.add(docStatus.getCode());
        }
        criteria.addIn("documentHeader.workflowDocumentStatusCode", successfulDocumentStatuses);
        criteria.addIsNull("documentHeader.financialDocumentInErrorNumber");
        Criteria subCri = new Criteria();
        subCri.addNotIn("documentHeader.workflowDocumentStatusCode", unsuccessfulDocumentStatuses);
        subCri.addNotNull("documentHeader.financialDocumentInErrorNumber");
        ReportQueryByCriteria errorCorrectedDocumentsQuery = new ReportQueryByCriteria(ContractsGrantsInvoiceDocument.class, new String[]{"documentHeader.financialDocumentInErrorNumber"}, subCri);
        criteria.addNotIn("documentNumber", (Query)errorCorrectedDocumentsQuery);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(ContractsGrantsInvoiceDocument.class, (Criteria)criteria));
    }

    @Override
    public Collection<ContractsGrantsInvoiceDocument> getOpenInvoicesByCustomerNumber(String customerNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("openInvoiceIndicator", (Object)Boolean.TRUE);
        criteria.addEqualTo("accountsReceivableDocumentHeader.customerNumber", (Object)customerNumber);
        criteria.addNotEqualTo((Object)"documentHeader.financialDocumentStatusCode", (Object)"X");
        criteria.addNotEqualTo((Object)"documentHeader.financialDocumentStatusCode", (Object)"D");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(ContractsGrantsInvoiceDocument.class, (Criteria)criteria));
    }
}

