/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;

public class AccountsReceivablePendingEntryServiceImpl
implements AccountsReceivablePendingEntryService {
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    protected ParameterService parameterService;

    @Override
    public void createAndAddGenericInvoiceRelatedGLPEs(GeneralLedgerPendingEntrySource glpeSource, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, boolean isDebit, boolean hasClaimOnCashOffset, KualiDecimal amount) {
        GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
        this.generalLedgerPendingEntryService.populateExplicitGeneralLedgerPendingEntry(glpeSource, glpeSourceDetail, sequenceHelper, explicitEntry);
        explicitEntry.setTransactionLedgerEntryAmount((KualiDecimal)amount.abs());
        explicitEntry.setTransactionDebitCreditCode(isDebit ? "D" : "C");
        glpeSource.addPendingEntry(explicitEntry);
        if (hasClaimOnCashOffset) {
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(explicitEntry);
            this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(glpeSource.getPostingYear(), explicitEntry, sequenceHelper, offsetEntry);
            glpeSource.addPendingEntry(offsetEntry);
        }
    }

    @Override
    public void createAndAddGenericInvoiceRelatedGLPEs(GeneralLedgerPendingEntrySource glpeSource, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, boolean isDebit, boolean hasReceivableClaimOnCashOffset, boolean writeoffTaxGenerationMethodDisallowFlag, KualiDecimal amount) {
        boolean overrideFinancialObjectCodeFlag;
        GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
        this.generalLedgerPendingEntryService.populateExplicitGeneralLedgerPendingEntry(glpeSource, glpeSourceDetail, sequenceHelper, explicitEntry);
        explicitEntry.setTransactionLedgerEntryAmount((KualiDecimal)amount.abs());
        explicitEntry.setTransactionDebitCreditCode(isDebit ? "D" : "C");
        boolean bl = overrideFinancialObjectCodeFlag = isDebit && writeoffTaxGenerationMethodDisallowFlag && !hasReceivableClaimOnCashOffset;
        if (!overrideFinancialObjectCodeFlag) {
            glpeSource.addPendingEntry(explicitEntry);
        }
        if (hasReceivableClaimOnCashOffset && writeoffTaxGenerationMethodDisallowFlag) {
            return;
        }
        if (hasReceivableClaimOnCashOffset || writeoffTaxGenerationMethodDisallowFlag) {
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(explicitEntry);
            this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(glpeSource.getPostingYear(), explicitEntry, sequenceHelper, offsetEntry);
            if (overrideFinancialObjectCodeFlag) {
                explicitEntry.setFinancialObjectCode(offsetEntry.getFinancialObjectCode());
                glpeSource.addPendingEntry(explicitEntry);
            }
            glpeSource.addPendingEntry(offsetEntry);
        }
    }

    @Override
    public ObjectCode getAccountsReceivableObjectCode(InvoicePaidApplied invoicePaidApplied) {
        invoicePaidApplied.getInvoiceDetail().refresh();
        invoicePaidApplied.getInvoiceDetail().refreshNonUpdateableReferences();
        invoicePaidApplied.getInvoiceDetail().refreshReferenceObject("objectCode");
        return invoicePaidApplied.getInvoiceDetail().getObjectCode();
    }

    @Override
    public String getAccountsReceivableObjectCode(CustomerInvoiceDetail customerInvoiceDetail) {
        if (StringUtils.isNotEmpty((CharSequence)customerInvoiceDetail.getChartOfAccountsCode())) {
            customerInvoiceDetail.refreshReferenceObject("chart");
            return customerInvoiceDetail.getChart().getFinAccountsReceivableObj().getFinancialObjectCode();
        }
        return null;
    }

    public GeneralLedgerPendingEntryService getGeneralLedgerPendingEntryService() {
        return this.generalLedgerPendingEntryService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

