/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kew.doctype.service.DocumentTypeService;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsCollectionActivityInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.ContractsGrantsCollectionActivityDocument;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class ContractsGrantsCollectionActivityDocumentServiceImpl
implements ContractsGrantsCollectionActivityDocumentService {
    protected ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao;
    protected DocumentService documentService;
    protected DateTimeService dateTimeService;
    protected BusinessObjectService businessObjectService;
    protected DocumentTypeService documentTypeService;
    protected InvoicePaidAppliedService invoicePaidAppliedService;
    protected KualiModuleService kualiModuleService;
    private PersonService personService;

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    @Override
    @Transactional
    public void createAndSaveCollectionEvents(ContractsGrantsCollectionActivityDocument colActDoc) {
        for (ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail : colActDoc.getInvoiceDetails()) {
            CollectionEvent newCollectionEvent = new CollectionEvent();
            Timestamp now = this.dateTimeService.getCurrentTimestamp();
            newCollectionEvent.setPostedDate(now);
            newCollectionEvent.setActivityCode(colActDoc.getActivityCode());
            newCollectionEvent.setActivityDate(colActDoc.getActivityDate());
            newCollectionEvent.setActivityText(colActDoc.getActivityText());
            newCollectionEvent.setFollowupDate(colActDoc.getFollowupDate());
            newCollectionEvent.setCompletedDate(colActDoc.getCompletedDate());
            String initiatorPrincipalId = colActDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
            Person initiator = this.personService.getPerson(initiatorPrincipalId);
            newCollectionEvent.setUserPrincipalId(initiatorPrincipalId);
            newCollectionEvent.setUser(initiator);
            ContractsGrantsInvoiceDocument invoice = invoiceDetail.getInvoiceDocument();
            newCollectionEvent.setCollectionEventCode(invoice.getNextCollectionEventCode());
            newCollectionEvent.setInvoiceNumber(invoice.getDocumentNumber());
            newCollectionEvent.setProposalNumber(colActDoc.getProposalNumber());
            this.businessObjectService.save((PersistableBusinessObject)newCollectionEvent);
        }
    }

    @Override
    @Transactional
    public ContractsAndGrantsBillingAward retrieveAwardByProposalNumber(String proposalNumber) {
        ContractsAndGrantsBillingAward award = null;
        if (ObjectUtils.isNotNull((Object)proposalNumber)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("proposalNumber", proposalNumber);
            award = (ContractsAndGrantsBillingAward)this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
        }
        return award;
    }

    @Override
    @Transactional
    public KualiDecimal retrievePaymentAmountByDocumentNumber(String documentNumber) {
        KualiDecimal paymentAmount = KualiDecimal.ZERO;
        Collection<InvoicePaidApplied> invoicePaidApplieds = this.invoicePaidAppliedService.getInvoicePaidAppliedsForInvoice(documentNumber);
        if (invoicePaidApplieds != null && !invoicePaidApplieds.isEmpty()) {
            for (InvoicePaidApplied invPaidApp : invoicePaidApplieds) {
                paymentAmount = (KualiDecimal)paymentAmount.add((AbstractKualiDecimal)invPaidApp.getInvoiceItemAppliedAmount());
            }
        }
        return paymentAmount;
    }

    @Override
    @Transactional
    public Collection<ContractsGrantsInvoiceDocument> retrieveCollectionActivityEligibleContractsGrantsInvoicesByProposalNumber(String proposalNumber) {
        Collection<ContractsGrantsInvoiceDocument> cgInvoices = this.contractsGrantsInvoiceDocumentDao.getCollectionEligibleContractsGrantsInvoicesByProposalNumber(proposalNumber);
        if (CollectionUtils.isEmpty(cgInvoices)) {
            return cgInvoices;
        }
        ArrayList<ContractsGrantsInvoiceDocument> filteredInvoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        for (ContractsGrantsInvoiceDocument invoice : cgInvoices) {
            if (this.isFullyPaid(invoice)) continue;
            filteredInvoices.add(invoice);
        }
        return filteredInvoices;
    }

    protected boolean isFullyPaid(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal openAmount = contractsGrantsInvoiceDocument.getOpenAmount();
        return ObjectUtils.isNotNull((Object)openAmount) && openAmount.equals((Object)KualiDecimal.ZERO);
    }

    public InvoicePaidAppliedService getInvoicePaidAppliedService() {
        return this.invoicePaidAppliedService;
    }

    public void setInvoicePaidAppliedService(InvoicePaidAppliedService invoicePaidAppliedService) {
        this.invoicePaidAppliedService = invoicePaidAppliedService;
    }

    public ContractsGrantsInvoiceDocumentDao getContractsGrantsInvoiceDocumentDao() {
        return this.contractsGrantsInvoiceDocumentDao;
    }

    public void setContractsGrantsInvoiceDocumentDao(ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao) {
        this.contractsGrantsInvoiceDocumentDao = contractsGrantsInvoiceDocumentDao;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

