/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import com.lowagie.text.DocumentException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.mo.common.GloballyUnique;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.cg.ContractAndGrantsProposal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.ContractsGrantsInvoiceDocumentBatchStep;
import org.kuali.kfs.module.ar.businessobject.AwardAccountObjectCodeTotalBilled;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectConsolidation;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.InvoiceSuspensionCategory;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.businessobject.TransmissionDetailStatus;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.SuspensionCategory;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.PdfFormFillerUtil;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ContractsGrantsInvoiceDocumentServiceImpl
implements ContractsGrantsInvoiceDocumentService {
    private static final Logger LOG = LogManager.getLogger();
    protected AccountsReceivablePendingEntryService accountsReceivablePendingEntryService;
    protected AttachmentService attachmentService;
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;
    protected ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected CostCategoryService costCategoryService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected KualiModuleService kualiModuleService;
    protected KualiRuleService kualiRuleService;
    protected NoteService noteService;
    protected ObjectCodeService objectCodeService;
    protected ParameterService parameterService;
    protected PermissionService permissionService;
    protected PersonService personService;
    protected UniversityDateService universityDateService;
    private AccountingPeriodService accountingPeriodService;
    private ObjectTypeService objectTypeService;
    private List<SuspensionCategory> suspensionCategories;

    @Override
    public void createSourceAccountingLines(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, List<ContractsAndGrantsBillingAwardAccount> awardAccounts) {
        ContractsAndGrantsBillingAward award;
        if (CollectionUtils.isEmpty((Collection)contractsGrantsInvoiceDocument.getSourceAccountingLines()) && ObjectUtils.isNotNull((Object)(award = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward()))) {
            if (StringUtils.equalsIgnoreCase((CharSequence)award.getInvoicingOptionCode(), (CharSequence)"2") || StringUtils.equalsIgnoreCase((CharSequence)award.getInvoicingOptionCode(), (CharSequence)"4")) {
                CustomerInvoiceDetail cide = this.createSourceAccountingLine(contractsGrantsInvoiceDocument.getDocumentNumber(), awardAccounts.get(0).getChartOfAccountsCode(), awardAccounts.get(0).getAccountNumber(), awardAccounts.get(0).getAccount().getSubFundGroup(), this.getTotalAmountForInvoice(contractsGrantsInvoiceDocument), 1);
                contractsGrantsInvoiceDocument.getSourceAccountingLines().add(cide);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)award.getInvoicingOptionCode(), (CharSequence)"3")) {
                List<InvoiceAccountDetail> accountDetails = contractsGrantsInvoiceDocument.getAccountDetails();
                if (CollectionUtils.isNotEmpty(accountDetails)) {
                    CustomerInvoiceDetail cide = this.createSourceAccountingLinesByContractControlAccount(contractsGrantsInvoiceDocument);
                    contractsGrantsInvoiceDocument.getSourceAccountingLines().add(cide);
                }
            } else {
                List<CustomerInvoiceDetail> awardAccountingLines = this.createSourceAccountingLinesByAward(contractsGrantsInvoiceDocument);
                contractsGrantsInvoiceDocument.getSourceAccountingLines().addAll(awardAccountingLines);
            }
        }
    }

    @Override
    public ContractsGrantsInvoiceObjectCode contractGrantsInvoiceObjectCodeForSubFundGroup(SubFundGroup subFundGroup, String chartOfAccountsCode) {
        ContractsGrantsInvoiceObjectCode contractsGrantsInvoiceObjectCode = this.findContractGrantsInvoiceObjectCode("subFundGroupCode", subFundGroup.getSubFundGroupCode(), chartOfAccountsCode);
        if (contractsGrantsInvoiceObjectCode == null) {
            contractsGrantsInvoiceObjectCode = this.findContractGrantsInvoiceObjectCode("subFundGroupTypeCode", subFundGroup.getSubFundGroupTypeCode(), chartOfAccountsCode);
        }
        if (contractsGrantsInvoiceObjectCode == null) {
            contractsGrantsInvoiceObjectCode = this.findContractGrantsInvoiceObjectCode("fundGroupCode", subFundGroup.getFundGroupCode(), chartOfAccountsCode);
        }
        return contractsGrantsInvoiceObjectCode;
    }

    private ContractsGrantsInvoiceObjectCode findContractGrantsInvoiceObjectCode(String fieldName, String fieldValue, Object chartOfAccountsCode) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(fieldName, fieldValue);
        fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
        fieldValues.put("active", true);
        List contractsGrantsInvoiceObjectCodes = (List)this.getBusinessObjectService().findMatching(ContractsGrantsInvoiceObjectCode.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)contractsGrantsInvoiceObjectCodes)) {
            return (ContractsGrantsInvoiceObjectCode)((Object)contractsGrantsInvoiceObjectCodes.get(0));
        }
        return null;
    }

    @Override
    public KualiDecimal getTotalAmountForInvoice(ContractsGrantsInvoiceDocument invoice) {
        if (ArConstants.BillingFrequencyValues.isPredeterminedBilling(invoice.getInvoiceGeneralDetail())) {
            return this.getBillAmountTotal(invoice);
        }
        if (ArConstants.BillingFrequencyValues.isMilestone(invoice.getInvoiceGeneralDetail())) {
            return this.getInvoiceMilestoneTotal(invoice);
        }
        this.calculatePreviouslyBilledAmounts(invoice);
        return invoice.getTotalInvoiceInvoiceAmount();
    }

    protected List<CustomerInvoiceDetail> createSourceAccountingLinesByAward(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        ArrayList<CustomerInvoiceDetail> awardAccountingLines = new ArrayList<CustomerInvoiceDetail>();
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocument.getAccountDetails())) {
            Map<String, KualiDecimal> accountExpenditureAmounts = this.getCategoryExpenditureAmountsForInvoiceAccountDetail(contractsGrantsInvoiceDocument);
            Map<String, KualiDecimal> accountTotalBilledAmounts = this.getCategoryTotalBilledAmountsForInvoiceAccountDetail(contractsGrantsInvoiceDocument);
            for (InvoiceAccountDetail invAcctD : contractsGrantsInvoiceDocument.getAccountDetails()) {
                String proposalNumber = invAcctD.getProposalNumber();
                String chartOfAccountsCode = invAcctD.getChartOfAccountsCode();
                String accountNumber = invAcctD.getAccountNumber();
                if (invAcctD.getAccount() == null) {
                    invAcctD.refreshReferenceObject("account");
                }
                SubFundGroup subFundGroup = invAcctD.getAccount().getSubFundGroup();
                Integer sequenceNumber = contractsGrantsInvoiceDocument.getAccountDetails().indexOf((Object)invAcctD) + 1;
                String accountKey = StringUtils.join((Object[])new String[]{chartOfAccountsCode, accountNumber}, (String)"-");
                KualiDecimal totalAmount = accountExpenditureAmounts.getOrDefault(accountKey, KualiDecimal.ZERO);
                if (invAcctD.getTotalPreviouslyBilled().isZero()) {
                    KualiDecimal previouslyBilledAmount = this.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber);
                    previouslyBilledAmount = (KualiDecimal)previouslyBilledAmount.add((AbstractKualiDecimal)this.getMilestonesBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber));
                    KualiDecimal totalBilledAmount = accountTotalBilledAmounts.getOrDefault(accountKey, KualiDecimal.ZERO);
                    if ((previouslyBilledAmount = (KualiDecimal)previouslyBilledAmount.subtract((AbstractKualiDecimal)totalBilledAmount)).isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                        totalAmount = (KualiDecimal)totalAmount.subtract((AbstractKualiDecimal)previouslyBilledAmount);
                    }
                }
                CustomerInvoiceDetail cide = this.createSourceAccountingLine(contractsGrantsInvoiceDocument.getDocumentNumber(), chartOfAccountsCode, accountNumber, subFundGroup, totalAmount, sequenceNumber);
                awardAccountingLines.add(cide);
            }
        }
        return awardAccountingLines;
    }

    protected Map<String, KualiDecimal> getCategoryExpenditureAmountsForInvoiceAccountDetail(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        HashMap<String, KualiDecimal> expenditureAmounts = new HashMap<String, KualiDecimal>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes()) {
            String accountKey = StringUtils.join((Object[])new String[]{invoiceDetailAccountObjectCode.getChartOfAccountsCode(), invoiceDetailAccountObjectCode.getAccountNumber()}, (String)"-");
            if (!StringUtils.isNotBlank((CharSequence)invoiceDetailAccountObjectCode.getCategoryCode())) continue;
            KualiDecimal total = (KualiDecimal)expenditureAmounts.get(accountKey);
            if (ObjectUtils.isNull((Object)total)) {
                total = KualiDecimal.ZERO;
            }
            expenditureAmounts.put(accountKey, (KualiDecimal)total.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures()));
        }
        return expenditureAmounts;
    }

    protected Map<String, KualiDecimal> getCategoryTotalBilledAmountsForInvoiceAccountDetail(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        HashMap<String, KualiDecimal> totalBilledAmounts = new HashMap<String, KualiDecimal>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes()) {
            String accountKey = StringUtils.join((Object[])new String[]{invoiceDetailAccountObjectCode.getChartOfAccountsCode(), invoiceDetailAccountObjectCode.getAccountNumber()}, (String)"-");
            if (!StringUtils.isNotBlank((CharSequence)invoiceDetailAccountObjectCode.getCategoryCode())) continue;
            KualiDecimal total = (KualiDecimal)totalBilledAmounts.get(accountKey);
            if (ObjectUtils.isNull((Object)total)) {
                total = KualiDecimal.ZERO;
            }
            totalBilledAmounts.put(accountKey, (KualiDecimal)total.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getTotalBilled()));
        }
        return totalBilledAmounts;
    }

    protected CustomerInvoiceDetail createSourceAccountingLinesByContractControlAccount(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        String coaCode = null;
        String accountNumber = null;
        SubFundGroup subFundGroup = null;
        List<InvoiceAccountDetail> accountDetails = contractsGrantsInvoiceDocument.getAccountDetails();
        if (CollectionUtils.isNotEmpty(accountDetails)) {
            Account contractControlAccount;
            InvoiceAccountDetail invoiceAccountDetail = accountDetails.get(0);
            Account account = invoiceAccountDetail.getAccount();
            if (ObjectUtils.isNull((Object)account)) {
                invoiceAccountDetail.refreshReferenceObject("account");
                account = invoiceAccountDetail.getAccount();
            }
            if (ObjectUtils.isNotNull((Object)account) && ObjectUtils.isNotNull((Object)(contractControlAccount = account.getContractControlAccount()))) {
                coaCode = contractControlAccount.getChartOfAccountsCode();
                accountNumber = contractControlAccount.getAccountNumber();
                subFundGroup = contractControlAccount.getSubFundGroup();
            }
        }
        return this.createSourceAccountingLine(contractsGrantsInvoiceDocument.getDocumentNumber(), coaCode, accountNumber, subFundGroup, this.getTotalAmountForInvoice(contractsGrantsInvoiceDocument), 1);
    }

    @Override
    public KualiDecimal getBillAmountTotal(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal totalBillAmount = KualiDecimal.ZERO;
        if (ArConstants.BillingFrequencyValues.isPredeterminedBilling(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail()) && !CollectionUtils.isEmpty(contractsGrantsInvoiceDocument.getInvoiceBills())) {
            for (InvoiceBill bill : contractsGrantsInvoiceDocument.getInvoiceBills()) {
                if (bill.getEstimatedAmount() == null) continue;
                totalBillAmount = (KualiDecimal)totalBillAmount.add((AbstractKualiDecimal)bill.getEstimatedAmount());
            }
        }
        return totalBillAmount;
    }

    @Override
    public KualiDecimal getInvoiceMilestoneTotal(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal totalMilestoneAmount = KualiDecimal.ZERO;
        if (ArConstants.BillingFrequencyValues.isMilestone(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail()) && !CollectionUtils.isEmpty(contractsGrantsInvoiceDocument.getInvoiceMilestones())) {
            for (InvoiceMilestone milestone : contractsGrantsInvoiceDocument.getInvoiceMilestones()) {
                if (milestone.getMilestoneAmount() == null) continue;
                totalMilestoneAmount = (KualiDecimal)totalMilestoneAmount.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
            }
        }
        return totalMilestoneAmount;
    }

    protected OrganizationAccountingDefault retrieveBillingOrganizationAccountingDefault(String billByChartOfAccountsCode, String billByOrganizationCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        Integer currentYear = this.universityDateService.getCurrentFiscalYear();
        criteria.put("universityFiscalYear", currentYear);
        criteria.put("chartOfAccountsCode", billByChartOfAccountsCode);
        criteria.put("organizationCode", billByOrganizationCode);
        return (OrganizationAccountingDefault)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
    }

    protected CustomerInvoiceDetail createSourceAccountingLine(String docNum, String coaCode, String acctNum, SubFundGroup subFundGroup, KualiDecimal totalAmount, Integer seqNum) {
        CustomerInvoiceDetail cid = new CustomerInvoiceDetail();
        cid.setDocumentNumber(docNum);
        cid.setAccountNumber(acctNum);
        cid.setChartOfAccountsCode(coaCode);
        ContractsGrantsInvoiceObjectCode cgbiObjectCode = this.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, coaCode);
        if (cgbiObjectCode != null) {
            cid.setFinancialObjectCode(cgbiObjectCode.getIncomeFinancialObjectCode());
            cid.setAccountsReceivableObjectCode(cgbiObjectCode.getReceivableFinancialObjectCode());
        }
        cid.setSequenceNumber(seqNum);
        cid.setInvoiceItemQuantity(BigDecimal.ONE);
        cid.setInvoiceItemUnitOfMeasureCode("EA");
        cid.setInvoiceItemUnitPrice(totalAmount);
        cid.setAmount(totalAmount);
        if (totalAmount.isNegative()) {
            cid.setInvoiceItemDiscountLineNumber(seqNum);
        }
        return cid;
    }

    @Override
    public void recalculateTotalAmountBilledToDate(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = contractsGrantsInvoiceDocument.getTotalCostInvoiceDetail();
        boolean expenditureValueChanged = this.adjustObjectCodeAmountsIfChanged(contractsGrantsInvoiceDocument);
        if (expenditureValueChanged) {
            KualiDecimal totalDirectCostExpenditures = this.getInvoiceDetailExpenditureSum(contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails());
            ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail = contractsGrantsInvoiceDocument.getTotalDirectCostInvoiceDetail();
            if (ObjectUtils.isNotNull((Object)((Object)totalDirectCostInvoiceDetail))) {
                totalDirectCostInvoiceDetail.setInvoiceAmount(totalDirectCostExpenditures);
            }
            KualiDecimal totalInDirectCostExpenditures = this.getInvoiceDetailExpenditureSum(contractsGrantsInvoiceDocument.getIndirectCostInvoiceDetails());
            ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail = contractsGrantsInvoiceDocument.getTotalIndirectCostInvoiceDetail();
            if (ObjectUtils.isNotNull((Object)((Object)totalInDirectCostInvoiceDetail))) {
                totalInDirectCostInvoiceDetail.setInvoiceAmount(totalInDirectCostExpenditures);
            }
            if (ObjectUtils.isNotNull((Object)((Object)totalCostInvoiceDetail))) {
                totalCostInvoiceDetail.setInvoiceAmount((KualiDecimal)totalDirectCostInvoiceDetail.getInvoiceAmount().add((AbstractKualiDecimal)totalInDirectCostExpenditures));
            }
            this.recalculateAccountDetails(contractsGrantsInvoiceDocument.getAccountDetails(), contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes());
            this.updateInvoiceSourceAccountingLines(contractsGrantsInvoiceDocument.getAccountDetails(), contractsGrantsInvoiceDocument.getSourceAccountingLines());
        }
        contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().setTotalPreviouslyBilled(this.getAwardBilledToDateAmount(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber()));
        KualiDecimal newTotalBilled = (KualiDecimal)contractsGrantsInvoiceDocument.getTotalInvoiceAmount().add((AbstractKualiDecimal)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
        newTotalBilled = (KualiDecimal)newTotalBilled.add((AbstractKualiDecimal)this.getOtherTotalBilledForAwardPeriod(contractsGrantsInvoiceDocument));
        contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().setTotalAmountBilledToDate(newTotalBilled);
        this.calculatePreviouslyBilledAmounts(contractsGrantsInvoiceDocument);
    }

    @Override
    public void calculatePreviouslyBilledAmounts(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal previouslyBilledInvoiceAmount;
        KualiDecimal previouslyBilledAmount = KualiDecimal.ZERO;
        String proposalNumber = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber();
        for (InvoiceAccountDetail invoiceAccountDetail : contractsGrantsInvoiceDocument.getAccountDetails()) {
            String chartOfAccountsCode = invoiceAccountDetail.getChartOfAccountsCode();
            String accountNumber = invoiceAccountDetail.getAccountNumber();
            previouslyBilledAmount = (KualiDecimal)previouslyBilledAmount.add((AbstractKualiDecimal)this.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber));
            previouslyBilledAmount = (KualiDecimal)previouslyBilledAmount.add((AbstractKualiDecimal)this.getMilestonesBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber));
        }
        contractsGrantsInvoiceDocument.setPreviouslyBilledTotal(previouslyBilledAmount);
        if (contractsGrantsInvoiceDocument.isCorrectionDocument()) {
            previouslyBilledInvoiceAmount = (KualiDecimal)previouslyBilledAmount.negated();
        } else {
            KualiDecimal totalPreviouslyBilled = contractsGrantsInvoiceDocument.getTotalCostInvoiceDetail().getTotalPreviouslyBilled();
            previouslyBilledInvoiceAmount = (KualiDecimal)previouslyBilledAmount.subtract((AbstractKualiDecimal)totalPreviouslyBilled);
            if (previouslyBilledInvoiceAmount.isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                previouslyBilledInvoiceAmount = KualiDecimal.ZERO;
            }
        }
        KualiDecimal invoiceAmount = contractsGrantsInvoiceDocument.getTotalCostInvoiceDetail().getInvoiceAmount();
        contractsGrantsInvoiceDocument.setPreviouslyBilledInvoiceAmount(previouslyBilledInvoiceAmount);
        contractsGrantsInvoiceDocument.setTotalInvoiceInvoiceAmount((KualiDecimal)invoiceAmount.subtract((AbstractKualiDecimal)previouslyBilledInvoiceAmount));
    }

    @Override
    public KualiDecimal getOtherTotalBilledForAwardPeriod(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal newTotalBilled = KualiDecimal.ZERO;
        HashMap<String, Object> fieldValuesForInvoice = new HashMap<String, Object>();
        fieldValuesForInvoice.put("invoiceGeneralDetail.proposalNumber", contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
        fieldValuesForInvoice.put("invoiceGeneralDetail.billingPeriod", contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingPeriod());
        String docNumberCriteriaString = SearchOperator.NOT + contractsGrantsInvoiceDocument.getDocumentNumber();
        if (ObjectUtils.isNotNull((Object)contractsGrantsInvoiceDocument.getDocumentHeader()) && StringUtils.isNotBlank((CharSequence)contractsGrantsInvoiceDocument.getDocumentHeader().getFinancialDocumentInErrorNumber())) {
            docNumberCriteriaString = docNumberCriteriaString + SearchOperator.NOT + contractsGrantsInvoiceDocument.getDocumentHeader().getFinancialDocumentInErrorNumber();
        }
        fieldValuesForInvoice.put("documentNumber", docNumberCriteriaString);
        fieldValuesForInvoice.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Collection<ContractsGrantsInvoiceDocument> cgInvoiceDocuments = this.retrieveAllCGInvoicesByCriteria(fieldValuesForInvoice);
        for (ContractsGrantsInvoiceDocument cgInvoiceDocument : cgInvoiceDocuments) {
            for (InvoiceAccountDetail invAcctD : cgInvoiceDocument.getAccountDetails()) {
                newTotalBilled = (KualiDecimal)newTotalBilled.add((AbstractKualiDecimal)invAcctD.getInvoiceAmount());
            }
        }
        return newTotalBilled;
    }

    public KualiDecimal getInvoiceDetailExpenditureSum(List<ContractsGrantsInvoiceDetail> invoiceDetails) {
        KualiDecimal totalExpenditures = KualiDecimal.ZERO;
        for (ContractsGrantsInvoiceDetail invoiceDetail : invoiceDetails) {
            totalExpenditures = (KualiDecimal)totalExpenditures.add((AbstractKualiDecimal)invoiceDetail.getInvoiceAmount());
        }
        return totalExpenditures;
    }

    protected void updateInvoiceSourceAccountingLines(List<InvoiceAccountDetail> invoiceAccountDetails, List sourceAccountingLines) {
        if (sourceAccountingLines.size() > 1) {
            for (CustomerInvoiceDetail cide : sourceAccountingLines) {
                for (InvoiceAccountDetail invoiceAccountDetail : invoiceAccountDetails) {
                    if (!cide.getAccountNumber().equals(invoiceAccountDetail.getAccountNumber())) continue;
                    cide.setInvoiceItemUnitPrice(invoiceAccountDetail.getInvoiceAmount());
                    cide.setAmount(invoiceAccountDetail.getInvoiceAmount());
                }
            }
        } else if (sourceAccountingLines.size() == 1) {
            KualiDecimal totalExpenditureAmount = KualiDecimal.ZERO;
            if (invoiceAccountDetails.size() == 1) {
                CustomerInvoiceDetail cide = (CustomerInvoiceDetail)sourceAccountingLines.get(0);
                cide.setInvoiceItemUnitPrice(invoiceAccountDetails.get(0).getInvoiceAmount());
                cide.setAmount(invoiceAccountDetails.get(0).getInvoiceAmount());
            } else {
                for (InvoiceAccountDetail invoiceAccountDetail : invoiceAccountDetails) {
                    totalExpenditureAmount = (KualiDecimal)totalExpenditureAmount.add((AbstractKualiDecimal)invoiceAccountDetail.getInvoiceAmount());
                }
                CustomerInvoiceDetail cide = (CustomerInvoiceDetail)sourceAccountingLines.get(0);
                cide.setInvoiceItemUnitPrice(totalExpenditureAmount);
                cide.setAmount(totalExpenditureAmount);
            }
        }
    }

    @Override
    public void prorateBill(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal amountEligibleForBilling;
        KualiDecimal totalCost = new KualiDecimal(0);
        for (ContractsGrantsInvoiceDetail invD : contractsGrantsInvoiceDocument.getInvoiceDetails()) {
            totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)invD.getInvoiceAmount());
        }
        KualiDecimal billedTotalCost = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getTotalPreviouslyBilled();
        KualiDecimal accountAwardTotal = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAwardTotal();
        if (((KualiDecimal)accountAwardTotal.subtract((AbstractKualiDecimal)billedTotalCost)).isGreaterEqual((AbstractKualiDecimal)new KualiDecimal(0)) && totalCost.isGreaterThan((AbstractKualiDecimal)(amountEligibleForBilling = (KualiDecimal)accountAwardTotal.subtract((AbstractKualiDecimal)billedTotalCost)))) {
            BigDecimal percentage = amountEligibleForBilling.bigDecimalValue().divide(totalCost.bigDecimalValue(), 10, RoundingMode.HALF_DOWN);
            KualiDecimal amountToBill = new KualiDecimal(0);
            ContractsGrantsInvoiceDetail largestCostCategory = null;
            BigDecimal largestAmount = BigDecimal.ZERO;
            for (ContractsGrantsInvoiceDetail invD : contractsGrantsInvoiceDocument.getInvoiceDetails()) {
                BigDecimal newValue = invD.getInvoiceAmount().bigDecimalValue().multiply(percentage);
                KualiDecimal newKualiDecimalValue = new KualiDecimal(newValue.setScale(2, RoundingMode.DOWN));
                invD.setInvoiceAmount(newKualiDecimalValue);
                amountToBill = (KualiDecimal)amountToBill.add((AbstractKualiDecimal)newKualiDecimalValue);
                if (newValue.compareTo(largestAmount) <= 0) continue;
                largestAmount = newKualiDecimalValue.bigDecimalValue();
                largestCostCategory = invD;
            }
            if (!amountToBill.equals((Object)amountEligibleForBilling)) {
                KualiDecimal remaining = (KualiDecimal)amountEligibleForBilling.subtract((AbstractKualiDecimal)amountToBill);
                if (ObjectUtils.isNull(largestCostCategory) && CollectionUtils.isNotEmpty(contractsGrantsInvoiceDocument.getInvoiceDetails())) {
                    largestCostCategory = contractsGrantsInvoiceDocument.getInvoiceDetails().get(0);
                }
                if (ObjectUtils.isNotNull(largestCostCategory)) {
                    largestCostCategory.setInvoiceAmount((KualiDecimal)largestCostCategory.getInvoiceAmount().add((AbstractKualiDecimal)remaining));
                }
            }
            this.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocument);
        }
    }

    @Override
    public void addToAccountObjectCodeBilledTotal(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
            totalBilledKeys.put("proposalNumber", invoiceDetailAccountObjectCode.getProposalNumber());
            totalBilledKeys.put("chartOfAccountsCode", invoiceDetailAccountObjectCode.getChartOfAccountsCode());
            totalBilledKeys.put("accountNumber", invoiceDetailAccountObjectCode.getAccountNumber());
            totalBilledKeys.put("financialObjectCode", invoiceDetailAccountObjectCode.getFinancialObjectCode());
            List awardAccountObjectCodeTotalBilledList = (List)this.businessObjectService.findMatching(AwardAccountObjectCodeTotalBilled.class, totalBilledKeys);
            AwardAccountObjectCodeTotalBilled awardAccountObjectCodeTotalBilled = new AwardAccountObjectCodeTotalBilled();
            if (awardAccountObjectCodeTotalBilledList != null && !awardAccountObjectCodeTotalBilledList.isEmpty()) {
                awardAccountObjectCodeTotalBilled = (AwardAccountObjectCodeTotalBilled)((Object)awardAccountObjectCodeTotalBilledList.get(0));
                awardAccountObjectCodeTotalBilled.setTotalBilled((KualiDecimal)awardAccountObjectCodeTotalBilled.getTotalBilled().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures()));
            } else {
                awardAccountObjectCodeTotalBilled.setProposalNumber(invoiceDetailAccountObjectCode.getProposalNumber());
                awardAccountObjectCodeTotalBilled.setChartOfAccountsCode(invoiceDetailAccountObjectCode.getChartOfAccountsCode());
                awardAccountObjectCodeTotalBilled.setAccountNumber(invoiceDetailAccountObjectCode.getAccountNumber());
                awardAccountObjectCodeTotalBilled.setFinancialObjectCode(invoiceDetailAccountObjectCode.getFinancialObjectCode());
                awardAccountObjectCodeTotalBilled.setTotalBilled(invoiceDetailAccountObjectCode.getCurrentExpenditures());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)awardAccountObjectCodeTotalBilled);
        }
    }

    protected boolean adjustObjectCodeAmountsIfChanged(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        boolean isExpenditureValueChanged = false;
        List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes();
        HashMap invoiceDetailAccountObjectCodeMap = new HashMap();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            String categoryCode = invoiceDetailAccountObjectCode.getCategoryCode();
            List invoiceDetailAccountObjectCodeList = (List)invoiceDetailAccountObjectCodeMap.get(categoryCode);
            if (invoiceDetailAccountObjectCodeList == null) {
                ArrayList<InvoiceDetailAccountObjectCode> newInvoiceDetailAccountObjectCodeList = new ArrayList<InvoiceDetailAccountObjectCode>();
                newInvoiceDetailAccountObjectCodeList.add(invoiceDetailAccountObjectCode);
                invoiceDetailAccountObjectCodeMap.put(categoryCode, newInvoiceDetailAccountObjectCodeList);
                continue;
            }
            ((List)invoiceDetailAccountObjectCodeMap.get(categoryCode)).add(invoiceDetailAccountObjectCode);
        }
        for (ContractsGrantsInvoiceDetail invoiceDetail : contractsGrantsInvoiceDocument.getInvoiceDetails()) {
            KualiDecimal total = this.getSumOfExpendituresOfCategory((List)invoiceDetailAccountObjectCodeMap.get(invoiceDetail.getCategoryCode()));
            if (ObjectUtils.isNull((Object)invoiceDetail.getInvoiceAmount())) {
                invoiceDetail.setInvoiceAmount(KualiDecimal.ZERO);
            }
            if (invoiceDetail.getInvoiceAmount().compareTo((AbstractKualiDecimal)total) == 0) continue;
            this.recalculateObjectCodeByCategory(contractsGrantsInvoiceDocument, invoiceDetail, total, (List)invoiceDetailAccountObjectCodeMap.get(invoiceDetail.getCategoryCode()));
            isExpenditureValueChanged = true;
        }
        return isExpenditureValueChanged;
    }

    protected KualiDecimal getSumOfExpendituresOfCategory(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        KualiDecimal total = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull(invoiceDetailAccountObjectCodes)) {
            for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures());
            }
        }
        return total;
    }

    protected void recalculateObjectCodeByCategory(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, ContractsGrantsInvoiceDetail invoiceDetail, KualiDecimal total, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        block6: {
            KualiDecimal newTotalAmount;
            KualiDecimal currentExpenditure;
            block4: {
                block5: {
                    currentExpenditure = invoiceDetail.getInvoiceAmount();
                    newTotalAmount = KualiDecimal.ZERO;
                    if (total.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 0) break block4;
                    if (invoiceDetailAccountObjectCodes == null) break block5;
                    int numberOfObjectCodes = invoiceDetailAccountObjectCodes.size();
                    if (numberOfObjectCodes == 0) break block6;
                    KualiDecimal newAmount = new KualiDecimal(currentExpenditure.bigDecimalValue().divide(new BigDecimal(numberOfObjectCodes), 10, RoundingMode.HALF_DOWN));
                    for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
                        invoiceDetailAccountObjectCode.setCurrentExpenditures(newAmount);
                        newTotalAmount = (KualiDecimal)newTotalAmount.add((AbstractKualiDecimal)newAmount);
                    }
                    break block6;
                }
                this.assignCurrentExpenditureToNonExistingAccountObjectCode(contractsGrantsInvoiceDocument, invoiceDetail);
                break block6;
            }
            for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
                KualiDecimal newAmount = new KualiDecimal(invoiceDetailAccountObjectCode.getCurrentExpenditures().bigDecimalValue().divide(total.bigDecimalValue(), 10, RoundingMode.HALF_DOWN).multiply(currentExpenditure.bigDecimalValue()));
                invoiceDetailAccountObjectCode.setCurrentExpenditures(newAmount);
                newTotalAmount = (KualiDecimal)newTotalAmount.add((AbstractKualiDecimal)newAmount);
            }
            int remainderFromRounding = ((KualiDecimal)((KualiDecimal)currentExpenditure.subtract((AbstractKualiDecimal)newTotalAmount)).multiply((AbstractKualiDecimal)new KualiDecimal(100))).intValue();
            KualiDecimal addAmount = new KualiDecimal(0.01);
            if (remainderFromRounding < 0) {
                addAmount = new KualiDecimal(-0.01);
                remainderFromRounding = Math.abs(remainderFromRounding);
            }
            int objectCodeIndex = 0;
            for (int i = 0; i < remainderFromRounding; ++i) {
                InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = invoiceDetailAccountObjectCodes.get(objectCodeIndex);
                invoiceDetailAccountObjectCode.setCurrentExpenditures((KualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures().add((AbstractKualiDecimal)addAmount));
                if (++objectCodeIndex < invoiceDetailAccountObjectCodes.size()) continue;
                objectCodeIndex = 0;
            }
        }
    }

    protected void assignCurrentExpenditureToNonExistingAccountObjectCode(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, ContractsGrantsInvoiceDetail invoiceDetail) {
        String categoryCode = invoiceDetail.getCategoryCode();
        if (StringUtils.isBlank((CharSequence)categoryCode)) {
            throw new IllegalArgumentException("Category Code can not be null during recalculation of account object code for Contracts & Grants Invoice Document.");
        }
        CostCategory category = (CostCategory)this.businessObjectService.findBySinglePrimaryKey(CostCategory.class, (Object)categoryCode);
        if (ObjectUtils.isNotNull((Object)((Object)category))) {
            KualiDecimal oneCent = new KualiDecimal(0.01);
            int size = contractsGrantsInvoiceDocument.getAccountDetails().size();
            KualiDecimal amount = new KualiDecimal(invoiceDetail.getInvoiceAmount().bigDecimalValue().divide(new BigDecimal(size), 2, RoundingMode.HALF_UP));
            KualiDecimal remainder = (KualiDecimal)invoiceDetail.getInvoiceAmount().subtract((AbstractKualiDecimal)((KualiDecimal)amount.multiply((AbstractKualiDecimal)new KualiDecimal(size))));
            for (InvoiceAccountDetail invoiceAccountDetail : contractsGrantsInvoiceDocument.getAccountDetails()) {
                InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
                invoiceDetailAccountObjectCode.setDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
                invoiceDetailAccountObjectCode.setProposalNumber(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
                invoiceDetailAccountObjectCode.setCategoryCode(categoryCode);
                invoiceDetailAccountObjectCode.setAccountNumber(invoiceAccountDetail.getAccountNumber());
                invoiceDetailAccountObjectCode.setChartOfAccountsCode(invoiceAccountDetail.getChartOfAccountsCode());
                invoiceDetailAccountObjectCode.setCumulativeExpenditures(KualiDecimal.ZERO);
                invoiceDetailAccountObjectCode.setTotalBilled(KualiDecimal.ZERO);
                ObjectCodeCurrent objectCode = this.getCostCategoryService().findObjectCodeForChartAndCategory(invoiceAccountDetail.getChartOfAccountsCode(), categoryCode);
                if (ObjectUtils.isNotNull((Object)objectCode)) {
                    invoiceDetailAccountObjectCode.setFinancialObjectCode(objectCode.getFinancialObjectCode());
                }
                if (remainder.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    amount = (KualiDecimal)amount.add((AbstractKualiDecimal)oneCent);
                    remainder = (KualiDecimal)remainder.subtract((AbstractKualiDecimal)oneCent);
                } else if (remainder.isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)oneCent);
                    remainder = (KualiDecimal)remainder.add((AbstractKualiDecimal)oneCent);
                }
                invoiceDetailAccountObjectCode.setCurrentExpenditures(amount);
                List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes();
                if (invoiceDetailAccountObjectCodes.contains((Object)invoiceDetailAccountObjectCode)) {
                    InvoiceDetailAccountObjectCode original = invoiceDetailAccountObjectCodes.get(invoiceDetailAccountObjectCodes.indexOf((Object)invoiceDetailAccountObjectCode));
                    original.setCurrentExpenditures(amount);
                    original.setCategoryCode(categoryCode);
                    continue;
                }
                contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes().add(invoiceDetailAccountObjectCode);
            }
        } else {
            LOG.error("Category Code cannot be found from the category list during recalculation of account object code for Contracts & Grants Invoice Document.");
        }
    }

    public void recalculateAccountDetails(List<InvoiceAccountDetail> invoiceAccountDetails, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        HashMap<String, KualiDecimal> currentExpenditureByAccountNumberMap = new HashMap<String, KualiDecimal>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            String accountNumber = invoiceDetailAccountObjectCode.getAccountNumber();
            KualiDecimal expenditureSum = (KualiDecimal)currentExpenditureByAccountNumberMap.get(accountNumber);
            if (expenditureSum == null) {
                expenditureSum = KualiDecimal.ZERO;
            }
            expenditureSum = (KualiDecimal)expenditureSum.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures());
            currentExpenditureByAccountNumberMap.put(accountNumber, expenditureSum);
        }
        for (InvoiceAccountDetail invoiceAccountDetail : invoiceAccountDetails) {
            KualiDecimal expenditureAmount = ObjectUtils.isNull(currentExpenditureByAccountNumberMap.get(invoiceAccountDetail.getAccountNumber())) ? KualiDecimal.ZERO : (KualiDecimal)currentExpenditureByAccountNumberMap.get(invoiceAccountDetail.getAccountNumber());
            invoiceAccountDetail.setInvoiceAmount(expenditureAmount);
        }
    }

    @Override
    public KualiDecimal getAwardBilledToDateAmount(String proposalNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        Collection<ContractsGrantsInvoiceDocument> invoiceDocuments = this.retrieveAllCGInvoicesByCriteria(fieldValues);
        KualiDecimal milestoneTotal = this.getMilestonesBilledToDateAmount(proposalNumber);
        KualiDecimal billTotal = this.getPredeterminedBillingBilledToDateAmount(proposalNumber);
        KualiDecimal nonScheduledTotal = this.calculateTotalInvoiceAmount(invoiceDocuments);
        return (KualiDecimal)((KualiDecimal)milestoneTotal.add((AbstractKualiDecimal)billTotal)).add((AbstractKualiDecimal)nonScheduledTotal);
    }

    private KualiDecimal calculateTotalInvoiceAmount(Collection<ContractsGrantsInvoiceDocument> invoiceDocuments) {
        return invoiceDocuments.stream().filter(invoice -> !ArConstants.BillingFrequencyValues.isMilestone(invoice.getInvoiceGeneralDetail())).filter(invoice -> !ArConstants.BillingFrequencyValues.isPredeterminedBilling(invoice.getInvoiceGeneralDetail())).filter(invoice -> ObjectUtils.isNotNull((Object)invoice.getTotalInvoiceAmount())).reduce(KualiDecimal.ZERO, (sum, invoice) -> (KualiDecimal)invoice.getTotalInvoiceAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
    }

    @Override
    public KualiDecimal getAwardBilledToDateAmountExcludingDocument(String proposalNumber, String documentNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        fieldValues.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.financialSystemDocumentService.getSuccessfulDocumentStatuses(), (String)"|"));
        fieldValues.put("documentNumber", SearchOperator.NOT + documentNumber);
        Collection<ContractsGrantsInvoiceDocument> invoiceDocuments = this.retrieveAllCGInvoicesByCriteria(fieldValues);
        KualiDecimal milestoneTotal = this.getMilestonesBilledToDateAmount(proposalNumber);
        KualiDecimal billTotal = this.getPredeterminedBillingBilledToDateAmount(proposalNumber);
        KualiDecimal nonScheduledTotal = this.calculateTotalInvoiceAmount(invoiceDocuments);
        return (KualiDecimal)((KualiDecimal)milestoneTotal.add((AbstractKualiDecimal)billTotal)).add((AbstractKualiDecimal)nonScheduledTotal);
    }

    @Override
    public Collection<ContractsGrantsInvoiceDocument> retrieveAllCGInvoicesByCriteria(Map fieldValues) {
        return this.contractsGrantsInvoiceDocumentDao.getMatchingInvoicesByCollection(fieldValues);
    }

    @Override
    public KualiDecimal getBudgetAndActualsForAwardAccount(ContractsAndGrantsBillingAwardAccount awardAccount, String balanceTypeCode) {
        KualiDecimal balanceAmount = KualiDecimal.ZERO;
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        List basicExpenseObjectTypes = this.objectTypeService.getBasicExpenseObjectTypes(currentFiscalYear);
        String chartOfAccountsCode = awardAccount.getChartOfAccountsCode();
        String accountNumber = awardAccount.getAccountNumber();
        HashMap<String, Object> balanceKeys = new HashMap<String, Object>();
        balanceKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        balanceKeys.put("accountNumber", accountNumber);
        balanceKeys.put("universityFiscalYear", currentFiscalYear);
        balanceKeys.put("balanceTypeCode", balanceTypeCode);
        balanceKeys.put("objectTypeCode", basicExpenseObjectTypes);
        for (Balance balance : this.businessObjectService.findMatching(Balance.class, balanceKeys)) {
            if (!ObjectUtils.isNull((Object)balance.getSubAccount()) && !ObjectUtils.isNull((Object)balance.getSubAccount().getA21SubAccount()) && StringUtils.equalsIgnoreCase((CharSequence)balance.getSubAccount().getA21SubAccount().getSubAccountTypeCode(), (CharSequence)"CS")) continue;
            balanceAmount = (KualiDecimal)balanceAmount.add((AbstractKualiDecimal)this.calculateCumulativeBalanceAmount(balance));
        }
        return balanceAmount;
    }

    @Override
    public KualiDecimal calculateCumulativeBalanceAmount(Balance balance) {
        KualiDecimal balanceAmount = KualiDecimal.ZERO;
        if (this.isFirstFiscalPeriod()) {
            balanceAmount = (KualiDecimal)((KualiDecimal)balanceAmount.add((AbstractKualiDecimal)balance.getContractsGrantsBeginningBalanceAmount())).add((AbstractKualiDecimal)balance.getAccountLineAnnualBalanceAmount());
            if (!this.includePeriod13InPeriod01Calculations()) {
                balanceAmount = (KualiDecimal)balanceAmount.subtract((AbstractKualiDecimal)balance.getMonth13Amount());
            }
        } else {
            balanceAmount = (KualiDecimal)balanceAmount.add((AbstractKualiDecimal)this.calculateBalanceAmountWithoutLastBilledPeriod(balance));
        }
        return balanceAmount;
    }

    @Override
    public boolean isFirstFiscalPeriod() {
        AccountingPeriod currentPeriod = this.accountingPeriodService.getByDate(this.getDateTimeService().getCurrentSqlDate());
        return StringUtils.equals((CharSequence)currentPeriod.getUniversityFiscalPeriodCode(), (CharSequence)"01");
    }

    @Override
    public boolean includePeriod13InPeriod01Calculations() {
        return this.getParameterService().getParameterValueAsBoolean(ContractsGrantsInvoiceDocument.class, "INCLUDE_PERIOD_13_IND", Boolean.FALSE);
    }

    private KualiDecimal calculateBalanceAmountWithoutLastBilledPeriod(Balance glBalance) {
        Timestamp ts = new Timestamp(new Date().getTime());
        java.sql.Date today = new java.sql.Date(ts.getTime());
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        String currentPeriodCode = currPeriod.getUniversityFiscalPeriodCode();
        KualiDecimal currentBalanceAmount = KualiDecimal.ZERO;
        switch (currentPeriodCode) {
            case "13": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth12Amount());
            }
            case "12": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth11Amount());
            }
            case "11": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth10Amount());
            }
            case "10": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth9Amount());
            }
            case "09": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth8Amount());
            }
            case "08": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth7Amount());
            }
            case "07": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth6Amount());
            }
            case "06": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth5Amount());
            }
            case "05": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth4Amount());
            }
            case "04": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth3Amount());
            }
            case "03": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth2Amount());
            }
            case "02": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)glBalance.getMonth1Amount());
                break;
            }
        }
        return (KualiDecimal)glBalance.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)currentBalanceAmount);
    }

    @Override
    public void updateSuspensionCategoriesOnDocument(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (!contractsGrantsInvoiceDocument.isCorrectionDocument()) {
            String documentNumber = contractsGrantsInvoiceDocument.getDocumentNumber();
            if (ObjectUtils.isNotNull(this.suspensionCategories)) {
                for (SuspensionCategory suspensionCategory : this.suspensionCategories) {
                    InvoiceSuspensionCategory invoiceSuspensionCategory = new InvoiceSuspensionCategory(documentNumber, suspensionCategory.getCode());
                    if (suspensionCategory.shouldSuspend(contractsGrantsInvoiceDocument)) {
                        if (contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().contains((Object)invoiceSuspensionCategory)) continue;
                        contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().add(invoiceSuspensionCategory);
                        continue;
                    }
                    contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().remove((Object)invoiceSuspensionCategory);
                }
            }
        }
    }

    @Override
    public KualiDecimal calculateTotalPaymentsToDateByAward(ContractsAndGrantsBillingAward award) {
        KualiDecimal totalPayments = KualiDecimal.ZERO;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        Collection cgInvoiceDocs = this.businessObjectService.findMatching(ContractsGrantsInvoiceDocument.class, criteria);
        for (ContractsGrantsInvoiceDocument cgInvoiceDoc : cgInvoiceDocs) {
            totalPayments = (KualiDecimal)totalPayments.add((AbstractKualiDecimal)this.getCustomerInvoiceDocumentService().calculateAppliedPaymentAmount(cgInvoiceDoc));
        }
        return totalPayments;
    }

    public KualiDecimal getMilestonesBilledToDateAmount(String proposalNumber) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", proposalNumber);
        List milestones = (List)this.businessObjectService.findMatching(Milestone.class, totalBilledKeys);
        return this.calculateBilledToDateAmountForMilestones(milestones);
    }

    @Override
    public KualiDecimal getMilestonesBilledToDateAmount(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", proposalNumber);
        totalBilledKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        totalBilledKeys.put("accountNumber", accountNumber);
        List milestones = (List)this.businessObjectService.findMatching(Milestone.class, totalBilledKeys);
        return this.calculateBilledToDateAmountForMilestones(milestones);
    }

    private KualiDecimal calculateBilledToDateAmountForMilestones(List<Milestone> milestones) {
        return milestones.stream().filter(Milestone::isBilled).filter(milestone -> ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount())).reduce(KualiDecimal.ZERO, (sum, milestone) -> (KualiDecimal)milestone.getMilestoneAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
    }

    public KualiDecimal getPredeterminedBillingBilledToDateAmount(String proposalNumber) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", proposalNumber);
        List bills = (List)this.businessObjectService.findMatching(Bill.class, totalBilledKeys);
        return this.calculateBilledToDateAmountForBills(bills);
    }

    @Override
    public KualiDecimal getPredeterminedBillingBilledToDateAmount(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", proposalNumber);
        totalBilledKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        totalBilledKeys.put("accountNumber", accountNumber);
        List bills = (List)this.businessObjectService.findMatching(Bill.class, totalBilledKeys);
        return this.calculateBilledToDateAmountForBills(bills);
    }

    private KualiDecimal calculateBilledToDateAmountForBills(List<Bill> bills) {
        return bills.stream().filter(Bill::isBilled).filter(bill -> ObjectUtils.isNotNull((Object)bill.getEstimatedAmount())).reduce(KualiDecimal.ZERO, (sum, bill) -> (KualiDecimal)bill.getEstimatedAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
    }

    @Override
    public List<Account> getContractControlAccounts(ContractsAndGrantsBillingAward award) {
        if (!CollectionUtils.isEmpty((Collection)award.getActiveAwardAccounts())) {
            ArrayList<Account> controlAccounts = new ArrayList<Account>();
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (!ObjectUtils.isNotNull((Object)awardAccount.getAccount()) || !ObjectUtils.isNotNull((Object)awardAccount.getAccount().getContractControlAccount())) continue;
                controlAccounts.add(awardAccount.getAccount().getContractControlAccount());
            }
            if (CollectionUtils.isNotEmpty(controlAccounts)) {
                return controlAccounts;
            }
        }
        return null;
    }

    @Override
    public List<String> getProcessingFromBillingCodes(String billingChartCode, String billingOrgCode) {
        ArrayList<String> procCodes = new ArrayList<String>();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", billingChartCode);
        criteria.put("organizationCode", billingOrgCode);
        OrganizationOptions organizationOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        if (ObjectUtils.isNotNull((Object)((Object)organizationOptions))) {
            procCodes.add(0, organizationOptions.getProcessingChartOfAccountCode());
            procCodes.add(1, organizationOptions.getProcessingOrganizationCode());
        }
        return procCodes;
    }

    @Override
    public boolean canViewInvoice(ContractsGrantsInvoiceDocument invoice, String collectorPrincipalId) {
        HashMap<String, String> qualification = new HashMap<String, String>(3);
        qualification.put("billingChartOfAccountsCode", invoice.getBillByChartOfAccountCode());
        qualification.put("billingOrganizationCode", invoice.getBilledByOrganizationCode());
        qualification.put("processingChartOfAccountsCode", invoice.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode());
        qualification.put("processingOrganizationCode", invoice.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode());
        String customerName = invoice.getCustomerName();
        if (StringUtils.isNotBlank((CharSequence)customerName)) {
            qualification.put("customerName", customerName);
        }
        return this.getPermissionService().isAuthorized(collectorPrincipalId, "KFS-AR", "View Contracts & Grants Invoice in Billing Reports", qualification);
    }

    @Override
    public void generateInvoicesForInvoiceAddresses(ContractsGrantsInvoiceDocument document) {
        InvoiceGeneralDetail invoiceGeneralDetail = document.getInvoiceGeneralDetail();
        if (ObjectUtils.isNotNull((Object)invoiceGeneralDetail.getCustomerInvoiceTemplateCode())) {
            CustomerAddress customerAddress = invoiceGeneralDetail.getCustomerAddress();
            String customerAddressName = customerAddress.getCustomerAddressName();
            InvoiceTemplate invoiceTemplate = (InvoiceTemplate)this.businessObjectService.findBySinglePrimaryKey(InvoiceTemplate.class, (Object)invoiceGeneralDetail.getCustomerInvoiceTemplateCode());
            if (ObjectUtils.isNotNull((Object)((Object)invoiceTemplate)) && invoiceTemplate.isActive() && StringUtils.isNotBlank((CharSequence)invoiceTemplate.getFilename())) {
                ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
                String templateFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getTemplateFileDirectories().get("templates.directory");
                String templateFilePath = templateFolderPath + File.separator + invoiceTemplate.getFilename();
                File templateFile = new File(templateFilePath);
                try {
                    Map<String, String> replacementList = this.getTemplateParameterList(document);
                    byte[] reportStream = PdfFormFillerUtil.populateTemplate((File)templateFile, replacementList);
                    String outputFileName = this.buildFilenamePrefix(document, customerAddressName) + ".pdf";
                    String watermarkText = null;
                    if (ObjectUtils.isNotNull((Object)((Object)document.getInvoiceGeneralDetail())) && document.getInvoiceGeneralDetail().isFinalBillIndicator()) {
                        watermarkText = this.getConfigurationService().getPropertyValueAsString("invoice.address.pdf.final.watermark");
                    }
                    Long noteId = this.buildAndAddInvoiceNote(document, reportStream, customerAddressName, outputFileName, "invoice.address.pdf.final.note", watermarkText);
                    document.getInvoiceGeneralDetail().setInvoiceNoteId(noteId);
                    this.documentService.updateDocument((Document)document);
                }
                catch (IOException ex) {
                    this.addNoteForInvoiceReportFail(document);
                }
            } else {
                this.addNoteForInvoiceReportFail(document);
            }
        } else {
            this.addNoteForInvoiceReportFail(document);
        }
    }

    private String buildFilenamePrefix(ContractsGrantsInvoiceDocument document, String customerAddressName) {
        return document.getDocumentNumber() + "_" + customerAddressName + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate());
    }

    private Long buildAndAddInvoiceNote(ContractsGrantsInvoiceDocument document, byte[] reportStream, String customerAddressName, String outputFileName, String invoiceAddressPdfFinalNote, String watermarkText) throws IOException {
        Note note = new Note();
        note.setNotePostedTimestampToCurrent();
        String finalNotePattern = this.getConfigurationService().getPropertyValueAsString(invoiceAddressPdfFinalNote);
        note.setNoteText(MessageFormat.format(finalNotePattern, document.getDocumentNumber(), customerAddressName));
        note.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
        Person systemUser = this.personService.getPersonByPrincipalName("kfs");
        note = this.noteService.createNote(note, document.getNoteTarget(), systemUser.getPrincipalId());
        if (StringUtils.isNotBlank((CharSequence)watermarkText)) {
            try {
                reportStream = PdfFormFillerUtil.createWatermarkOnFile((byte[])reportStream, (String)watermarkText);
            }
            catch (DocumentException e) {
                this.addNoteForInvoiceReportFail(document);
            }
        }
        Attachment attachment = this.attachmentService.createAttachment((GloballyUnique)note, outputFileName, "application/pdf", reportStream.length, (InputStream)new ByteArrayInputStream(reportStream), "");
        note.setAttachment(attachment);
        this.noteService.save(note);
        attachment.setNoteIdentifier(note.getNoteIdentifier());
        this.businessObjectService.save((PersistableBusinessObject)attachment);
        document.addNote(note);
        return note.getNoteIdentifier();
    }

    protected Map<String, String> getTemplateParameterList(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.putAll(this.buildAccountDetailFieldsMap(document));
        parameterMap.putAll(this.buildCustomerFieldsMap(document));
        parameterMap.putAll(this.buildDocumentFieldsMap(document));
        parameterMap.putAll(this.buildDirectCostInvoiceDetailFieldsMap(document));
        parameterMap.putAll(this.buildTotalDirectCostInvoiceDetailFieldsMap(document));
        parameterMap.putAll(this.buildTotalIndirectCostInvoiceDetailFieldsMap(document));
        parameterMap.putAll(this.buildTotalCostInvoiceDetailFieldsMap(document));
        parameterMap.putAll(this.buildInvoiceGeneralDetailFieldsMap(document));
        parameterMap.putAll(this.buildInvoiceBillFieldsMap(document));
        parameterMap.putAll(this.buildInvoiceMilestoneFieldsMap(document));
        parameterMap.putAll(this.buildPayeeFieldsMap(document));
        parameterMap.putAll(this.buildSystemInformationMap(document));
        return parameterMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> this.stringifyValue(parameterMap.get(key)), (a, b) -> b));
    }

    private Map<String, Object> buildAccountDetailFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> accountDetailFieldsMap = new HashMap<String, Object>();
        List<InvoiceAccountDetail> accountDetails = document.getAccountDetails();
        if (CollectionUtils.isNotEmpty(accountDetails)) {
            accountDetailFieldsMap.put("accountDetails.contractControlAccountNumber", this.determineContractControlAccountNumber(document));
            for (int i = 0; i < accountDetails.size(); ++i) {
                String prefix = "accountDetails[" + i + "].";
                accountDetailFieldsMap.put(prefix + "accountNumber", accountDetails.get(i).getAccountNumber());
                accountDetailFieldsMap.put(prefix + "proposalNumber", accountDetails.get(i).getProposalNumber());
                accountDetailFieldsMap.put(prefix + "chartOfAccountsCode", accountDetails.get(i).getChartOfAccountsCode());
                accountDetailFieldsMap.put(prefix + "totalBudget", accountDetails.get(i).getTotalBudget());
                accountDetailFieldsMap.put(prefix + "invoiceAmount", accountDetails.get(i).getInvoiceAmount());
                accountDetailFieldsMap.put(prefix + "budgetRemaining", accountDetails.get(i).getBudgetRemaining());
            }
        }
        return accountDetailFieldsMap;
    }

    protected String determineContractControlAccountNumber(ContractsGrantsInvoiceDocument document) {
        List<Account> contractControlAccounts;
        ContractsAndGrantsBillingAward award;
        InvoiceGeneralDetail invoiceGeneralDetail = document.getInvoiceGeneralDetail();
        if (ObjectUtils.isNotNull((Object)((Object)invoiceGeneralDetail)) && ObjectUtils.isNotNull((Object)(award = invoiceGeneralDetail.getAward())) && CollectionUtils.isNotEmpty(contractControlAccounts = this.getContractControlAccounts(award))) {
            return contractControlAccounts.get(0).getAccountNumber();
        }
        List<InvoiceAccountDetail> accountDetails = document.getAccountDetails();
        if (CollectionUtils.isNotEmpty(accountDetails)) {
            return accountDetails.get(0).getAccountNumber();
        }
        return null;
    }

    private Map<String, Object> buildCustomerFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> customerFieldsMap = new HashMap<String, Object>();
        Customer customer = document.getCustomer();
        if (ObjectUtils.isNotNull((Object)((Object)customer))) {
            customerFieldsMap.put("customer.customerName", customer.getCustomerName());
        }
        return customerFieldsMap;
    }

    private Map<String, Object> buildDocumentFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> documentFieldsMap = new HashMap<String, Object>();
        documentFieldsMap.put("documentNumber", document.getDocumentNumber());
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (ObjectUtils.isNotNull((Object)workflowDocument.getDateCreated())) {
            documentFieldsMap.put("date", workflowDocument.getDateCreated().toDate());
        }
        if (ObjectUtils.isNotNull((Object)workflowDocument.getDateApproved())) {
            documentFieldsMap.put("finalStatusDate", workflowDocument.getDateApproved().toDate());
        }
        return documentFieldsMap;
    }

    private Map<String, Object> buildDirectCostInvoiceDetailFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> directCostInvoiceDetailFieldsMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(document.getDirectCostInvoiceDetails())) {
            ContractsGrantsInvoiceDetail firstInvoiceDetail = document.getDirectCostInvoiceDetails().get(0);
            for (int i = 0; i < document.getDirectCostInvoiceDetails().size(); ++i) {
                String prefix = "invoiceDetail[" + i + "].";
                directCostInvoiceDetailFieldsMap.put(prefix + "category", document.getDirectCostInvoiceDetails().get(i).getCostCategory().getCategoryName());
                directCostInvoiceDetailFieldsMap.putAll(this.buildInvoiceDetailFieldMap(prefix, document.getDirectCostInvoiceDetails().get(i)));
                directCostInvoiceDetailFieldsMap.put(prefix + "amountRemainingToBill", firstInvoiceDetail.getAmountRemainingToBill());
            }
        }
        return directCostInvoiceDetailFieldsMap;
    }

    private Map<String, Object> buildInvoiceDetailFieldMap(String prefix, ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail) {
        HashMap<String, Object> invoiceDetailFieldMap = new HashMap<String, Object>();
        invoiceDetailFieldMap.put(prefix + "totalBudget", contractsGrantsInvoiceDetail.getTotalBudget());
        invoiceDetailFieldMap.put(prefix + "invoiceAmount", contractsGrantsInvoiceDetail.getInvoiceAmount());
        invoiceDetailFieldMap.put(prefix + "cumulativeExpenditures", contractsGrantsInvoiceDetail.getCumulativeExpenditures());
        invoiceDetailFieldMap.put(prefix + "budgetRemaining", contractsGrantsInvoiceDetail.getBudgetRemaining());
        invoiceDetailFieldMap.put(prefix + "totalPreviouslyBilled", contractsGrantsInvoiceDetail.getTotalPreviouslyBilled());
        invoiceDetailFieldMap.put(prefix + "totalAmountBilledToDate", contractsGrantsInvoiceDetail.getTotalAmountBilledToDate());
        invoiceDetailFieldMap.put(prefix + "amountRemainingToBill", contractsGrantsInvoiceDetail.getAmountRemainingToBill());
        return invoiceDetailFieldMap;
    }

    private Map<String, Object> buildTotalDirectCostInvoiceDetailFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> totalDirectCostInvoiceDetailFieldsMap = new HashMap<String, Object>();
        ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail = document.getTotalDirectCostInvoiceDetail();
        if (ObjectUtils.isNotNull((Object)((Object)totalDirectCostInvoiceDetail))) {
            String prefix = "directCostInvoiceDetail.";
            totalDirectCostInvoiceDetailFieldsMap.putAll(this.buildInvoiceDetailFieldMap("directCostInvoiceDetail.", totalDirectCostInvoiceDetail));
        }
        return totalDirectCostInvoiceDetailFieldsMap;
    }

    private Map<String, Object> buildTotalIndirectCostInvoiceDetailFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> totalIndirectCostInvoiceDetailFieldsMap = new HashMap<String, Object>();
        ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail = document.getTotalIndirectCostInvoiceDetail();
        if (ObjectUtils.isNotNull((Object)((Object)totalInDirectCostInvoiceDetail))) {
            String prefix = "inDirectCostInvoiceDetail.";
            totalIndirectCostInvoiceDetailFieldsMap.putAll(this.buildInvoiceDetailFieldMap("inDirectCostInvoiceDetail.", totalInDirectCostInvoiceDetail));
        }
        return totalIndirectCostInvoiceDetailFieldsMap;
    }

    private Map<String, Object> buildTotalCostInvoiceDetailFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> totalCostInvoiceDetailFieldsMap = new HashMap<String, Object>();
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = document.getTotalCostInvoiceDetail();
        if (ObjectUtils.isNotNull((Object)((Object)totalCostInvoiceDetail))) {
            String prefix = "totalInvoiceDetail.";
            totalCostInvoiceDetailFieldsMap.putAll(this.buildInvoiceDetailFieldMap("totalInvoiceDetail.", totalCostInvoiceDetail));
        }
        return totalCostInvoiceDetailFieldsMap;
    }

    private Map<String, Object> buildInvoiceGeneralDetailFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> invoiceGeneralDetailFieldsMap = new HashMap<String, Object>();
        InvoiceGeneralDetail invoiceGeneralDetail = document.getInvoiceGeneralDetail();
        if (ObjectUtils.isNotNull((Object)((Object)invoiceGeneralDetail))) {
            invoiceGeneralDetailFieldsMap.put("advanceFlag", ArConstants.BillingFrequencyValues.isPredeterminedBilling(invoiceGeneralDetail));
            invoiceGeneralDetailFieldsMap.put("reimbursementFlag", !ArConstants.BillingFrequencyValues.isPredeterminedBilling(invoiceGeneralDetail));
            invoiceGeneralDetailFieldsMap.put("proposalNumber", invoiceGeneralDetail.getProposalNumber());
            String prefix = "invoiceGeneralDetail.";
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.awardDateRange", invoiceGeneralDetail.getAwardDateRange());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.billingFrequencyCode", invoiceGeneralDetail.getBillingFrequencyCode());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.finalBillIndicator", invoiceGeneralDetail.isFinalBillIndicator());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.billingPeriod", invoiceGeneralDetail.getBillingPeriod());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.instrumentTypeCode", invoiceGeneralDetail.getInstrumentTypeCode());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.awardTotal", invoiceGeneralDetail.getAwardTotal());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.amountRemainingToBill", invoiceGeneralDetail.getAmountRemainingToBill());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.costShareAmount", invoiceGeneralDetail.getCostShareAmount());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.lastBilledDate", invoiceGeneralDetail.getLastBilledDate());
            invoiceGeneralDetailFieldsMap.put("invoiceGeneralDetail.totalPreviouslyBilled", invoiceGeneralDetail.getTotalPreviouslyBilled());
            invoiceGeneralDetailFieldsMap.put("totalAmountDue", this.getTotalAmountForInvoice(document));
            invoiceGeneralDetailFieldsMap.put("customer.fullAddress", this.contractsGrantsBillingUtilityService.buildFullAddress(invoiceGeneralDetail.getCustomerAddress()));
            ContractsAndGrantsBillingAward award = invoiceGeneralDetail.getAward();
            if (ObjectUtils.isNotNull((Object)award)) {
                invoiceGeneralDetailFieldsMap.putAll(this.buildAwardFieldsMap(award));
            }
        }
        return invoiceGeneralDetailFieldsMap;
    }

    private Map<String, Object> buildAwardFieldsMap(ContractsAndGrantsBillingAward award) {
        HashMap<String, Object> awardFieldsMap = new HashMap<String, Object>();
        KualiDecimal billing = this.getAwardBilledToDateAmount(award.getProposalNumber());
        KualiDecimal payments = this.calculateTotalPaymentsToDateByAward(award);
        KualiDecimal receivable = (KualiDecimal)billing.subtract((AbstractKualiDecimal)payments);
        awardFieldsMap.put("award.billings", billing);
        awardFieldsMap.put("award.payments", payments);
        awardFieldsMap.put("award.receivables", receivable);
        awardFieldsMap.put("award.proposalNumber", award.getProposalNumber());
        if (ObjectUtils.isNotNull((Object)award.getAwardBeginningDate())) {
            awardFieldsMap.put("award.awardBeginningDate", award.getAwardBeginningDate());
        }
        if (ObjectUtils.isNotNull((Object)award.getAwardEndingDate())) {
            awardFieldsMap.put("award.awardEndingDate", award.getAwardEndingDate());
        }
        awardFieldsMap.put("award.awardTotalAmount", award.getAwardTotalAmount());
        awardFieldsMap.put("award.awardAddendumNumber", award.getAwardAddendumNumber());
        awardFieldsMap.put("award.awardAllocatedUniversityComputingServicesAmount", award.getAwardAllocatedUniversityComputingServicesAmount());
        awardFieldsMap.put("award.federalPassThroughFundedAmount", award.getFederalPassThroughFundedAmount());
        if (ObjectUtils.isNotNull((Object)award.getAwardEntryDate())) {
            awardFieldsMap.put("award.awardEntryDate", award.getAwardEntryDate());
        }
        awardFieldsMap.put("award.agencyFuture1Amount", award.getAgencyFuture1Amount());
        awardFieldsMap.put("award.agencyFuture2Amount", award.getAgencyFuture2Amount());
        awardFieldsMap.put("award.agencyFuture3Amount", award.getAgencyFuture3Amount());
        awardFieldsMap.put("award.awardDocumentNumber", award.getAwardDocumentNumber());
        if (ObjectUtils.isNotNull((Object)award.getAwardLastUpdateDate())) {
            awardFieldsMap.put("award.awardLastUpdateDate", award.getAwardLastUpdateDate());
        }
        awardFieldsMap.put("award.federalPassThroughIndicator", award.getFederalPassThroughIndicator());
        awardFieldsMap.put("award.awardDirectCostAmount", award.getAwardDirectCostAmount());
        awardFieldsMap.put("award.awardIndirectCostAmount", award.getAwardIndirectCostAmount());
        awardFieldsMap.put("award.grantDescriptionCode", award.getGrantDescriptionCode());
        ContractAndGrantsProposal proposal = award.getProposal();
        if (ObjectUtils.isNotNull((Object)proposal)) {
            awardFieldsMap.put("award.grantNumber", proposal.getGrantNumber());
        }
        awardFieldsMap.put("agencyNumber", award.getAgencyNumber());
        awardFieldsMap.put("agency.fullName", award.getAgency().getFullName());
        awardFieldsMap.put("award.federalPassThroughAgencyNumber", award.getFederalPassThroughAgencyNumber());
        awardFieldsMap.put("award.agencyAnalystName", award.getAgencyAnalystName());
        awardFieldsMap.put("award.analystTelephoneNumber", award.getAnalystTelephoneNumber());
        awardFieldsMap.put("award.billingFrequencyCode", award.getBillingFrequencyCode());
        awardFieldsMap.put("award.awardProjectTitle", award.getAwardProjectTitle());
        awardFieldsMap.put("award.awardPurposeCode", award.getAwardPurposeCode());
        awardFieldsMap.put("award.active", award.isActive());
        awardFieldsMap.put("award.excludedFromInvoicing", award.isExcludedFromInvoicing());
        awardFieldsMap.put("award.additionalFormsRequired", award.isAdditionalFormsRequiredIndicator());
        awardFieldsMap.put("award.additionalFormsDescription", award.getAdditionalFormsDescription());
        awardFieldsMap.put("award.instrumentTypeCode", award.getInstrumentTypeCode());
        awardFieldsMap.put("award.minInvoiceAmount", award.getMinInvoiceAmount());
        awardFieldsMap.put("award.autoApprove", award.getAutoApproveIndicator());
        awardFieldsMap.put("award.fundingExpirationDate", award.getFundingExpirationDate());
        if (ObjectUtils.isNotNull((Object)award.getAwardPrimaryProjectDirector())) {
            awardFieldsMap.put("award.awardProjectDirector.name", award.getAwardPrimaryProjectDirector().getProjectDirector().getName());
        }
        if (ObjectUtils.isNotNull((Object)award.getAwardPrimaryFundManager())) {
            Person fundManager = award.getAwardPrimaryFundManager().getFundManager();
            awardFieldsMap.put("award.primaryFundManager.name", fundManager.getName());
            awardFieldsMap.put("award.primaryFundManager.email", fundManager.getEmailAddress());
            awardFieldsMap.put("award.primaryFundManager.phone", fundManager.getPhoneNumber());
        }
        return awardFieldsMap;
    }

    private Map<String, Object> buildInvoiceBillFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> invoiceBillFieldsMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(document.getInvoiceBills())) {
            for (int i = 0; i < document.getInvoiceBills().size(); ++i) {
                String prefix = "invoiceBills[" + i + "].";
                invoiceBillFieldsMap.put(prefix + "billNumber", document.getInvoiceBills().get(i).getBillNumber());
                invoiceBillFieldsMap.put(prefix + "billDescription", document.getInvoiceBills().get(i).getBillDescription());
                invoiceBillFieldsMap.put(prefix + "billDate", document.getInvoiceBills().get(i).getBillDate());
                invoiceBillFieldsMap.put(prefix + "estimatedAmount", document.getInvoiceBills().get(i).getEstimatedAmount());
            }
        }
        return invoiceBillFieldsMap;
    }

    private Map<String, Object> buildInvoiceMilestoneFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> invoiceMilestoneFieldsMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(document.getInvoiceMilestones())) {
            for (int i = 0; i < document.getInvoiceMilestones().size(); ++i) {
                String prefix = "invoiceMilestones[" + i + "].";
                invoiceMilestoneFieldsMap.put(prefix + "milestoneNumber", document.getInvoiceMilestones().get(i).getMilestoneNumber());
                invoiceMilestoneFieldsMap.put(prefix + "milestoneDescription", document.getInvoiceMilestones().get(i).getMilestoneDescription());
                invoiceMilestoneFieldsMap.put(prefix + "milestoneAmount", document.getInvoiceMilestones().get(i).getMilestoneAmount());
                invoiceMilestoneFieldsMap.put(prefix + "milestoneActualCompletionDate", document.getInvoiceMilestones().get(i).getMilestoneActualCompletionDate());
            }
        }
        return invoiceMilestoneFieldsMap;
    }

    private Map<String, Object> buildPayeeFieldsMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("payee.name", document.getBillingAddressName());
        parameterMap.put("payee.addressLine1", document.getBillingLine1StreetAddress());
        parameterMap.put("payee.addressLine2", document.getBillingLine2StreetAddress());
        parameterMap.put("payee.city", document.getBillingCityName());
        parameterMap.put("payee.state", document.getBillingStateCode());
        parameterMap.put("payee.zipcode", document.getBillingZipCode());
        return parameterMap;
    }

    private Map<String, Object> buildSystemInformationMap(ContractsGrantsInvoiceDocument document) {
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        primaryKeys.put("universityFiscalYear", document.getAccountingPeriod().getUniversityFiscalYear());
        primaryKeys.put("processingChartOfAccountCode", document.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode());
        primaryKeys.put("processingOrganizationCode", document.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode());
        SystemInformation sysInfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, primaryKeys);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (ObjectUtils.isNotNull((Object)((Object)sysInfo))) {
            parameterMap.put("systemInformation.feinNumber", sysInfo.getUniversityFederalEmployerIdentificationNumber());
            parameterMap.put("systemInformation.name", sysInfo.getOrganizationRemitToAddressName());
            parameterMap.put("systemInformation.addressLine1", sysInfo.getOrganizationRemitToLine1StreetAddress());
            parameterMap.put("systemInformation.addressLine2", sysInfo.getOrganizationRemitToLine2StreetAddress());
            parameterMap.put("systemInformation.city", sysInfo.getOrganizationRemitToCityName());
            parameterMap.put("systemInformation.state", sysInfo.getOrganizationRemitToStateCode());
            parameterMap.put("systemInformation.zipcode", sysInfo.getOrganizationRemitToZipCode());
        }
        return parameterMap;
    }

    protected String stringifyValue(Object value) {
        if (ObjectUtils.isNull((Object)value)) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return this.getDateTimeService().toDateString((Date)value);
        }
        if (value instanceof Boolean) {
            return this.stringifyBooleanForContractsGrantsInvoiceTemplate((Boolean)value);
        }
        if (value instanceof KualiDecimal) {
            return this.contractsGrantsBillingUtilityService.formatForCurrency((KualiDecimal)value);
        }
        return value.toString();
    }

    protected String stringifyBooleanForContractsGrantsInvoiceTemplate(boolean bool) {
        return bool ? "Yes" : "No";
    }

    @Override
    public void updateLastBilledDate(ContractsGrantsInvoiceDocument document) {
        boolean isFinalBill = document.getInvoiceGeneralDetail().isFinalBillIndicator();
        for (InvoiceAccountDetail id : document.getAccountDetails()) {
            if (isFinalBill) {
                this.setAwardAccountFinalBilledValueAndLastBilledDate(id, true, document.getInvoiceGeneralDetail().getProposalNumber(), document.isInvoiceReversal(), document.getInvoiceGeneralDetail().getLastBilledDate());
                continue;
            }
            this.calculateAwardAccountLastBilledDate(id, document.isInvoiceReversal(), document.getInvoiceGeneralDetail().getLastBilledDate(), document.getInvoiceGeneralDetail().getProposalNumber());
        }
        String proposalNumber = document.getInvoiceGeneralDetail().getProposalNumber();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", proposalNumber);
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
        if (CollectionUtils.isNotEmpty((Collection)award.getActiveAwardAccounts())) {
            this.contractsAndGrantsModuleBillingService.setLastBilledDateToAward(proposalNumber, this.getLastBilledDate(award));
        }
    }

    @Override
    public java.sql.Date getLastBilledDate(ContractsAndGrantsBillingAward award) {
        java.sql.Date awdLastBilledDate = null;
        if (ObjectUtils.isNotNull((Object)award)) {
            awdLastBilledDate = award.getActiveAwardAccounts().stream().filter(awardAccount -> ObjectUtils.isNotNull((Object)awardAccount.getCurrentLastBilledDate())).sorted(Comparator.comparing(ContractsAndGrantsBillingAwardAccount::getCurrentLastBilledDate, Comparator.nullsLast(Comparator.reverseOrder()))).map(awardAccount -> awardAccount.getCurrentLastBilledDate()).findFirst().orElse(null);
        }
        return awdLastBilledDate;
    }

    protected void calculateAwardAccountLastBilledDate(InvoiceAccountDetail id, boolean invoiceReversal, java.sql.Date lastBilledDate, String proposalNumber) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", id.getAccountNumber());
        mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
        mapKey.put("proposalNumber", proposalNumber);
        this.contractsAndGrantsModuleBillingService.setLastBilledDateToAwardAccount(mapKey, invoiceReversal, lastBilledDate);
    }

    @Override
    public void updateBillsAndMilestones(boolean billed, List<InvoiceMilestone> invoiceMilestones, List<InvoiceBill> invoiceBills) {
        this.updateMilestonesBilledIndicator(billed, invoiceMilestones);
        this.updateBillsBilledIndicator(billed, invoiceBills);
    }

    @Override
    public void updateMilestonesBilledIndicator(boolean billed, List<InvoiceMilestone> invoiceMilestones) {
        if (CollectionUtils.isNotEmpty(invoiceMilestones)) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            for (InvoiceMilestone invoiceMilestone : invoiceMilestones) {
                milestoneIds.add(invoiceMilestone.getMilestoneIdentifier());
            }
            if (CollectionUtils.isNotEmpty(milestoneIds)) {
                this.setMilestonesBilled(milestoneIds, billed);
            }
        }
    }

    protected void setMilestonesBilled(List<Long> milestoneIds, boolean billed) {
        HashMap<String, List<Long>> fieldValues = new HashMap<String, List<Long>>();
        fieldValues.put("milestoneIdentifier", milestoneIds);
        List milestones = (List)this.getBusinessObjectService().findMatching(Milestone.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)milestones)) {
            for (Milestone milestone : milestones) {
                milestone.setBilled(billed);
            }
            this.getBusinessObjectService().save(milestones);
        }
    }

    @Override
    public void updateBillsBilledIndicator(boolean billed, List<InvoiceBill> invoiceBills) {
        if (CollectionUtils.isNotEmpty(invoiceBills)) {
            ArrayList<Long> billIds = new ArrayList<Long>();
            for (InvoiceBill invoiceBill : invoiceBills) {
                billIds.add(invoiceBill.getBillIdentifier());
            }
            if (CollectionUtils.isNotEmpty(invoiceBills)) {
                this.setBillsBilled(billIds, billed);
            }
        }
    }

    protected void setBillsBilled(List<Long> billIds, boolean billed) {
        HashMap<String, List<Long>> fieldValues = new HashMap<String, List<Long>>();
        fieldValues.put("billIdentifier", billIds);
        List bills = (List)this.getBusinessObjectService().findMatching(Bill.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)bills)) {
            for (Bill bill : bills) {
                bill.setBilled(billed);
            }
            this.getBusinessObjectService().save(bills);
        }
    }

    protected void setAwardAccountFinalBilledValue(InvoiceAccountDetail id, boolean value, String proposalNumber) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", id.getAccountNumber());
        mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
        mapKey.put("proposalNumber", proposalNumber);
        this.contractsAndGrantsModuleBillingService.setFinalBilledToAwardAccount(mapKey, value);
    }

    protected void setAwardAccountFinalBilledValueAndLastBilledDate(InvoiceAccountDetail id, boolean finalBilled, String proposalNumber, boolean invoiceReversal, java.sql.Date lastBilledDate) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", id.getAccountNumber());
        mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
        mapKey.put("proposalNumber", proposalNumber);
        this.contractsAndGrantsModuleBillingService.setFinalBilledAndLastBilledDateToAwardAccount(mapKey, finalBilled, invoiceReversal, lastBilledDate);
    }

    @Override
    public void updateUnfinalizationToAwardAccount(List<InvoiceAccountDetail> accountDetails, String proposalNumber) {
        Iterator<InvoiceAccountDetail> iterator = accountDetails.iterator();
        while (iterator.hasNext()) {
            InvoiceAccountDetail entry;
            InvoiceAccountDetail id = entry = iterator.next();
            this.setAwardAccountFinalBilledValue(id, false, proposalNumber);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void correctContractsGrantsInvoiceDocument(ContractsGrantsInvoiceDocument document) {
        void var3_12;
        for (ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail : document.getDirectCostInvoiceDetails()) {
            this.correctInvoiceDetail(contractsGrantsInvoiceDetail);
        }
        for (ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail : document.getIndirectCostInvoiceDetails()) {
            this.correctInvoiceDetail(contractsGrantsInvoiceDetail);
        }
        for (InvoiceAccountDetail invoiceAccountDetail : document.getAccountDetails()) {
            this.correctInvoiceAccountDetail(invoiceAccountDetail);
        }
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : document.getInvoiceDetailAccountObjectCodes()) {
            invoiceDetailAccountObjectCode.correctInvoiceDetailAccountObjectCodeExpenditureAmount();
        }
        KualiDecimal totalBillingAmount = KualiDecimal.ZERO;
        for (InvoiceBill invoiceBill : document.getInvoiceBills()) {
            invoiceBill.setEstimatedAmount((KualiDecimal)invoiceBill.getEstimatedAmount().negated());
            totalBillingAmount = (KualiDecimal)totalBillingAmount.add((AbstractKualiDecimal)invoiceBill.getEstimatedAmount());
        }
        KualiDecimal kualiDecimal = KualiDecimal.ZERO;
        for (InvoiceMilestone milestone : document.getInvoiceMilestones()) {
            milestone.setMilestoneAmount((KualiDecimal)milestone.getMilestoneAmount().negated());
            KualiDecimal kualiDecimal2 = (KualiDecimal)var3_12.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
        }
        document.getInvoiceGeneralDetail().setTotalPreviouslyBilled(this.getAwardBilledToDateAmountExcludingDocument(document.getInvoiceGeneralDetail().getProposalNumber(), document.getDocumentNumber()));
        if (ArConstants.BillingFrequencyValues.isMilestone(document.getInvoiceGeneralDetail()) && CollectionUtils.isNotEmpty(document.getInvoiceMilestones())) {
            document.getInvoiceGeneralDetail().setTotalAmountBilledToDate((KualiDecimal)document.getInvoiceGeneralDetail().getTotalAmountBilledToDate().add((AbstractKualiDecimal)var3_12));
        } else if (ArConstants.BillingFrequencyValues.isPredeterminedBilling(document.getInvoiceGeneralDetail()) && CollectionUtils.isNotEmpty(document.getInvoiceBills())) {
            document.getInvoiceGeneralDetail().setTotalAmountBilledToDate((KualiDecimal)document.getInvoiceGeneralDetail().getTotalAmountBilledToDate().add((AbstractKualiDecimal)totalBillingAmount));
        } else {
            KualiDecimal kualiDecimal4 = (KualiDecimal)document.getTotalCostInvoiceDetail().getInvoiceAmount().add((AbstractKualiDecimal)document.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
            kualiDecimal4 = (KualiDecimal)kualiDecimal4.add((AbstractKualiDecimal)this.getOtherTotalBilledForAwardPeriod(document));
            document.getInvoiceGeneralDetail().setTotalAmountBilledToDate(kualiDecimal4);
            this.calculatePreviouslyBilledAmounts(document);
        }
        for (InvoiceAddressDetail invoiceAddressDetail : document.getInvoiceAddressDetails()) {
            invoiceAddressDetail.setInitialTransmissionDate(null);
            invoiceAddressDetail.setTransmittedByPrincipalId("");
            invoiceAddressDetail.setTransmissionDate(null);
            invoiceAddressDetail.setTransmissionStatusCode("");
            invoiceAddressDetail.setTransmissionCount(0);
        }
    }

    protected void correctInvoiceDetail(ContractsGrantsInvoiceDetail invoiceDetail) {
        invoiceDetail.setTotalPreviouslyBilled((KualiDecimal)invoiceDetail.getTotalPreviouslyBilled().add((AbstractKualiDecimal)invoiceDetail.getInvoiceAmount()));
        invoiceDetail.setCumulativeExpenditures((KualiDecimal)invoiceDetail.getCumulativeExpenditures().subtract((AbstractKualiDecimal)invoiceDetail.getInvoiceAmount()));
        invoiceDetail.setInvoiceAmount((KualiDecimal)invoiceDetail.getInvoiceAmount().negated());
        invoiceDetail.setInvoiceDocument(null);
    }

    protected void correctInvoiceAccountDetail(InvoiceAccountDetail invoiceAccountDetail) {
        invoiceAccountDetail.setTotalPreviouslyBilled((KualiDecimal)invoiceAccountDetail.getTotalPreviouslyBilled().add((AbstractKualiDecimal)invoiceAccountDetail.getInvoiceAmount()));
        invoiceAccountDetail.setCumulativeExpenditures((KualiDecimal)invoiceAccountDetail.getCumulativeExpenditures().subtract((AbstractKualiDecimal)invoiceAccountDetail.getInvoiceAmount()));
        invoiceAccountDetail.setInvoiceAmount((KualiDecimal)invoiceAccountDetail.getInvoiceAmount().negated());
        invoiceAccountDetail.setInvoiceDocument(null);
    }

    protected void addNoteForInvoiceReportFail(ContractsGrantsInvoiceDocument document) {
        Note note = new Note();
        note.setNotePostedTimestampToCurrent();
        note.setNoteText(this.configurationService.getPropertyValueAsString("error.fileUpload.save.noPdfFileSelected"));
        note.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
        Person systemUser = this.personService.getPersonByPrincipalName("kfs");
        note = this.noteService.createNote(note, document.getNoteTarget(), systemUser.getPrincipalId());
        this.noteService.save(note);
        document.addNote(note);
    }

    @Override
    public List<String> checkAwardContractControlAccounts(ContractsAndGrantsBillingAward award) {
        ArrayList<String> errorString = new ArrayList<String>();
        boolean isValid = true;
        int accountNum = award.getActiveAwardAccounts().size();
        if (ObjectUtils.isNotNull((Object)award.getInvoicingOptionCode())) {
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (!ObjectUtils.isNull((Object)awardAccount.getAccount()) && !ObjectUtils.isNull((Object)awardAccount.getAccount().getContractControlAccount())) continue;
                isValid = false;
                break;
            }
            if (award.getInvoicingOptionCode().equalsIgnoreCase("3")) {
                if (!isValid) {
                    errorString.add("error.cg.no.control.account");
                    errorString.add(award.getInvoicingOptionDescription());
                }
            } else if (award.getInvoicingOptionCode().equalsIgnoreCase("1")) {
                if (!isValid) {
                    errorString.add("error.cg.no.control.account");
                    errorString.add(award.getInvoicingOptionDescription());
                } else if (accountNum != 1) {
                    Object[] awardAccounts = award.getActiveAwardAccounts().toArray();
                    for (int i = 0; i < awardAccounts.length - 1; ++i) {
                        Account tmpAcct1 = ((ContractsAndGrantsBillingAwardAccount)awardAccounts[i]).getAccount().getContractControlAccount();
                        Account tmpAcct2 = ((ContractsAndGrantsBillingAwardAccount)awardAccounts[i + 1]).getAccount().getContractControlAccount();
                        if (!ObjectUtils.isNull((Object)tmpAcct1) && tmpAcct1.equals((Object)tmpAcct2)) continue;
                        errorString.add("error.cg.multiple.control.account");
                        errorString.add(award.getInvoicingOptionDescription());
                    }
                }
            }
        }
        return errorString;
    }

    @Override
    public boolean isInvoiceDocumentEffective(String documentNumber) {
        DocumentHeader invoiceDocHeader = (DocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(DocumentHeader.class, (Object)documentNumber);
        String documentStatus = invoiceDocHeader.getWorkflowDocumentStatusCode();
        if (StringUtils.isBlank((CharSequence)invoiceDocHeader.getFinancialDocumentInErrorNumber()) && !StringUtils.equals((CharSequence)documentStatus, (CharSequence)DocumentStatus.CANCELED.getCode()) && !StringUtils.equals((CharSequence)documentStatus, (CharSequence)DocumentStatus.DISAPPROVED.getCode())) {
            DocumentHeader correctingDocumentHeader = this.getFinancialSystemDocumentService().getCorrectingDocumentHeader(documentNumber);
            return ObjectUtils.isNull((Object)correctingDocumentHeader) || this.isCorrectedInvoiceDocumentEffective(correctingDocumentHeader.getDocumentNumber());
        }
        return false;
    }

    protected boolean isCorrectedInvoiceDocumentEffective(String errorCorrectionDocumentNumber) {
        DocumentHeader invoiceDocHeader = (DocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(DocumentHeader.class, (Object)errorCorrectionDocumentNumber);
        String documentStatus = invoiceDocHeader.getWorkflowDocumentStatusCode();
        if (this.getFinancialSystemDocumentService().getPendingDocumentStatuses().contains(documentStatus)) {
            return true;
        }
        DocumentHeader correctingDocumentHeader = this.getFinancialSystemDocumentService().getCorrectingDocumentHeader(errorCorrectionDocumentNumber);
        return ObjectUtils.isNotNull((Object)correctingDocumentHeader) && this.isCorrectedInvoiceDocumentEffective(correctingDocumentHeader.getDocumentNumber());
    }

    @Override
    public boolean isTemplateValidForContractsGrantsInvoiceDocument(InvoiceTemplate invoiceTemplate, ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (ObjectUtils.isNotNull((Object)contractsGrantsInvoiceDocument)) {
            return StringUtils.equals((CharSequence)invoiceTemplate.getBillByChartOfAccountCode(), (CharSequence)contractsGrantsInvoiceDocument.getBillByChartOfAccountCode()) && StringUtils.equals((CharSequence)invoiceTemplate.getBilledByOrganizationCode(), (CharSequence)contractsGrantsInvoiceDocument.getBilledByOrganizationCode());
        }
        return true;
    }

    @Override
    public boolean doesCostCategoryContainObjectCode(CostCategory category, String chartOfAccountsCode, String objectCode) {
        if (!CollectionUtils.isEmpty(category.getObjectCodes())) {
            for (CostCategoryObjectCode categoryObjectCode : category.getObjectCodes()) {
                if (!StringUtils.equals((CharSequence)categoryObjectCode.getChartOfAccountsCode(), (CharSequence)chartOfAccountsCode) || !StringUtils.equals((CharSequence)categoryObjectCode.getFinancialObjectCode(), (CharSequence)objectCode)) continue;
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(category.getObjectLevels())) {
            for (CostCategoryObjectLevel categoryObjectLevel : category.getObjectLevels()) {
                if (!this.getObjectCodeService().doesObjectLevelContainObjectCode(categoryObjectLevel.getChartOfAccountsCode(), categoryObjectLevel.getFinancialObjectLevelCode(), chartOfAccountsCode, objectCode)) continue;
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(category.getObjectConsolidations())) {
            for (CostCategoryObjectConsolidation categoryObjectConsolidation : category.getObjectConsolidations()) {
                if (!this.getObjectCodeService().doesObjectConsolidationContainObjectCode(categoryObjectConsolidation.getChartOfAccountsCode(), categoryObjectConsolidation.getFinConsolidationObjectCode(), chartOfAccountsCode, objectCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, List<ContractsGrantsInvoiceDocument>> getInvoicesByAward(Collection<ContractsGrantsInvoiceDocument> invoices) {
        HashMap<String, List<ContractsGrantsInvoiceDocument>> invoicesByAward = new HashMap<String, List<ContractsGrantsInvoiceDocument>>();
        for (ContractsGrantsInvoiceDocument invoice : invoices) {
            String proposalNumber = invoice.getInvoiceGeneralDetail().getProposalNumber();
            if (invoicesByAward.containsKey(proposalNumber)) {
                ((List)invoicesByAward.get(proposalNumber)).add(invoice);
                continue;
            }
            ArrayList<ContractsGrantsInvoiceDocument> invoicesByProposalNumber = new ArrayList<ContractsGrantsInvoiceDocument>();
            invoicesByProposalNumber.add(invoice);
            invoicesByAward.put(proposalNumber, invoicesByProposalNumber);
        }
        return invoicesByAward;
    }

    @Override
    public void recalculateSourceAccountingLineTotals(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (!CollectionUtils.isEmpty((Collection)contractsGrantsInvoiceDocument.getSourceAccountingLines())) {
            if (contractsGrantsInvoiceDocument.getSourceAccountingLines().size() == 1) {
                CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)contractsGrantsInvoiceDocument.getSourceAccountingLine(0);
                customerInvoiceDetail.setAmount(this.getTotalAmountForInvoice(contractsGrantsInvoiceDocument));
            } else {
                Map<String, KualiDecimal> accountExpenditureAmounts = this.getCategoryExpenditureAmountsForInvoiceAccountDetail(contractsGrantsInvoiceDocument);
                for (Object al : contractsGrantsInvoiceDocument.getSourceAccountingLines()) {
                    CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)al;
                    String accountKey = StringUtils.join((Object[])new String[]{customerInvoiceDetail.getChartOfAccountsCode(), customerInvoiceDetail.getAccountNumber()}, (String)"-");
                    customerInvoiceDetail.setAmount(accountExpenditureAmounts.getOrDefault(accountKey, KualiDecimal.ZERO));
                }
            }
        }
    }

    @Override
    public boolean isDocumentBatchCreated(ContractsGrantsInvoiceDocument document) {
        if (document.getInvoiceGeneralDetail().getAward().getAutoApproveIndicator()) {
            Person batchJobInitiator = this.getContractsGrantsInvoiceBatchCreationUser();
            return StringUtils.equalsIgnoreCase((CharSequence)document.getDocumentHeader().getInitiatorPrincipalId(), (CharSequence)batchJobInitiator.getPrincipalId());
        }
        return false;
    }

    @Override
    public boolean doesInvoicePassValidation(final ContractsGrantsInvoiceDocument document) {
        try {
            return (Boolean)GlobalVariables.doInNewGlobalVariables((UserSession)new UserSession(this.getContractsGrantsInvoiceBatchCreationUser().getPrincipalName()), (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AttributedRouteDocumentEvent routeEvent = new AttributedRouteDocumentEvent((Document)document);
                    ContractsGrantsInvoiceDocumentServiceImpl.this.getKualiRuleService().applyRules((KualiDocumentEvent)routeEvent);
                    return !GlobalVariables.getMessageMap().hasErrors();
                }
            });
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = document::getDocumentNumber;
            supplierArray[1] = () -> e;
            LOG.error("Running validation on Contracts & Grants Invoice {} caused an exception", supplierArray);
            return false;
        }
    }

    protected Person getContractsGrantsInvoiceBatchCreationUser() {
        String batchJobInitiatorPrincipalName = this.parameterService.getParameterValueAsString(ContractsGrantsInvoiceDocumentBatchStep.class, "USER", "kfs");
        Person batchJobInitiator = this.personService.getPersonByPrincipalName(batchJobInitiatorPrincipalName);
        return ObjectUtils.isNull((Object)batchJobInitiator) ? this.personService.getPersonByPrincipalName("kfs") : batchJobInitiator;
    }

    @Override
    public void markManuallySent(ContractsGrantsInvoiceDocument document) {
        document.getInvoiceAddressDetails().stream().filter(InvoiceAddressDetail::isSendIndicator).forEach(detail -> {
            detail.markSent();
            detail.setSendIndicator(false);
            String transmissionNotePattern = this.getConfigurationService().getPropertyValueAsString("invoice.address.manual.transmission.note");
            String noteText = MessageFormat.format(transmissionNotePattern, GlobalVariables.getUserSession().getUserToLog(), detail.getInvoiceTransmissionMethodCode().toLowerCase(Locale.US));
            this.addNoteToInvoiceDocument(document, noteText);
        });
        this.documentService.updateDocument((Document)document);
    }

    @Override
    public void queueInvoiceTransmissions(ContractsGrantsInvoiceDocument document) {
        document.getInvoiceAddressDetails().stream().filter(InvoiceAddressDetail::isSendIndicator).forEach(detail -> {
            detail.setTransmissionStatusCode(TransmissionDetailStatus.Queued.getCode());
            detail.setSendIndicator(false);
        });
        this.documentService.updateDocument((Document)document);
    }

    @Override
    public void updateFinalBillIndicator(ContractsGrantsInvoiceDocument document) {
        InvoiceGeneralDetail invoiceGeneralDetail = document.getInvoiceGeneralDetail();
        boolean newFinalBill = !invoiceGeneralDetail.isFinalBillIndicator();
        invoiceGeneralDetail.setFinalBillIndicator(newFinalBill);
        String noteText = GlobalVariables.getUserSession().getPerson().getName() + " updated Final Bill to " + (invoiceGeneralDetail.isFinalBillIndicator() ? "Yes" : "No");
        this.addNoteToInvoiceDocument(document, noteText);
        this.documentService.updateDocument((Document)document);
        ContractsAndGrantsBillingAward award = invoiceGeneralDetail.getAward();
        for (ContractsAndGrantsBillingAwardAccount cgAwardAccount : award.getActiveAwardAccounts()) {
            this.contractsAndGrantsModuleBillingService.setFinalBilledToAwardAccount(Map.of("accountNumber", cgAwardAccount.getAccountNumber(), "chartOfAccountsCode", cgAwardAccount.getChartOfAccountsCode(), "proposalNumber", cgAwardAccount.getAward().getProposalNumber()), newFinalBill);
        }
        this.documentService.updateDocument((Document)document);
    }

    @Override
    public void addInvoiceTransmissionNote(ContractsGrantsInvoiceDocument document, String invoiceTransmissionMethod) {
        String transmissionNotePattern = this.getConfigurationService().getPropertyValueAsString("invoice.address.transmission.note");
        String noteText = MessageFormat.format(transmissionNotePattern, GlobalVariables.getUserSession().getUserToLog(), invoiceTransmissionMethod.toLowerCase(Locale.US));
        this.addNoteToInvoiceDocument(document, noteText);
    }

    protected void addNoteToInvoiceDocument(ContractsGrantsInvoiceDocument document, String noteText) {
        Note note = new Note();
        note.setNotePostedTimestampToCurrent();
        note.setNoteText(noteText);
        note.setNoteTypeCode(document.getNoteType().getCode());
        Person systemUser = this.personService.getPersonByPrincipalName("kfs");
        note = this.noteService.createNote(note, document.getNoteTarget(), systemUser.getPrincipalId());
        this.noteService.save(note);
        document.addNote(note);
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setContractsGrantsInvoiceDocumentDao(ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao) {
        this.contractsGrantsInvoiceDocumentDao = contractsGrantsInvoiceDocumentDao;
    }

    public void setContractsGrantsBillingUtilityService(ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService) {
        this.contractsGrantsBillingUtilityService = contractsGrantsBillingUtilityService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    @Override
    public List<SuspensionCategory> getSuspensionCategories() {
        return this.suspensionCategories;
    }

    public void setSuspensionCategories(List<SuspensionCategory> suspensionCategories) {
        this.suspensionCategories = suspensionCategories;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public AccountsReceivablePendingEntryService getAccountsReceivablePendingEntryService() {
        return this.accountsReceivablePendingEntryService;
    }

    public void setAccountsReceivablePendingEntryService(AccountsReceivablePendingEntryService accountsReceivablePendingEntryService) {
        this.accountsReceivablePendingEntryService = accountsReceivablePendingEntryService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public CostCategoryService getCostCategoryService() {
        return this.costCategoryService;
    }

    public void setCostCategoryService(CostCategoryService costCategoryService) {
        this.costCategoryService = costCategoryService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }
}

