/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.sql.Date;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;
import org.kuali.kfs.sys.context.SpringContext;

public class MilestoneScheduleRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    MilestoneSchedule newMilestoneScheduleCopy;
    private static volatile AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    private static volatile MilestoneScheduleMaintenanceService milestoneScheduleMaintenanceService;

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        LOG.debug("Entering MilestoneScheduleRule.processCustomAddCollectionLineBusinessRules");
        boolean isValid = this.checkForDuplicateMilestoneNumber(collectionName, line);
        LOG.debug("Leaving MilestoneScheduleRule.processCustomAddCollectionLineBusinessRules");
        return isValid &= this.checkMilestoneActualCompletionDate(collectionName, line);
    }

    private boolean checkForDuplicateMilestoneNumber(String collectionName, PersistableBusinessObject line) {
        boolean isValid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)collectionName, (CharSequence)"Milestones")) {
            Milestone milestone = (Milestone)line;
            String newMilestoneNumber = milestone.getMilestoneNumber();
            for (Milestone existingMilestone : this.newMilestoneScheduleCopy.getMilestones()) {
                if (!existingMilestone.getMilestoneNumber().equals(newMilestoneNumber)) continue;
                isValid = false;
                this.putFieldError(collectionName, "error.duplicate.milestone.number");
                break;
            }
        }
        return isValid;
    }

    private boolean checkMilestoneActualCompletionDate(String collectionName, PersistableBusinessObject line) {
        Milestone milestone;
        Date milestoneActualCompletionDate;
        if (StringUtils.equalsIgnoreCase((CharSequence)collectionName, (CharSequence)"Milestones") && ObjectUtils.isNotNull((Object)(milestoneActualCompletionDate = (milestone = (Milestone)line).getMilestoneActualCompletionDate())) && milestoneActualCompletionDate.after(Date.valueOf(LocalDate.now()))) {
            this.putFieldError(collectionName, "error.milestone.actual.completion.date.in.future");
            return false;
        }
        return true;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering MilestoneScheduleRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(document);
        LOG.debug("Leaving MilestoneScheduleRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering MilestoneScheduleRule.processCustomRouteDocumentBusinessRules");
        boolean success = this.checkAward();
        success &= this.checkMilestoneScheduleAccount();
        success &= this.checkAwardBillingFrequency();
        success &= this.checkForDuplicateMilestoneNumbers();
        success &= this.checkMilestoneTotalAgainstAwardTotal();
        success &= this.checkMilestoneActualCompletionDates();
        LOG.debug("Leaving MilestoneScheduleRule.processCustomRouteDocumentBusinessRules");
        return success &= this.performDataDictionaryValidationForMilestones();
    }

    private boolean checkAward() {
        if (ObjectUtils.isNull((Object)this.newMilestoneScheduleCopy.getAward()) || StringUtils.isBlank((CharSequence)this.newMilestoneScheduleCopy.getAward().getProposalNumber())) {
            this.putFieldError("proposalNumberForAwardAccountLookup", "error.award.does.not.exist", this.newMilestoneScheduleCopy.getProposalNumber());
            return false;
        }
        return true;
    }

    private boolean checkMilestoneScheduleAccount() {
        if (ObjectUtils.isNull((Object)this.newMilestoneScheduleCopy.getAward())) {
            return true;
        }
        List activeAwardAccounts = this.newMilestoneScheduleCopy.getAward().getActiveAwardAccounts();
        for (ContractsAndGrantsBillingAwardAccount account : activeAwardAccounts) {
            if (!StringUtils.equals((CharSequence)account.getChartOfAccountsCode(), (CharSequence)this.newMilestoneScheduleCopy.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)account.getAccountNumber(), (CharSequence)this.newMilestoneScheduleCopy.getAccountNumber())) continue;
            return true;
        }
        this.putFieldError("accountNumber", "error.milestone.schedule.account.does.not.exist.on.award");
        return false;
    }

    private boolean checkAwardBillingFrequency() {
        boolean success = false;
        if (ObjectUtils.isNull((Object)this.newMilestoneScheduleCopy.getAward()) || StringUtils.isBlank((CharSequence)this.newMilestoneScheduleCopy.getProposalNumber())) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)this.newMilestoneScheduleCopy.getAward().getBillingFrequencyCode()) && ArConstants.BillingFrequencyValues.isMilestone((Billable)this.newMilestoneScheduleCopy.getAward())) {
            success = true;
        }
        if (!success) {
            this.putFieldError("proposalNumberForAwardAccountLookup", "error.cg.award.milestone.schedule.incorrect.billing.frequency", new String[]{this.newMilestoneScheduleCopy.getProposalNumber()});
        }
        return success;
    }

    private boolean checkForDuplicateMilestoneNumbers() {
        boolean isValid = true;
        HashSet<String> milestoneNumbers = new HashSet<String>();
        HashSet<String> duplicateMilestoneNumbers = new HashSet<String>();
        for (Milestone milestone : this.newMilestoneScheduleCopy.getMilestones()) {
            if (milestoneNumbers.add(milestone.getMilestoneNumber())) continue;
            duplicateMilestoneNumbers.add(milestone.getMilestoneNumber());
        }
        if (duplicateMilestoneNumbers.size() > 0) {
            isValid = false;
            int lineNum = 0;
            for (Milestone milestone : this.newMilestoneScheduleCopy.getMilestones()) {
                boolean copiedToInvoice = false;
                if (ObjectUtils.isNotNull((Object)milestone.getMilestoneIdentifier()) && this.getMilestoneScheduleMaintenanceService().hasMilestoneBeenCopiedToInvoice(milestone.getProposalNumber(), milestone.getMilestoneIdentifier().toString())) {
                    copiedToInvoice = true;
                }
                if (!copiedToInvoice && duplicateMilestoneNumbers.contains(milestone.getMilestoneNumber())) {
                    String errorPath = "milestones[" + lineNum + "].milestoneNumber";
                    this.putFieldError(errorPath, "error.duplicate.milestone.number");
                }
                ++lineNum;
            }
        }
        return isValid;
    }

    private boolean checkMilestoneTotalAgainstAwardTotal() {
        KualiDecimal totalAmountFromOtherMilestoneSchedules;
        if (ObjectUtils.isNull((Object)this.newMilestoneScheduleCopy.getAward()) || ObjectUtils.isNull((Object)this.newMilestoneScheduleCopy.getAward().getAwardTotalAmount())) {
            return true;
        }
        KualiDecimal awardTotalAmount = this.newMilestoneScheduleCopy.getAward().getAwardTotalAmount();
        KualiDecimal milestoneTotalAmount = this.newMilestoneScheduleCopy.getMilestones().stream().filter(Milestone::isActive).filter(milestone -> ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount())).reduce(KualiDecimal.ZERO, (sum, milestone) -> (KualiDecimal)milestone.getMilestoneAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
        KualiDecimal totalForAllMilestones = (KualiDecimal)milestoneTotalAmount.add((AbstractKualiDecimal)(totalAmountFromOtherMilestoneSchedules = this.getAccountsReceivableModuleBillingService().getMilestonesTotalAmountForOtherSchedules(this.newMilestoneScheduleCopy.getProposalNumber(), this.newMilestoneScheduleCopy.getChartOfAccountsCode(), this.newMilestoneScheduleCopy.getAccountNumber())));
        if (totalForAllMilestones.isGreaterThan((AbstractKualiDecimal)awardTotalAmount)) {
            this.putFieldError("totalScheduledAccount", "error.milestone.total.exceeds.award.total");
            return false;
        }
        return true;
    }

    private boolean checkMilestoneActualCompletionDates() {
        boolean isValid = true;
        int lineNum = 0;
        for (Milestone milestone : this.newMilestoneScheduleCopy.getMilestones()) {
            Date milestoneActualCompletionDate = milestone.getMilestoneActualCompletionDate();
            if (ObjectUtils.isNotNull((Object)milestoneActualCompletionDate) && milestoneActualCompletionDate.after(Date.valueOf(LocalDate.now()))) {
                String errorPath = "milestones[" + lineNum + "].milestoneActualCompletionDate";
                this.putFieldError(errorPath, "error.milestone.actual.completion.date.in.future");
                isValid = false;
            }
            ++lineNum;
        }
        return isValid;
    }

    private boolean performDataDictionaryValidationForMilestones() {
        boolean valid = true;
        int lineNum = 0;
        for (Milestone milestone : this.newMilestoneScheduleCopy.getMilestones()) {
            GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.milestones[" + lineNum + "]");
            DictionaryValidationResult dictionaryValidationResult = this.getDictionaryValidationService().validate((Object)milestone);
            if (dictionaryValidationResult.getNumberOfErrors() > 0) {
                valid = false;
            }
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.milestones[" + lineNum + "]");
            ++lineNum;
        }
        return valid;
    }

    public void setupConvenienceObjects() {
        this.newMilestoneScheduleCopy = (MilestoneSchedule)((Object)super.getNewBo());
    }

    AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        if (accountsReceivableModuleBillingService == null) {
            accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
        }
        return accountsReceivableModuleBillingService;
    }

    MilestoneScheduleMaintenanceService getMilestoneScheduleMaintenanceService() {
        if (milestoneScheduleMaintenanceService == null) {
            milestoneScheduleMaintenanceService = (MilestoneScheduleMaintenanceService)SpringContext.getBean(MilestoneScheduleMaintenanceService.class);
        }
        return milestoneScheduleMaintenanceService;
    }
}

