/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.service.PredeterminedBillingScheduleMaintenanceService;
import org.kuali.kfs.sys.context.SpringContext;

public class PredeterminedBillingScheduleRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    PredeterminedBillingSchedule newPredeterminedBillingScheduleCopy;
    private static volatile AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    private static volatile PredeterminedBillingScheduleMaintenanceService predeterminedBillingScheduleMaintenanceService;

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        LOG.debug("Entering PredeterminedBillingScheduleRule.processCustomAddCollectionLineBusinessRules");
        boolean isValid = this.checkForDuplicateBillNumber(collectionName, line);
        LOG.debug("Leaving PredeterminedBillingScheduleRule.processCustomAddCollectionLineBusinessRules");
        return isValid;
    }

    private boolean checkForDuplicateBillNumber(String collectionName, PersistableBusinessObject line) {
        boolean isValid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)collectionName, (CharSequence)"Bills")) {
            Bill bill = (Bill)line;
            String newBillNumber = bill.getBillNumber();
            for (Bill existingBill : this.newPredeterminedBillingScheduleCopy.getBills()) {
                if (!existingBill.getBillNumber().equals(newBillNumber)) continue;
                isValid = false;
                this.putFieldError(collectionName, "error.duplicate.bill.number");
                break;
            }
        }
        return isValid;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering PredeterminedBillingScheduleRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(document);
        LOG.debug("Leaving PredeterminedBillingScheduleRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering PredeterminedBillingScheduleRule.processCustomRouteDocumentBusinessRules");
        boolean success = this.checkAward();
        success &= this.checkPredeterminedBillingScheduleAccount();
        success &= this.checkAwardBillingFrequency();
        success &= this.checkForDuplicateBillNumbers();
        success &= this.checkBillTotalAgainstAwardTotal();
        LOG.debug("Leaving PredeterminedBillingScheduleRule.processCustomRouteDocumentBusinessRules");
        return success &= this.performDataDictionaryValidationForBills();
    }

    private boolean checkAward() {
        if (ObjectUtils.isNull((Object)this.newPredeterminedBillingScheduleCopy.getAward()) || StringUtils.isBlank((CharSequence)this.newPredeterminedBillingScheduleCopy.getAward().getProposalNumber())) {
            this.putFieldError("proposalNumberForAwardAccountLookup", "error.award.does.not.exist", this.newPredeterminedBillingScheduleCopy.getProposalNumber());
            return false;
        }
        return true;
    }

    private boolean checkPredeterminedBillingScheduleAccount() {
        if (ObjectUtils.isNull((Object)this.newPredeterminedBillingScheduleCopy.getAward())) {
            return true;
        }
        List activeAwardAccounts = this.newPredeterminedBillingScheduleCopy.getAward().getActiveAwardAccounts();
        for (ContractsAndGrantsBillingAwardAccount account : activeAwardAccounts) {
            if (!StringUtils.equals((CharSequence)account.getChartOfAccountsCode(), (CharSequence)this.newPredeterminedBillingScheduleCopy.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)account.getAccountNumber(), (CharSequence)this.newPredeterminedBillingScheduleCopy.getAccountNumber())) continue;
            return true;
        }
        this.putFieldError("accountNumber", "error.predetermined.billing.schedule.account.does.not.exist.on.award");
        return false;
    }

    private boolean checkAwardBillingFrequency() {
        boolean success = false;
        if (ObjectUtils.isNull((Object)this.newPredeterminedBillingScheduleCopy.getAward()) || StringUtils.isBlank((CharSequence)this.newPredeterminedBillingScheduleCopy.getProposalNumber())) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)this.newPredeterminedBillingScheduleCopy.getAward().getBillingFrequencyCode()) && ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.newPredeterminedBillingScheduleCopy.getAward())) {
            success = true;
        }
        if (!success) {
            this.putFieldError("proposalNumberForAwardAccountLookup", "error.cg.award.predetermined.billing.schedule.incorrect.billing.frequency", new String[]{this.newPredeterminedBillingScheduleCopy.getProposalNumber()});
        }
        return success;
    }

    private boolean checkForDuplicateBillNumbers() {
        boolean isValid = true;
        HashSet<String> billNumbers = new HashSet<String>();
        HashSet<String> duplicateBillNumbers = new HashSet<String>();
        for (Bill bill : this.newPredeterminedBillingScheduleCopy.getBills()) {
            if (billNumbers.add(bill.getBillNumber())) continue;
            duplicateBillNumbers.add(bill.getBillNumber());
        }
        if (duplicateBillNumbers.size() > 0) {
            isValid = false;
            int lineNum = 0;
            for (Bill bill : this.newPredeterminedBillingScheduleCopy.getBills()) {
                boolean copiedToInvoice = false;
                if (ObjectUtils.isNotNull((Object)bill.getBillIdentifier()) && this.getPredeterminedBillingScheduleMaintenanceService().hasBillBeenCopiedToInvoice(bill.getProposalNumber(), bill.getBillIdentifier().toString())) {
                    copiedToInvoice = true;
                }
                if (!copiedToInvoice && duplicateBillNumbers.contains(bill.getBillNumber())) {
                    String errorPath = "bills[" + lineNum + "].billNumber";
                    this.putFieldError(errorPath, "error.duplicate.bill.number");
                }
                ++lineNum;
            }
        }
        return isValid;
    }

    private boolean checkBillTotalAgainstAwardTotal() {
        KualiDecimal totalAmountFromOtherPredeterminedBillingSchedules;
        if (ObjectUtils.isNull((Object)this.newPredeterminedBillingScheduleCopy.getAward()) || ObjectUtils.isNull((Object)this.newPredeterminedBillingScheduleCopy.getAward().getAwardTotalAmount())) {
            return true;
        }
        KualiDecimal awardTotalAmount = this.newPredeterminedBillingScheduleCopy.getAward().getAwardTotalAmount();
        KualiDecimal billTotalAmount = this.newPredeterminedBillingScheduleCopy.getBills().stream().filter(Bill::isActive).filter(bill -> ObjectUtils.isNotNull((Object)bill.getEstimatedAmount())).reduce(KualiDecimal.ZERO, (sum, bill) -> (KualiDecimal)bill.getEstimatedAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
        KualiDecimal totalForAllBills = (KualiDecimal)billTotalAmount.add((AbstractKualiDecimal)(totalAmountFromOtherPredeterminedBillingSchedules = this.getAccountsReceivableModuleBillingService().getBillsTotalAmountForOtherSchedules(this.newPredeterminedBillingScheduleCopy.getProposalNumber(), this.newPredeterminedBillingScheduleCopy.getChartOfAccountsCode(), this.newPredeterminedBillingScheduleCopy.getAccountNumber())));
        if (totalForAllBills.isGreaterThan((AbstractKualiDecimal)awardTotalAmount)) {
            this.putFieldError("totalScheduledAccount", "error.bill.total.exceeds.award.total");
            return false;
        }
        return true;
    }

    private boolean performDataDictionaryValidationForBills() {
        boolean valid = true;
        int lineNum = 0;
        for (Bill bill : this.newPredeterminedBillingScheduleCopy.getBills()) {
            GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.bills[" + lineNum + "]");
            DictionaryValidationResult dictionaryValidationResult = this.getDictionaryValidationService().validate((Object)bill);
            if (dictionaryValidationResult.getNumberOfErrors() > 0) {
                valid = false;
            }
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.bills[" + lineNum + "]");
            ++lineNum;
        }
        return valid;
    }

    public void setupConvenienceObjects() {
        this.newPredeterminedBillingScheduleCopy = (PredeterminedBillingSchedule)((Object)super.getNewBo());
    }

    AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        if (accountsReceivableModuleBillingService == null) {
            accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
        }
        return accountsReceivableModuleBillingService;
    }

    PredeterminedBillingScheduleMaintenanceService getPredeterminedBillingScheduleMaintenanceService() {
        if (predeterminedBillingScheduleMaintenanceService == null) {
            predeterminedBillingScheduleMaintenanceService = (PredeterminedBillingScheduleMaintenanceService)SpringContext.getBean(PredeterminedBillingScheduleMaintenanceService.class);
        }
        return predeterminedBillingScheduleMaintenanceService;
    }
}

