/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class ContractsGrantsInvoiceDocumentPreRules
extends PromptBeforeValidationBase {
    private DateTimeService dateTimeService;
    private AccountingPeriodService accountingPeriodService;
    private ConfigurationService configurationService;

    public boolean doPrompts(Document document) {
        return this.checkFinalBillIndicator(document);
    }

    private boolean checkFinalBillIndicator(Document document) {
        ContractsGrantsInvoiceDocument cinv;
        InvoiceGeneralDetail invoiceGeneralDetail;
        if (document instanceof ContractsGrantsInvoiceDocument && (invoiceGeneralDetail = (cinv = (ContractsGrantsInvoiceDocument)document).getInvoiceGeneralDetail()).isFinalBillIndicator()) {
            Date today = this.getDateTimeService().getCurrentSqlDate();
            AccountingPeriod currPeriod = this.getAccountingPeriodService().getByDate(today);
            Date acctingPeriodEndDate = currPeriod.getUniversityFiscalPeriodEndDate();
            ContractsAndGrantsBillingAward award = invoiceGeneralDetail.getAward();
            Date projectEndDate = award.getAwardEndingDate();
            boolean confirmUpdate = true;
            if (acctingPeriodEndDate.before(projectEndDate)) {
                String questionText = this.getConfigurationService().getPropertyValueAsString("prompt.document.cinv.final.bill.indicator");
                confirmUpdate = this.askOrAnalyzeYesNoQuestion("FinalBillIndicatorUpdateQuestion", questionText);
            }
            if (!confirmUpdate) {
                this.abortRulesCheck();
                return false;
            }
        }
        return true;
    }

    private DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    private AccountingPeriodService getAccountingPeriodService() {
        if (this.accountingPeriodService == null) {
            this.accountingPeriodService = (AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class);
        }
        return this.accountingPeriodService;
    }

    private ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return this.configurationService;
    }
}

