/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.text.MessageFormat;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsLetterOfCreditReviewDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;

public class ContractsGrantsLetterOfCreditReviewDocumentPreRules
extends PromptBeforeValidationBase {
    private ConfigurationService configurationService;
    private PersonService personService;
    private NoteService noteService;

    public boolean doPrompts(Document document) {
        return this.conditionallyAskQuestion(document);
    }

    private boolean conditionallyAskQuestion(Document document) {
        ContractsGrantsLetterOfCreditReviewDocument letterOfCreditReviewDocument = (ContractsGrantsLetterOfCreditReviewDocument)document;
        for (ContractsGrantsLetterOfCreditReviewDetail detail : letterOfCreditReviewDocument.getAccountReviewDetails()) {
            if (!ContractsGrantsLetterOfCreditReviewDocumentPreRules.amountToDrawExceedsMaximum(detail)) continue;
            String questionText = this.getConfigurationService().getPropertyValueAsString("warning.contractsGrantsLetterOfCreditReviewDocument.amountToDrawExceedsMaximum");
            boolean confirm = this.askOrAnalyzeYesNoQuestion("LetterOfCreditReviewDocumentAmountToDrawQuestionID", questionText);
            if (confirm) {
                this.createAndSaveNote(detail.getProposalNumber(), detail.getAccountNumber(), letterOfCreditReviewDocument);
                continue;
            }
            this.abortRulesCheck();
            return false;
        }
        return true;
    }

    private static boolean amountToDrawExceedsMaximum(ContractsGrantsLetterOfCreditReviewDetail detail) {
        KualiDecimal fundsNotDrawn = (KualiDecimal)detail.getHiddenAmountToDraw().subtract((AbstractKualiDecimal)detail.getAmountToDraw());
        return fundsNotDrawn.isNegative();
    }

    private void createAndSaveNote(String proposalNumber, String accountNumber, ContractsGrantsLetterOfCreditReviewDocument letterOfCreditReviewDocument) {
        Note note = new Note();
        String noteTemplate = this.getConfigurationService().getPropertyValueAsString("contractsGrantsLetterOfCreditReviewDocument.amountToDraw.exceeded.note");
        Person initiator = GlobalVariables.getUserSession().getPerson();
        note.setNoteText(MessageFormat.format(noteTemplate, proposalNumber, accountNumber, initiator.getName()));
        note.setNotePostedTimestampToCurrent();
        note.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
        Person systemUser = this.getPersonService().getPersonByPrincipalName("kfs");
        note = this.getNoteService().createNote(note, letterOfCreditReviewDocument.getNoteTarget(), systemUser.getPrincipalId());
        this.getNoteService().save(note);
    }

    private ConfigurationService getConfigurationService() {
        if (ObjectUtils.isNull((Object)this.configurationService)) {
            this.configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return this.configurationService;
    }

    private NoteService getNoteService() {
        if (ObjectUtils.isNull((Object)this.noteService)) {
            this.noteService = (NoteService)SpringContext.getBean(NoteService.class);
        }
        return this.noteService;
    }

    private PersonService getPersonService() {
        if (ObjectUtils.isNull((Object)this.personService)) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }
}

