/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceDetailDiscountGreaterThanParentValidation
extends GenericValidation {
    private CustomerInvoiceDetail discountCustomerInvoiceDetail;
    private CustomerInvoiceDocument customerInvoiceDocument;
    private CustomerInvoiceDetailService customerInvoiceDetailService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        CustomerInvoiceDetail parentCustomerInvoiceDetail = this.discountCustomerInvoiceDetail.getParentDiscountCustomerInvoiceDetail();
        if (ObjectUtils.isNotNull((Object)parentCustomerInvoiceDetail)) {
            CustomerInvoiceDetail copyOfParentCustomerInvoiceDetail = new CustomerInvoiceDetail();
            copyOfParentCustomerInvoiceDetail.setInvoiceItemQuantity(parentCustomerInvoiceDetail.getInvoiceItemQuantity());
            copyOfParentCustomerInvoiceDetail.setInvoiceItemUnitPrice(parentCustomerInvoiceDetail.getInvoiceItemUnitPrice());
            this.customerInvoiceDetailService.recalculateCustomerInvoiceDetail(this.customerInvoiceDocument, copyOfParentCustomerInvoiceDetail);
            this.customerInvoiceDetailService.recalculateCustomerInvoiceDetail(this.customerInvoiceDocument, this.discountCustomerInvoiceDetail);
            if (((KualiDecimal)this.discountCustomerInvoiceDetail.getAmount().abs()).isGreaterThan(copyOfParentCustomerInvoiceDetail.getAmount().abs())) {
                GlobalVariables.getMessageMap().putError("invoiceItemUnitPrice", "error.document.customerInvoiceDocument.discountAmountGreaterThanParentAmount", new String[0]);
                success = false;
            }
        }
        return success;
    }

    public CustomerInvoiceDetailService getCustomerInvoiceDetailService() {
        return this.customerInvoiceDetailService;
    }

    public void setCustomerInvoiceDetailService(CustomerInvoiceDetailService customerInvoiceDetailService) {
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }

    public CustomerInvoiceDetail getDiscountCustomerInvoiceDetail() {
        return this.discountCustomerInvoiceDetail;
    }

    public void setDiscountCustomerInvoiceDetail(CustomerInvoiceDetail discountCustomerInvoiceDetail) {
        this.discountCustomerInvoiceDetail = discountCustomerInvoiceDetail;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }
}

