/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Timestamp;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceRecurrenceBeginDateValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private DateTimeService dateTimeService;

    public boolean validate(AttributedDocumentEvent event) {
        if (ObjectUtils.isNull((Object)((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails()))) {
            return true;
        }
        if (this.customerInvoiceDocument.getNoRecurrenceDataFlag()) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate())) {
            Timestamp currentDate = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
            Timestamp beginDateTimestamp = new Timestamp(this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate().getTime());
            if (beginDateTimestamp.before(currentDate) || beginDateTimestamp.equals(currentDate)) {
                GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentRecurrenceBeginDate", "error.document.invoiceRecurrenceMaintenance.beginDateMustBeEarlierThanToday", new String[0]);
                return false;
            }
        } else {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentRecurrenceBeginDate", "error.document.invoiceRecurrenceMaintenance.beginDateIsRequired", new String[0]);
            return false;
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

