/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.List;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.SuspensionCategoryBase;

public class InvoiceBillingPeriodSuspensionCategory
extends SuspensionCategoryBase {
    private AccountingPeriodService accountingPeriodService;
    private DateTimeService dateTimeService;
    private VerifyBillingFrequencyService verifyBillingFrequencyService;

    @Override
    public boolean shouldSuspend(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        InvoiceGeneralDetail invoiceGeneralDetail = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail();
        ContractsAndGrantsBillingAward award = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward();
        if (this.isBillingFrequencyQuaterlySemiAnnuallyOrAnnually(invoiceGeneralDetail.getBillingFrequencyCode())) {
            AccountingPeriod currentPeriod = this.accountingPeriodService.getByDate(this.dateTimeService.getCurrentSqlDate());
            AccountingPeriod previousPeriod = this.accountingPeriodService.getPreviousAccountingPeriod(currentPeriod);
            BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currentPeriod);
            return previousPeriod.getUniversityFiscalPeriodEndDate().after(billingPeriod.getEndDate());
        }
        return false;
    }

    protected boolean isBillingFrequencyQuaterlySemiAnnuallyOrAnnually(String billingFrequency) {
        return List.of(ArConstants.BillingFrequencyValues.QUARTERLY.getCode(), ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode(), ArConstants.BillingFrequencyValues.ANNUALLY.getCode()).contains(billingFrequency);
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setVerifyBillingFrequencyService(VerifyBillingFrequencyService verifyBillingFrequencyService) {
        this.verifyBillingFrequencyService = verifyBillingFrequencyService;
    }
}

