/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;

public class PaymentApplicationAdjustmentDocumentRule
extends DocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomRouteDocumentBusinessRules(document);
        PaymentApplicationAdjustmentDocument applicationAdjustmentDocument = (PaymentApplicationAdjustmentDocument)document;
        List<String> invalidInvoicePaths = this.getInvalidInvoicePaths(applicationAdjustmentDocument.getInvoicePaidApplieds());
        boolean invoiceAmountsValid = invalidInvoicePaths.isEmpty();
        if (!invoiceAmountsValid) {
            invalidInvoicePaths.forEach(path -> GlobalVariables.getMessageMap().putError(path, "error.document.paymentApplicationAdjustment.amountToBeAppliedExceedsAmountOutstanding", new String[0]));
            GlobalVariables.getMessageMap().putError("modal.title", "error.modal.paymentApplicationAdjustment.amountToBeAppliedExceedsAmountOutstanding.title", new String[0]);
            GlobalVariables.getMessageMap().putError("modal.message", "error.modal.paymentApplicationAdjustment.amountToBeAppliedExceedsAmountOutstanding.message", new String[0]);
        }
        boolean documentAmountIsValid = this.validateDocumentAmount(applicationAdjustmentDocument);
        return isValid && documentAmountIsValid && invoiceAmountsValid;
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomSaveDocumentBusinessRules(document);
        List<String> invalidInvoicePaths = this.getInvalidInvoicePaths(((PaymentApplicationAdjustmentDocument)document).getInvoicePaidApplieds());
        invalidInvoicePaths.forEach(path -> GlobalVariables.getMessageMap().putWarning(path, "error.document.paymentApplicationAdjustment.amountToBeAppliedExceedsAmountOutstanding", new String[0]));
        return isValid;
    }

    private boolean validateDocumentAmount(PaymentApplicationAdjustmentDocument applicationAdjustmentDocument) {
        boolean balanceIsValid = applicationAdjustmentDocument.getUnallocatedBalance().isZero();
        if (!balanceIsValid) {
            GlobalVariables.getMessageMap().putError("modal.title", "error.modal.paymentApplicationAdjustment.openAmountIsNonZero.title", new String[0]);
            GlobalVariables.getMessageMap().putError("modal.message", "error.modal.paymentApplicationAdjustment.openAmountIsNonZero.message", new String[0]);
        }
        return balanceIsValid;
    }

    private List<String> getInvalidInvoicePaths(List<InvoicePaidApplied> invoicePaidApplieds) {
        return invoicePaidApplieds.stream().map(invoicePaidApplied -> {
            invoicePaidApplied.refreshReferenceObject("invoiceDetail");
            return invoicePaidApplied;
        }).filter(PaymentApplicationAdjustmentDocumentRule::invoiceAmountHasIncreased).filter(Predicate.not(PaymentApplicationAdjustmentDocumentRule::increaseInvoiceIsValid)).map(invoicePaidApplied -> {
            int invoiceDetailIndex = invoicePaidApplied.getInvoiceItemNumber() - 1;
            return String.format("invoiceApplications.%s.detailApplications.%d.amountApplied", invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber(), invoiceDetailIndex);
        }).collect(Collectors.toList());
    }

    private static boolean invoiceAmountHasIncreased(InvoicePaidApplied invoicePaidApplied) {
        return invoicePaidApplied.getInvoiceItemAppliedAmount().isGreaterThan((AbstractKualiDecimal)invoicePaidApplied.getInvoiceDetail().getAmountApplied());
    }

    private static boolean increaseInvoiceIsValid(InvoicePaidApplied invoicePaidApplied) {
        KualiDecimal amountIncreased = (KualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount().subtract((AbstractKualiDecimal)invoicePaidApplied.getInvoiceDetail().getAmountApplied());
        return amountIncreased.isLessEqual((AbstractKualiDecimal)invoicePaidApplied.getInvoiceDetail().getAmountOpen());
    }
}

