/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.validation.impl.PaymentApplicationDocumentRuleUtil;

public class PaymentApplicationDocumentRule
extends DocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomSaveDocumentBusinessRules(document);
        PaymentApplicationDocument paymentApplicationDocument = (PaymentApplicationDocument)document;
        int appliedAmountIndex = 0;
        for (InvoicePaidApplied invoicePaidApplied : paymentApplicationDocument.getInvoicePaidApplieds()) {
            String fieldName = "customerInvoiceDetail[{0}].amountToBeApplied";
            if (!PaymentApplicationDocumentRuleUtil.validateInvoicePaidApplied(invoicePaidApplied, fieldName = StringUtils.replace((String)fieldName, (String)"{0}", (String)Integer.toString(appliedAmountIndex)), paymentApplicationDocument)) {
                isValid = false;
                LOG.info("One of the invoice paid applieds for the payment application document is not valid.");
            }
            ++appliedAmountIndex;
        }
        for (NonInvoiced nonInvoiced : paymentApplicationDocument.getNonInvoiceds()) {
            if (PaymentApplicationDocumentRuleUtil.validateNonInvoiced(nonInvoiced, paymentApplicationDocument, paymentApplicationDocument.getTotalFromControl())) continue;
            isValid = false;
            LOG.info("One of the non-invoiced lines on the payment application document is not valid.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateNonAppliedHolding(paymentApplicationDocument, paymentApplicationDocument.getTotalFromControl())) {
            isValid = false;
            LOG.info("The unapplied line on the payment application document is not valid.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateCumulativeSumOfInvoicePaidAppliedDoesntExceedCashControlTotal(paymentApplicationDocument)) {
            isValid = false;
            LOG.info("The total amount applied exceeds the total amount owed per the cash control document total amount.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateCumulativeSumOfInvoicePaidAppliedsIsGreaterThanOrEqualToZero(paymentApplicationDocument)) {
            isValid = false;
            LOG.info("The total amount applied is less than zero.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateUnappliedAmountDoesntExceedCashControlTotal(paymentApplicationDocument)) {
            isValid = false;
            LOG.info("The total unapplied amount exceeds the total amount owed per the cash control document total amount.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateUnappliedAmountIsGreaterThanOrEqualToZero(paymentApplicationDocument)) {
            isValid = false;
            LOG.info("The total unapplied amount is less than zero.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateNonInvoicedAmountDoesntExceedCashControlTotal(paymentApplicationDocument)) {
            isValid = false;
            LOG.info("The total non-invoiced amount exceeds the total amount owed per the cash control document total amount.");
        }
        if (!PaymentApplicationDocumentRuleUtil.validateNonInvoicedAmountIsGreaterThanOrEqualToZero(paymentApplicationDocument)) {
            isValid = false;
            LOG.info("The total unapplied amount is less than zero.");
        }
        return isValid;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomRouteDocumentBusinessRules(document);
        if (!isValid) {
            return false;
        }
        MessageMap errorMap = GlobalVariables.getMessageMap();
        PaymentApplicationDocument paymentApplicationDocument = (PaymentApplicationDocument)document;
        if (paymentApplicationDocument.hasCashControlDetail() && !KualiDecimal.ZERO.equals((Object)paymentApplicationDocument.getUnallocatedBalance())) {
            isValid = false;
            errorMap.putError("GLOBAL_ERRORS", "error.document.paymentApplication.fullAmountNotApplied", new String[0]);
            LOG.info("The payment application document was not fully applied.");
        }
        return isValid;
    }
}

