/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.ProjectCodeService;
import org.kuali.kfs.coa.service.SubAccountService;
import org.kuali.kfs.coa.service.SubObjectCodeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.actionrequest.ActionRequest;
import org.kuali.kfs.kew.api.action.InvalidActionTakenRuntimeException;
import org.kuali.kfs.kew.api.document.InvalidDocumentContentException;
import org.kuali.kfs.kim.impl.group.Group;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.DocumentAuthorizationException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rest.responses.AdHocRoutePersonResponse;
import org.kuali.kfs.krad.rest.responses.AdHocRouteWorkgroupResponse;
import org.kuali.kfs.krad.rest.responses.NoteResponse;
import org.kuali.kfs.krad.rules.rule.event.AddAdHocRoutePersonEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentService;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentForm;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentNonAppliedHolding;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutingRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.kfs.module.ar.rest.resource.responses.PaymentApplicationAdjustmentInvoiceResponse;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.service.AccountingLineRuleHelperService;
import org.kuali.kfs.sys.document.service.impl.AccountingLineValidationError;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.kfs.sys.rest.resource.responses.ErrorResponse;
import org.kuali.kfs.sys.service.MessageBuilderService;
import org.springframework.http.HttpStatus;
import org.springframework.util.AutoPopulatingList;

public class PaymentApplicationAdjustmentAction
extends FinancialSystemTransactionalDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger();
    private ChartService chartService;
    private AccountService accountService;
    private SubAccountService subAccountService;
    private ObjectCodeService objectCodeService;
    private SubObjectCodeService subObjectCodeService;
    private ProjectCodeService projectCodeService;
    private PaymentApplicationAdjustmentDocumentService paymentApplicationAdjustmentDocumentService;
    private AccountingLineRuleHelperService accountingLineRuleHelperService;
    private MessageBuilderService messageBuilderService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        List headerFields = appaForm.getDocInfo().stream().map(this::convertHeaderField).collect(Collectors.toList());
        this.serializeToJsonSafely(headerFields).ifPresent(json -> appaForm.setHeaderFieldsJson((String)json));
        return forward;
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.loadDocument((KualiDocumentFormBase)form);
        try {
            super.blanketApprove(mapping, form, request, response);
        }
        catch (Exception e) {
            PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
            Map<String, List<String>> errorMessages = this.getErrorMessages();
            String errorJson = e.getMessage();
            if (MapUtils.isNotEmpty(errorMessages)) {
                String msg = String.format("Unable to blanket approve document: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
                LOG.error("blanketApprove(...) - Returning; {}", (Object)msg);
                errorJson = MAPPER.writeValueAsString(errorMessages);
            }
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
        return null;
    }

    public ActionForward fyi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.loadDocument((KualiDocumentFormBase)form);
        try {
            super.fyi(mapping, form, request, response);
        }
        catch (Exception e) {
            PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
            Map<String, List<String>> errorMessages = this.getErrorMessages();
            String errorJson = e.getMessage();
            if (MapUtils.isNotEmpty(errorMessages)) {
                String msg = String.format("Unable to fyi document: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
                LOG.error("fyi(...) - Returning; {}", (Object)msg);
                errorJson = MAPPER.writeValueAsString(errorMessages);
            }
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
        return null;
    }

    public ActionForward acknowledge(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.loadDocument((KualiDocumentFormBase)form);
        try {
            super.acknowledge(mapping, form, request, response);
        }
        catch (Exception e) {
            PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
            Map<String, List<String>> errorMessages = this.getErrorMessages();
            String errorJson = e.getMessage();
            if (MapUtils.isNotEmpty(errorMessages)) {
                String msg = String.format("Unable to acknowledge document: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
                LOG.error("acknowledge(...) - Returning; {}", (Object)msg);
                errorJson = MAPPER.writeValueAsString(errorMessages);
            }
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
        return null;
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.loadDocument((KualiDocumentFormBase)form);
        try {
            super.approve(mapping, form, request, response);
        }
        catch (Exception e) {
            PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
            Map<String, List<String>> errorMessages = this.getErrorMessages();
            String errorJson = e.getMessage();
            if (MapUtils.isNotEmpty(errorMessages)) {
                String msg = String.format("Unable to approve document: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
                LOG.error("approve(...) - Returning; {}", (Object)msg);
                errorJson = MAPPER.writeValueAsString(errorMessages);
            }
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
        return null;
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        this.loadDocument(documentForm);
        try {
            String reason = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/reason", request);
            if (StringUtils.isBlank((CharSequence)reason)) {
                String msg = "Missing 'reason' request parameter";
                LOG.warn("disapprove(...) - Returning; {}", (Object)"Missing 'reason' request parameter");
                this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'reason' request parameter"));
                return null;
            }
            this.doDisapprove(documentForm, request, reason);
        }
        catch (Exception e) {
            PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
            Map<String, List<String>> errorMessages = this.getErrorMessages();
            String errorJson = e.getMessage();
            if (MapUtils.isNotEmpty(errorMessages)) {
                String msg = String.format("Unable to disapprove document: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
                LOG.error("disapprove(...) - Returning; {}", (Object)msg);
                errorJson = MAPPER.writeValueAsString(errorMessages);
            }
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
        return null;
    }

    public ActionForward addCustomer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String customerNumber = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/customerNumber", request);
        if (StringUtils.isBlank((CharSequence)customerNumber)) {
            String msg = "Missing 'customerNumber' request parameter";
            LOG.warn("addCustomer(...) - Returning; {}", (Object)"Missing 'customerNumber' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'customerNumber' request parameter"));
            return null;
        }
        Customer customer = (Customer)this.getBusinessObjectService().findBySinglePrimaryKey(Customer.class, (Object)customerNumber);
        if (customer == null) {
            String msg = String.format("Requested customer not found : customerNumber=%s", customerNumber);
            LOG.warn("addCustomer(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.NOT_FOUND, msg));
            return null;
        }
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        PaymentApplicationAdjustmentNonAppliedHolding nonAppliedHolding = appaForm.addNonAppliedHoldingWithCustomer(customer, KualiDecimal.ZERO);
        this.serializeToJsonSafely(nonAppliedHolding).ifPresentOrElse(json -> this.writeJsonToResponse(response, HttpStatus.OK, (String)json), () -> response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        return null;
    }

    public ActionForward addAdHocRoutePerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String principalName = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/person/principalName", request);
        String action = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/person/action", request);
        if (StringUtils.isBlank((CharSequence)principalName)) {
            String msg = "principalName is required";
            LOG.warn("adAdHocRoutePerson(...) - Returning; {}", (Object)"principalName is required");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "principalName is required"));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)action)) {
            String msg = "action is required";
            LOG.warn("adAdHocRoutePerson(...) - Returning; {}", (Object)"action is required");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "action is required"));
            return null;
        }
        Person person = this.getPersonService().getPersonByPrincipalName(principalName);
        if (ObjectUtils.isNull((Object)person)) {
            String msg = String.format("No person found with principalName=%s", principalName);
            LOG.warn("adAdHocRoutePerson(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.NOT_FOUND, msg));
            return null;
        }
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        Document document = appaForm.getDocument();
        Person user = this.getUserFromRequest(request);
        AdHocRoutePerson adHocRoutePerson = new AdHocRoutePerson();
        adHocRoutePerson.setId(person.getPrincipalName());
        adHocRoutePerson.setActionRequested(action);
        if (!this.getAdHocRoutingService().canSendAdHocRequest(document, (AdHocRouteRecipient)adHocRoutePerson, user)) {
            String msg = String.format("No permission to add principal with principalName=%s", principalName);
            LOG.warn("adAdHocRoutePerson(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.FORBIDDEN, msg));
            return null;
        }
        AdHocRoutePersonResponse personResponse = appaForm.createAdHocRoutePersonResponse(person, action);
        this.serializeToJsonSafely(personResponse).ifPresentOrElse(json -> this.writeJsonToResponse(response, HttpStatus.OK, (String)json), () -> response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        return null;
    }

    public ActionForward addAdHocRouteWorkgroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String groupId = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/group/id", request);
        String action = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/group/action", request);
        if (StringUtils.isBlank((CharSequence)groupId)) {
            String msg = String.format("Group id is required", new Object[0]);
            LOG.warn("addAdHocRouteWorkgroup(...) - Returning {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, msg));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)action)) {
            String msg = String.format("Action is required", new Object[0]);
            LOG.warn("addAdHocRouteWorkgroup(...) - Returning {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, msg));
            return null;
        }
        Group group = (Group)this.getBusinessObjectService().findBySinglePrimaryKey(Group.class, (Object)groupId);
        if (ObjectUtils.isNull((Object)group)) {
            String msg = String.format("No group found with id=%s", groupId);
            LOG.warn("addAdHocRouteWorkgroup(...) - Returning {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.NOT_FOUND, msg));
            return null;
        }
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        Document document = appaForm.getDocument();
        Person user = this.getUserFromRequest(request);
        AdHocRouteWorkgroup workgroup = new AdHocRouteWorkgroup();
        workgroup.setRecipientName(group.getName());
        workgroup.setRecipientNamespaceCode(group.getNamespaceCode());
        if (!this.getAdHocRoutingService().canSendAdHocRequest(document, (AdHocRouteRecipient)workgroup, user)) {
            String msg = String.format("No permission to add workgroup with id=%s", groupId);
            LOG.warn("addAdHocRouteWorkgroup(...) - Returning {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.FORBIDDEN, msg));
            return null;
        }
        AdHocRouteWorkgroupResponse workgroupResponse = appaForm.createAdHocRouteWorkgroupResponse(group, action);
        this.serializeToJsonSafely(workgroupResponse).ifPresentOrElse(json -> this.writeJsonToResponse(response, HttpStatus.OK, (String)json), () -> response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        return null;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentRequest appaRequest = this.getDataFromRequest(request, response);
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        PaymentApplicationAdjustmentDocument appaDoc = appaForm.getApplicationAdjustmentDocument();
        List<PaymentApplicationAdjustmentRequest.AccountingLine> nonArAccountingLines = appaRequest.getNonArAccountingLines();
        List<AccountingLineValidationError> validationErrors = this.getNonArAccountingLinesValidationErrors(nonArAccountingLines, appaDoc.getDocumentNumber());
        if (!validationErrors.isEmpty()) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            validationErrors.forEach(error -> messageMap.putError(error.getPropertyName(), error.getErrorKey(), new String[0]));
            messageMap.putError("modal.title", "error.modal.paymentApplicationAdjustment.nonArAccountingLineValidationError.title", new String[0]);
            messageMap.putError("modal.message", "error.modal.paymentApplicationAdjustment.nonArAccountingLineValidationError.message", new String[0]);
            this.putErrorMessagesInResponse(response, appaForm, "route");
            return null;
        }
        this.loadDocument((KualiDocumentFormBase)appaForm);
        this.updateDocumentWithRequestData(appaForm, appaRequest);
        this.updateAdHocRouting(request, (KualiDocumentFormBase)appaForm, appaRequest.getAdHocRoutingRequest());
        try {
            super.route(mapping, form, request, response);
        }
        catch (Exception e) {
            this.putErrorMessagesInResponse(response, appaForm, "route");
        }
        this.getPaymentApplicationAdjustmentDocumentService().removeZeroAmountInvoicePaidAppliedsFromDocument(appaForm.getPaymentApplicationAdjustmentDocument());
        this.getPaymentApplicationAdjustmentDocumentService().removeZeroAmountNonAppliedHoldingsFromDocument(appaForm.getPaymentApplicationAdjustmentDocument());
        return null;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentRequest appaRequest = this.getDataFromRequest(request, response);
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        PaymentApplicationAdjustmentDocument appaDoc = appaForm.getApplicationAdjustmentDocument();
        List<PaymentApplicationAdjustmentRequest.AccountingLine> nonArAccountingLines = appaRequest.getNonArAccountingLines();
        List<AccountingLineValidationError> validationErrors = this.getNonArAccountingLinesValidationErrors(nonArAccountingLines, appaDoc.getDocumentNumber());
        if (!validationErrors.isEmpty()) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            validationErrors.forEach(error -> messageMap.putError(error.getPropertyName(), error.getErrorKey(), error.getMessageParameters()));
            this.putErrorMessagesInResponse(response, appaForm, "save");
            return null;
        }
        this.loadDocument((KualiDocumentFormBase)appaForm);
        this.updateDocumentWithRequestData(appaForm, appaRequest);
        this.updateAdHocRouting(request, (KualiDocumentFormBase)appaForm, appaRequest.getAdHocRoutingRequest());
        try {
            super.save(mapping, form, request, response);
            Map<String, List<String>> warningMessages = this.getWarningMessages();
            if (!warningMessages.isEmpty()) {
                String warningJson = MAPPER.writeValueAsString(warningMessages);
                this.writeJsonToResponse(response, HttpStatus.OK, warningJson);
            }
        }
        catch (Exception e) {
            this.putErrorMessagesInResponse(response, appaForm, "save");
        }
        return null;
    }

    private List<AccountingLineValidationError> getNonArAccountingLinesValidationErrors(List<PaymentApplicationAdjustmentRequest.AccountingLine> nonArAccountingLines, String appaDocumentNumber) {
        AccountingLineRuleHelperService accountingLineRuleHelperService = this.getAccountingLineRuleHelperService();
        return IntStream.range(0, nonArAccountingLines.size()).mapToObj(i -> {
            PaymentApplicationAdjustmentRequest.AccountingLine accountingLine = (PaymentApplicationAdjustmentRequest.AccountingLine)nonArAccountingLines.get(i);
            SourceAccountingLine sourceAccountingLine = this.getPaymentApplicationAdjustmentDocumentService().createSourceAccountingLine(accountingLine, appaDocumentNumber, accountingLine.getSequenceNumber());
            String accountingLinePath = String.format("accountingLines.%d", i);
            List errors = accountingLineRuleHelperService.getAccountingLineValidationErrors((AccountingLine)sourceAccountingLine, true);
            errors.forEach(error -> error.setPropertyName(accountingLinePath + "." + error.getPropertyName()));
            return errors;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void putErrorMessagesInResponse(HttpServletResponse response, PaymentApplicationAdjustmentForm appaForm, String operationName) throws JsonProcessingException {
        Map<String, List<String>> errorMessages = this.getErrorMessages();
        if (MapUtils.isEmpty(errorMessages)) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        } else {
            String msg = String.format("Unable to %s document: documentNumber=%s", operationName, appaForm.getDocument().getDocumentNumber());
            LOG.error("putErrorMessagesInResponse(...) - Exit; {}", (Object)msg);
            String errorJson = MAPPER.writeValueAsString(errorMessages);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
    }

    public ActionForward insertBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        super.insertBONote(mapping, form, request, response);
        List notes = appaForm.getDocument().getNotes();
        Note newNote = (Note)notes.get(notes.size() - 1);
        NoteResponse noteResponse = appaForm.createNoteResponse(newNote);
        this.serializeToJsonSafely(noteResponse).ifPresentOrElse(json -> this.writeJsonToResponse(response, HttpStatus.OK, (String)json), () -> response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        return null;
    }

    public ActionForward deleteBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        PaymentApplicationAdjustmentDocument document = appaForm.getPaymentApplicationAdjustmentDocument();
        String noteId = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/noteId", request);
        if (StringUtils.isBlank((CharSequence)noteId)) {
            String msg = "Missing 'noteId' request parameter";
            LOG.warn("deleteBONote(...) - Returning; {}", (Object)"Missing 'noteId' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'noteId' request parameter"));
            return null;
        }
        Note note = document.getNoteById(noteId);
        try {
            this.deleteNoteFromDocument((Document)document, note);
        }
        catch (IllegalArgumentException | DocumentAuthorizationException e) {
            String msg = String.format("Unable to delete note: documentNumber=%s, noteId=%s", appaForm.getDocument().getDocumentNumber(), noteId);
            LOG.error("deleteBONote(...) - Returning; {}", (Object)msg);
            String errorJson = MAPPER.writeValueAsString((Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
            return null;
        }
        return null;
    }

    public ActionForward sendNoteWorkflowNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        String noteId = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/noteId", request);
        if (StringUtils.isBlank((CharSequence)noteId)) {
            String msg = "Missing 'noteId' request parameter";
            LOG.warn("sendNoteWorkflowNotification(...) - Returning; {}", (Object)"Missing 'noteId' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'noteId' request parameter"));
            return null;
        }
        String principalName = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/principalName", request);
        if (StringUtils.isBlank((CharSequence)principalName)) {
            String msg = "Missing 'principalName' request parameter";
            LOG.warn("sendNoteWorkflowNotification(...) - Returning; {}", (Object)"Missing 'principalName' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'principalName' request parameter"));
            return null;
        }
        this.loadDocument((KualiDocumentFormBase)appaForm);
        PaymentApplicationAdjustmentDocument document = appaForm.getPaymentApplicationAdjustmentDocument();
        Note note = document.getNoteById(noteId);
        note.getAdHocRouteRecipient().setId(principalName);
        try {
            this.sendNoteNotification(note, (Document)document, request, (KualiDocumentFormBase)appaForm);
        }
        catch (ValidationException e) {
            String msg = String.format("Unable to send note notification: documentNumber=%s, noteId=%s, principalName=%s, message=%s", appaForm.getDocument().getDocumentNumber(), noteId, principalName, e.getMessage());
            LOG.error("sendNoteWorkflowNotification(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, msg));
            return null;
        }
        return null;
    }

    public ActionForward sendAdHocRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        try {
            PaymentApplicationAdjustmentRequest appaRequest = this.getDataFromRequest(request, response);
            AdHocRoutingRequest adHocRoutingRequest = appaRequest.getAdHocRoutingRequest();
            if (adHocRoutingRequest.getPersons().isEmpty() && adHocRoutingRequest.getGroups().isEmpty()) {
                throw new ValidationException("No ad hoc recipients specified");
            }
            this.updateAdHocRouting(request, (KualiDocumentFormBase)appaForm, appaRequest.getAdHocRoutingRequest());
            super.sendAdHocRequests(mapping, form, request, response);
        }
        catch (Exception e) {
            Map<String, List<String>> errorMessages = this.getErrorMessages();
            String errorJson = e.getMessage();
            if (MapUtils.isNotEmpty(errorMessages)) {
                String msg = String.format("Unable to send ad hoc requests: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
                LOG.error("sendAdHocRequests(...) - Returning; {}", (Object)msg);
                errorJson = MAPPER.writeValueAsString(errorMessages);
            }
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        }
        return null;
    }

    private void sendNoteNotification(Note note, Document document, HttpServletRequest request, KualiDocumentFormBase form) throws ValidationException {
        if (StringUtils.isBlank((CharSequence)note.getAdHocRouteRecipient().getId())) {
            throw new ValidationException("No recipient specified");
        }
        note.getAdHocRouteRecipient().setActionRequested(this.determineNoteWorkflowNotificationAction(request, form, note));
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddAdHocRoutePersonEvent("newDocumentNote", document, (AdHocRoutePerson)note.getAdHocRouteRecipient()));
        if (!rulePassed) {
            throw new ValidationException("Invalid recipient");
        }
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            throw new ValidationException("Document is not saved");
        }
        this.getDocumentService().sendNoteRouteNotification(document, note, this.getUserFromRequest(request));
    }

    public ActionForward addInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String invoiceNumber = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/invoiceNumber", request);
        if (StringUtils.isBlank((CharSequence)invoiceNumber)) {
            String msg = "Missing 'invoiceNumber' request parameter";
            LOG.warn("addInvoice(...) - Returning; {}", (Object)"Missing 'invoiceNumber' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'invoiceNumber' request parameter"));
            return null;
        }
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)this.getBusinessObjectService().findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)invoiceNumber);
        if (invoice == null) {
            String msg = String.format("Requested invoice not found : invoiceNumber=%s", invoiceNumber);
            LOG.warn("addInvoice(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.NOT_FOUND, msg));
            return null;
        }
        KualiDecimal openAmount = invoice.getOpenAmount();
        if (openAmount == null || !openAmount.isPositive()) {
            String msg = String.format("Invoice does not have an open amount : invoiceNumber=%s", invoiceNumber);
            LOG.warn("addInvoice(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.PRECONDITION_FAILED, msg));
            return null;
        }
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        appaForm.getInvoices().add(invoice);
        PaymentApplicationAdjustmentInvoiceResponse invoiceResponse = appaForm.createInvoiceResponse(invoice);
        this.serializeToJsonSafely(invoiceResponse).ifPresentOrElse(json -> this.writeJsonToResponse(response, HttpStatus.OK, (String)json), () -> response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        return null;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        this.markAdjusteeAsNoLongerBeingAdjusted((KualiDocumentFormBase)appaForm);
        this.doProcessingAfterPost((KualiForm)appaForm, request);
        this.getDocumentService().cancelDocument(appaForm.getDocument(), appaForm.getAnnotation());
        return null;
    }

    public ActionForward processSuperUserActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        if (!appaForm.isStateAllowsApproveSingleActionRequest()) {
            String msg = "User is not permitted to take requested actions";
            LOG.warn("takeSuperUserActions(...) - Returning; {}", (Object)"User is not permitted to take requested actions");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.FORBIDDEN, "User is not permitted to take requested actions"));
            return null;
        }
        String annotation = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/annotation", request);
        if (StringUtils.isBlank((CharSequence)annotation)) {
            String msg = "Missing 'annotation' request parameter";
            LOG.warn("takeSuperUserActions(...) - Returning; {}", (Object)"Missing 'annotation' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'annotation' request parameter"));
            return null;
        }
        JsonNode rootNode = PaymentApplicationAdjustmentAction.getRootNode(request.getParameter("data"));
        JsonNode actionIds = rootNode.get("actionIds");
        if (actionIds == null || !actionIds.isArray()) {
            String msg = "Invalid 'actionIds'. Expected list";
            LOG.warn("takeSuperUserActions(...) - Returning; {}", (Object)"Invalid 'actionIds'. Expected list");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Invalid 'actionIds'. Expected list"));
            return null;
        }
        List actionRequests = this.getWorkflowDocumentService().getPendingActionRequests(appaForm.getDocId());
        Map mappedActionRequests = actionRequests.stream().collect(Collectors.toMap(ActionRequest::getActionRequestId, Function.identity()));
        actionIds.forEach(actionIdJson -> {
            String actionId = actionIdJson.asText();
            ActionRequest actionRequest = (ActionRequest)mappedActionRequests.get(actionId);
            if (actionRequest == null) {
                return;
            }
            Document document = appaForm.getDocument();
            if (actionRequest.isCompleteRequest() || actionRequest.isApproveRequest()) {
                try {
                    this.getDocumentService().validateAndPersistDocument(document, (KualiDocumentEvent)new RouteDocumentEvent(document));
                }
                catch (ValidationException validationException) {
                    return;
                }
            }
            Person user = this.getUserFromRequest(request);
            try {
                this.getSuperUserService().takeRequestedAction(actionRequest, appaForm.getDocId(), user, annotation);
            }
            catch (IllegalArgumentException | InvalidActionTakenRuntimeException | InvalidDocumentContentException e) {
                String msg = String.format("Unable to takeSuperUserActions: documentNumber=%s, principalName=%s, actions=%s, message=%s", document.getDocumentNumber(), user.getPrincipalName(), actionIds.toString(), e.getMessage());
                LOG.error("takeSuperUserActions(...) - Returning; {}", (Object)msg);
                this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, msg));
            }
        });
        Map<String, List<String>> errorMessages = this.getErrorMessages();
        if (MapUtils.isNotEmpty(errorMessages)) {
            String msg = String.format("Error when taking super user actions document: documentNumber=%s", appaForm.getDocument().getDocumentNumber());
            LOG.error("takeSuperUserActions(...) - Returning; {}", (Object)msg);
            String errorJson = MAPPER.writeValueAsString(errorMessages);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, errorJson));
        } else {
            this.writeJsonToResponse(response, HttpStatus.OK, "");
        }
        return null;
    }

    public ActionForward superUserAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String annotation = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/annotation", request);
        if (StringUtils.isBlank((CharSequence)annotation)) {
            String msg = "Missing 'annotation' request parameter";
            LOG.warn("superUserApprove(...) - Returning; {}", (Object)"Missing 'annotation' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'annotation' request parameter"));
            return null;
        }
        String action = PaymentApplicationAdjustmentAction.extractValueFromDataJson("/action", request);
        if (StringUtils.isBlank((CharSequence)action)) {
            String msg = "Missing 'action' request parameter";
            LOG.warn("superUserAction(...) - Returning; {}", (Object)"Missing 'action' request parameter");
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, "Missing 'action' request parameter"));
            return null;
        }
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        this.loadDocument(documentForm);
        Person user = this.getUserFromRequest(request);
        String docTypeId = documentForm.getWorkflowDocument().getDocumentTypeId();
        String docId = documentForm.getDocId();
        try {
            if (StringUtils.equals((CharSequence)action, (CharSequence)"approve")) {
                this.getSuperUserService().blanketApprove(docId, user, annotation);
            } else if (StringUtils.equals((CharSequence)action, (CharSequence)"disapprove")) {
                this.markAdjusteeAsNoLongerBeingAdjusted(documentForm);
                this.getSuperUserService().disapprove(docId, user, annotation);
            }
            this.writeJsonToResponse(response, HttpStatus.OK, "");
        }
        catch (IllegalArgumentException | InvalidActionTakenRuntimeException | InvalidDocumentContentException e) {
            String msg = String.format("Unable to super user action: documentNumber=%s, principalName=%s, action=%s, message=%s", documentForm.getDocument().getDocumentNumber(), user.getPrincipalName(), action, e.getMessage());
            LOG.error("superUserAction(...) - Returning; {}", (Object)msg);
            this.writeErrorToResponse(response, new ErrorResponse(HttpStatus.BAD_REQUEST, msg));
        }
        return null;
    }

    void markAdjusteeAsNoLongerBeingAdjusted(KualiDocumentFormBase form) {
        PaymentApplicationAdjustmentDocument adjustmentDocument = (PaymentApplicationAdjustmentDocument)form.getDocument();
        String adjusteeDocumentNumber = adjustmentDocument.getAdjusteeDocumentNumber();
        Document adjusteeDocument = this.getDocumentService().getByDocumentHeaderId(adjusteeDocumentNumber);
        if (adjusteeDocument instanceof PaymentApplicationDocument) {
            ((PaymentApplicationDocument)adjusteeDocument).clearAdjusterDocumentNumber();
        } else if (adjusteeDocument instanceof PaymentApplicationAdjustmentDocument) {
            ((PaymentApplicationAdjustmentDocument)adjusteeDocument).clearAdjustmentDocumentNumber();
        }
        this.getDocumentService().updateDocument(adjusteeDocument);
    }

    private Map<String, Object> convertHeaderField(HeaderField headerField) {
        HashMap<String, Object> field = new HashMap<String, Object>();
        field.put("value", headerField.getDisplayValue());
        String[] ddNameParts = headerField.getDdAttributeEntryName().split("\\.");
        if (ddNameParts.length == 4) {
            String entityName = ddNameParts[1];
            String attributeName = ddNameParts[3];
            field.put("label", this.getDataDictionaryService().getAttributeShortLabel(entityName, attributeName));
        }
        if (StringUtils.isNotEmpty((CharSequence)headerField.getNonLookupValue()) && headerField.isLookupAware()) {
            field.put("url", headerField.getNonLookupValue());
        }
        return field;
    }

    private Map<String, List<String>> getErrorMessages() {
        return this.extractMessagesFromMap(GlobalVariables.getMessageMap().getErrorMessages());
    }

    private Map<String, List<String>> getWarningMessages() {
        return this.extractMessagesFromMap(GlobalVariables.getMessageMap().getWarningMessages());
    }

    private Map<String, List<String>> extractMessagesFromMap(Map<String, AutoPopulatingList<ErrorMessage>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.convertErrorMessagesToString((List)entry.getValue())));
    }

    private List<String> convertErrorMessagesToString(List<ErrorMessage> errorMessages) {
        MessageBuilderService messageBuilderService = this.getMessageBuilderService();
        return errorMessages.stream().map(ErrorMessage::getErrorKey).map(errorKey -> messageBuilderService.buildMessage(errorKey, null, 0)).map(Message::getMessage).collect(Collectors.toList());
    }

    private PaymentApplicationAdjustmentRequest getDataFromRequest(HttpServletRequest request, HttpServletResponse response) {
        String dataJson = request.getParameter("data");
        PaymentApplicationAdjustmentRequest appaRequest = null;
        try {
            appaRequest = (PaymentApplicationAdjustmentRequest)MAPPER.readValue(dataJson, PaymentApplicationAdjustmentRequest.class);
        }
        catch (JsonProcessingException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((JsonProcessingException)e).getMessage();
            LOG.error("Unable to deserialize APPA Request. Error: {}", supplierArray);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        return appaRequest;
    }

    private void updateDocumentWithRequestData(PaymentApplicationAdjustmentForm form, PaymentApplicationAdjustmentRequest request) {
        PaymentApplicationAdjustmentDocument appaDoc = form.getApplicationAdjustmentDocument();
        DocumentHeader documentHeader = appaDoc.getDocumentHeader();
        documentHeader.setDocumentDescription(request.getDescription());
        documentHeader.setExplanation(request.getExplanation());
        documentHeader.setOrganizationDocumentNumber(request.getOrgDocNumber());
        this.getPaymentApplicationAdjustmentDocumentService().updateInvoicePaidApplieds(appaDoc, request.getInvoiceApplications());
        this.getPaymentApplicationAdjustmentDocumentService().updateNonAppliedHoldings(appaDoc, request.getNonAppliedHoldings());
        this.getPaymentApplicationAdjustmentDocumentService().updateNonArAccountingLines(appaDoc, request.getNonArAccountingLines());
    }

    public void updateAdHocRouting(HttpServletRequest request, KualiDocumentFormBase form, AdHocRoutingRequest adHocRoutingRequest) {
        Document doc = form.getDocument();
        List workgroups = adHocRoutingRequest.getGroups().stream().map(groupRequest -> {
            AdHocRouteWorkgroup workgroup = new AdHocRouteWorkgroup();
            workgroup.setRecipientName(groupRequest.getName());
            workgroup.setRecipientNamespaceCode(groupRequest.getNamespaceCode());
            workgroup.setActionRequested(groupRequest.getAction());
            Group group = this.getAdHocRoutingService().getGroup(workgroup.getRecipientName(), workgroup.getRecipientNamespaceCode());
            if (group != null) {
                workgroup.setId(group.getId());
            }
            return workgroup;
        }).collect(Collectors.toList());
        List persons = adHocRoutingRequest.getPersons().stream().map(personRequest -> {
            AdHocRoutePerson recipient = new AdHocRoutePerson();
            recipient.setId(personRequest.getPrincipalName());
            recipient.setActionRequested(personRequest.getAction());
            return recipient;
        }).collect(Collectors.toList());
        Person user = this.getUserFromRequest(request);
        this.getAdHocRoutingService().updateAdHocWorkgroups(doc, workgroups, user);
        this.getAdHocRoutingService().updateAdHocPersons(doc, persons, user);
    }

    private static String extractValueFromDataJson(String jsonPath, HttpServletRequest request) {
        String dataJson = request.getParameter("data");
        JsonNode rootNode = PaymentApplicationAdjustmentAction.getRootNode(dataJson);
        JsonNode desiredNode = rootNode.at(jsonPath);
        String value = Objects.requireNonNullElseGet(desiredNode, MissingNode::getInstance).asText();
        LOG.debug("extractValueFromDataJson(...) - Returning : value={}; jsonPath={}; dataJson={}", (Object)value, (Object)jsonPath, (Object)dataJson);
        return value;
    }

    private static JsonNode getRootNode(String dataJson) {
        JsonNode rootNode = null;
        try {
            rootNode = MAPPER.readTree(dataJson);
        }
        catch (JsonProcessingException e) {
            LOG.error("getRootNode(...) - Unable to create JsonNode : dataJson={}", (Object)dataJson, (Object)e);
        }
        return Objects.requireNonNullElseGet(rootNode, MissingNode::getInstance);
    }

    PaymentApplicationAdjustmentDocumentService getPaymentApplicationAdjustmentDocumentService() {
        if (this.paymentApplicationAdjustmentDocumentService == null) {
            this.paymentApplicationAdjustmentDocumentService = (PaymentApplicationAdjustmentDocumentService)SpringContext.getBean(PaymentApplicationAdjustmentDocumentService.class);
        }
        return this.paymentApplicationAdjustmentDocumentService;
    }

    private Person getUserFromRequest(HttpServletRequest request) {
        UserSession userSession = (UserSession)request.getSession().getAttribute("userSession");
        return userSession.getPerson();
    }

    public ActionForward adjust(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        PaymentApplicationAdjustmentDocument adjusteeDocument = (PaymentApplicationAdjustmentDocument)appaForm.getDocument();
        PaymentApplicationAdjustmentDocument adjustmentDocument = this.getPaymentApplicationAdjustmentDocumentService().createPaymentApplicationAdjustment(adjusteeDocument);
        appaForm.setDocument((Document)adjustmentDocument);
        String locationHeader = this.createLocationHeader(adjustmentDocument.getDocumentNumber());
        response.setHeader("Location", locationHeader);
        return null;
    }

    private String createLocationHeader(String docNum) {
        Map parameters = Map.ofEntries(Map.entry("methodToCall", "docHandler"), Map.entry("command", "displayDocSearchView"), Map.entry("docId", docNum));
        String baseUrl = PaymentApplicationAdjustmentAction.getApplicationBaseUrl() + "/arPaymentApplicationAdjustment.do";
        String url = UrlFactory.parameterizeUrl((String)baseUrl, parameters);
        LOG.debug("createLocationHeader(...) - Exit : url={}", (Object)url);
        return url;
    }

    public ActionForward getButtonGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        this.populateAuthorizationFields((KualiDocumentFormBase)appaForm);
        String buttons = appaForm.getButtonGroupJson();
        this.writeJsonToResponse(response, HttpStatus.OK, buttons);
        return null;
    }

    public ActionForward getDocumentActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        this.populateAuthorizationFields((KualiDocumentFormBase)appaForm);
        String actions = appaForm.getDocumentActionsJson();
        this.writeJsonToResponse(response, HttpStatus.OK, actions);
        return null;
    }

    public ActionForward getGeneralLedgerPendingEntries(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        String glpes = appaForm.getGeneralLedgerPendingEntriesJson();
        this.writeJsonToResponse(response, HttpStatus.OK, glpes);
        return null;
    }

    public ActionForward getRouteLog(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        String routeLog = appaForm.getRouteLogResponseJson();
        this.writeJsonToResponse(response, HttpStatus.OK, routeLog);
        return null;
    }

    public ActionForward getInvoiceApplications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)form;
        this.loadDocument((KualiDocumentFormBase)appaForm);
        String routeLog = appaForm.getInvoiceResponsesJson();
        this.writeJsonToResponse(response, HttpStatus.OK, routeLog);
        return null;
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.createDocument(kualiDocumentFormBase);
        PaymentApplicationAdjustmentForm form = (PaymentApplicationAdjustmentForm)kualiDocumentFormBase;
        PaymentApplicationAdjustmentDocument document = form.getPaymentApplicationAdjustmentDocument();
        AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService = (AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.loadDocument(kualiDocumentFormBase);
        PaymentApplicationAdjustmentForm appaForm = (PaymentApplicationAdjustmentForm)kualiDocumentFormBase;
        this.loadInvoices(appaForm);
    }

    private void loadInvoices(PaymentApplicationAdjustmentForm appaForm) {
        PaymentApplicationAdjustmentDocument appaDoc = appaForm.getPaymentApplicationAdjustmentDocument();
        Set invoices = appaDoc.getInvoicePaidApplieds().stream().map(InvoicePaidApplied::getCustomerInvoiceDocument).collect(Collectors.toSet());
        appaForm.setInvoices(new ArrayList<CustomerInvoiceDocument>(invoices));
    }

    ChartService getChartService() {
        if (this.chartService == null) {
            this.chartService = (ChartService)SpringContext.getBean(ChartService.class);
        }
        return this.chartService;
    }

    AccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (AccountService)SpringContext.getBean(AccountService.class);
        }
        return this.accountService;
    }

    SubAccountService getSubAccountService() {
        if (this.subAccountService == null) {
            this.subAccountService = (SubAccountService)SpringContext.getBean(SubAccountService.class);
        }
        return this.subAccountService;
    }

    ObjectCodeService getObjectCodeService() {
        if (this.objectCodeService == null) {
            this.objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        }
        return this.objectCodeService;
    }

    SubObjectCodeService getSubObjectCodeService() {
        if (this.subObjectCodeService == null) {
            this.subObjectCodeService = (SubObjectCodeService)SpringContext.getBean(SubObjectCodeService.class);
        }
        return this.subObjectCodeService;
    }

    ProjectCodeService getProjectCodeService() {
        if (this.projectCodeService == null) {
            this.projectCodeService = (ProjectCodeService)SpringContext.getBean(ProjectCodeService.class);
        }
        return this.projectCodeService;
    }

    AccountingLineRuleHelperService getAccountingLineRuleHelperService() {
        if (this.accountingLineRuleHelperService == null) {
            this.accountingLineRuleHelperService = (AccountingLineRuleHelperService)SpringContext.getBean(AccountingLineRuleHelperService.class);
        }
        return this.accountingLineRuleHelperService;
    }

    MessageBuilderService getMessageBuilderService() {
        if (this.messageBuilderService == null) {
            this.messageBuilderService = (MessageBuilderService)SpringContext.getBean(MessageBuilderService.class);
        }
        return this.messageBuilderService;
    }
}

