/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;

public class PaymentApplicationInvoiceDetailApply
implements Serializable {
    private static final int DEFAULT_PAID_APPLIED_ITEM_NUMBER = 0;
    private final CustomerInvoiceDetail invoiceDetail;
    private final InvoicePaidApplied paidApplied;
    private KualiDecimal amountApplied;
    private KualiDecimal amountAppliedOldValue;
    private boolean fullApply;
    private boolean fullApplyOldValue;
    private boolean invoiceQuickApplied;
    private final String payAppDocNumber;

    public PaymentApplicationInvoiceDetailApply(String payAppDocNumber, CustomerInvoiceDetail invoiceDetail) {
        this.invoiceDetail = invoiceDetail;
        this.amountApplied = KualiDecimal.ZERO;
        this.amountAppliedOldValue = KualiDecimal.ZERO;
        this.fullApply = false;
        this.fullApplyOldValue = false;
        this.paidApplied = new InvoicePaidApplied();
        this.payAppDocNumber = payAppDocNumber;
        this.invoiceQuickApplied = false;
    }

    public InvoicePaidApplied generatePaidApplied() {
        return new InvoicePaidApplied(this.payAppDocNumber, this.invoiceDetail.getDocumentNumber(), this.invoiceDetail.getSequenceNumber(), this.amountApplied, 0);
    }

    public KualiDecimal getAmountOpen() {
        return this.invoiceDetail.getAmountOpen();
    }

    public KualiDecimal getAmountApplied() {
        return this.amountApplied;
    }

    public void setAmountApplied(KualiDecimal amountApplied) {
        this.amountAppliedOldValue = this.amountApplied;
        this.amountApplied = Objects.requireNonNullElse(amountApplied, KualiDecimal.ZERO);
    }

    @JsonIgnore
    public boolean isAmountAppliedChanged() {
        return !this.amountApplied.equals((Object)this.amountAppliedOldValue);
    }

    @JsonIgnore
    public boolean isFullApply() {
        return this.fullApply;
    }

    public void setFullApply(boolean fullApply) {
        this.fullApplyOldValue = this.fullApply;
        this.fullApply = fullApply;
    }

    @JsonIgnore
    public boolean isFullApplyChanged() {
        return this.fullApply != this.fullApplyOldValue;
    }

    @JsonIgnore
    public CustomerInvoiceDetail getInvoiceDetail() {
        return this.invoiceDetail;
    }

    public String getInvoiceDocumentNumber() {
        return this.invoiceDetail.getDocumentNumber();
    }

    public Integer getSequenceNumber() {
        return this.invoiceDetail.getSequenceNumber();
    }

    public String getChartOfAccountsCode() {
        return this.invoiceDetail.getChartOfAccountsCode();
    }

    public String getAccountNumber() {
        return this.invoiceDetail.getAccountNumber();
    }

    public String getInvoiceItemDescription() {
        return this.invoiceDetail.getInvoiceItemDescription();
    }

    public KualiDecimal getAmount() {
        return this.invoiceDetail.getAmount();
    }

    @JsonIgnore
    public boolean isInvoiceQuickApplied() {
        return this.invoiceQuickApplied;
    }

    public void setInvoiceQuickApplied(boolean invoiceQuickApplied) {
        this.invoiceQuickApplied = invoiceQuickApplied;
    }
}

