/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLOCReport;
import org.kuali.kfs.module.ar.report.ContractsGrantsLOCReportDetailDataHolder;
import org.kuali.kfs.module.ar.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportDataBuilderService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.report.ReportInfo;

public class ContractsGrantsLOCReportBuilderServiceImpl
implements ContractsGrantsReportDataBuilderService {
    protected ReportInfo reportInfo;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    @Override
    public ContractsGrantsReportDataHolder buildReportDataHolder(List<? extends BusinessObject> displayList, String sortPropertyName) {
        boolean isFieldSubtotalRequired = ArConstants.ReportsConstants.cgLOCReportSubtotalFieldsList.contains(sortPropertyName);
        Map<Object, Object> subTotalMap = new HashMap();
        if (isFieldSubtotalRequired) {
            subTotalMap = this.buildSubTotalMap(displayList, sortPropertyName);
        }
        ContractsGrantsReportDataHolder cgLOCDrawDetailsReportDataHolder = new ContractsGrantsReportDataHolder();
        List details = cgLOCDrawDetailsReportDataHolder.getDetails();
        for (ContractsGrantsLOCReport contractsGrantsLOCReport : displayList) {
            ContractsGrantsLOCReportDetailDataHolder reportDetail = new ContractsGrantsLOCReportDetailDataHolder();
            this.setReportDate(contractsGrantsLOCReport, reportDetail);
            if (isFieldSubtotalRequired) {
                reportDetail.setSortedFieldValue(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsLOCReport, sortPropertyName));
                reportDetail.setDisplaySubtotal(true);
                reportDetail.setSubTotal(((KualiDecimal)subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsLOCReport, sortPropertyName))).bigDecimalValue());
            } else {
                reportDetail.setDisplaySubtotal(false);
            }
            details.add(reportDetail);
        }
        cgLOCDrawDetailsReportDataHolder.setDetails(details);
        return cgLOCDrawDetailsReportDataHolder;
    }

    @Override
    public Class<? extends BusinessObject> getDetailsClass() {
        return ContractsGrantsLOCReport.class;
    }

    protected Map<String, KualiDecimal> buildSubTotalMap(List<ContractsGrantsLOCReport> displayList, String sortPropertyName) {
        HashMap<String, KualiDecimal> returnSubTotalMap = new HashMap<String, KualiDecimal>();
        List<String> valuesOfsortProperty = this.getContractsGrantsReportHelperService().getListOfValuesSortedProperties(displayList, sortPropertyName);
        for (String value : valuesOfsortProperty) {
            KualiDecimal subTotal = KualiDecimal.ZERO;
            for (ContractsGrantsLOCReport cgLOCDrawDetailsReportEntry : displayList) {
                if (!value.equals(this.getContractsGrantsReportHelperService().getPropertyValue((Object)cgLOCDrawDetailsReportEntry, sortPropertyName))) continue;
                subTotal = (KualiDecimal)subTotal.add((AbstractKualiDecimal)cgLOCDrawDetailsReportEntry.getAmountToDraw());
            }
            returnSubTotalMap.put(value, subTotal);
        }
        return returnSubTotalMap;
    }

    protected void setReportDate(ContractsGrantsLOCReport cgLOCDrawDetailsReportEntry, ContractsGrantsLOCReportDetailDataHolder reportDetail) {
        reportDetail.setDocumentNumber(cgLOCDrawDetailsReportEntry.getDocumentNumber());
        reportDetail.setLetterOfCreditFundCode(cgLOCDrawDetailsReportEntry.getLetterOfCreditFundCode());
        reportDetail.setLetterOfCreditFundGroupCode(cgLOCDrawDetailsReportEntry.getLetterOfCreditFundGroupCode());
        reportDetail.setLetterOfCreditReviewCreateDate(cgLOCDrawDetailsReportEntry.getLetterOfCreditReviewCreateDate());
        BigDecimal amountAvailableToDraw = ObjectUtils.isNull((Object)cgLOCDrawDetailsReportEntry.getAmountAvailableToDraw()) ? BigDecimal.ZERO : cgLOCDrawDetailsReportEntry.getAmountAvailableToDraw().bigDecimalValue();
        reportDetail.setAmountAvailableToDraw(amountAvailableToDraw);
        BigDecimal claimOnCashBalance = ObjectUtils.isNull((Object)cgLOCDrawDetailsReportEntry.getClaimOnCashBalance()) ? BigDecimal.ZERO : cgLOCDrawDetailsReportEntry.getClaimOnCashBalance().bigDecimalValue();
        reportDetail.setClaimOnCashBalance(claimOnCashBalance);
        BigDecimal amountToDraw = ObjectUtils.isNull((Object)cgLOCDrawDetailsReportEntry.getAmountToDraw()) ? BigDecimal.ZERO : cgLOCDrawDetailsReportEntry.getAmountToDraw().bigDecimalValue();
        reportDetail.setAmountToDraw(amountToDraw);
        BigDecimal fundsNotDrawn = ObjectUtils.isNull((Object)cgLOCDrawDetailsReportEntry.getFundsNotDrawn()) ? BigDecimal.ZERO : cgLOCDrawDetailsReportEntry.getFundsNotDrawn().bigDecimalValue();
        reportDetail.setFundsNotDrawn(fundsNotDrawn);
    }

    @Override
    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

