/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.report.service.CustomerInvoiceReportService;
import org.kuali.kfs.module.ar.report.util.CustomerInvoiceReportDataHolder;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerInvoiceReportServiceImpl
implements CustomerInvoiceReportService {
    private ReportGenerationService reportGenerationService;
    private ParameterService parameterService;
    private ReportInfo customerInvoiceReportInfo;
    private ReportInfo customerInvoiceReportInfoNoTax;

    @Override
    public File generateReport(CustomerInvoiceReportDataHolder reportDataHolder, Date runDate) {
        Map subReports;
        String subReportTemplateClassPath;
        ResourceBundle resourceBundle;
        String reportTemplateName;
        String reportTemplateClassPath;
        String reportDirectory;
        String reportFileName;
        if (this.parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "SALES_TAX_IND").booleanValue()) {
            reportFileName = this.customerInvoiceReportInfo.getReportFileName();
            reportDirectory = this.customerInvoiceReportInfo.getReportsDirectory();
            reportTemplateClassPath = this.customerInvoiceReportInfo.getReportTemplateClassPath();
            reportTemplateName = this.customerInvoiceReportInfo.getReportTemplateName();
            resourceBundle = this.customerInvoiceReportInfo.getResourceBundle();
            subReportTemplateClassPath = this.customerInvoiceReportInfo.getSubReportTemplateClassPath();
            subReports = this.customerInvoiceReportInfo.getSubReports();
        } else {
            reportFileName = this.customerInvoiceReportInfoNoTax.getReportFileName();
            reportDirectory = this.customerInvoiceReportInfoNoTax.getReportsDirectory();
            reportTemplateClassPath = this.customerInvoiceReportInfoNoTax.getReportTemplateClassPath();
            reportTemplateName = this.customerInvoiceReportInfoNoTax.getReportTemplateName();
            resourceBundle = this.customerInvoiceReportInfoNoTax.getResourceBundle();
            subReportTemplateClassPath = this.customerInvoiceReportInfoNoTax.getSubReportTemplateClassPath();
            subReports = this.customerInvoiceReportInfoNoTax.getSubReports();
        }
        Map<String, Object> reportData = reportDataHolder.getReportData();
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(runDate, reportDirectory, reportFileName, "");
        this.reportGenerationService.generateReportToPdfFile(reportData, template, fullReportFileName);
        return new File(fullReportFileName + ".pdf");
    }

    public void setCustomerInvoiceReportInfo(ReportInfo customerInvoiceReportInfo) {
        this.customerInvoiceReportInfo = customerInvoiceReportInfo;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ReportInfo getCustomerInvoiceReportInfo() {
        return this.customerInvoiceReportInfo;
    }

    public ReportInfo getCustomerInvoiceReportInfoNoTax() {
        return this.customerInvoiceReportInfoNoTax;
    }

    public void setCustomerInvoiceReportInfoNoTax(ReportInfo customerInvoiceReportInfoNoTax) {
        this.customerInvoiceReportInfoNoTax = customerInvoiceReportInfoNoTax;
    }
}

