/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsBillingSummaryActionBase;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsInvoiceSummaryForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.SegmentedLookupResultsService;

public class ContractsGrantsInvoiceSummaryAction
extends ContractsGrantsBillingSummaryActionBase {
    private static volatile ContractsGrantsInvoiceReportService contractsGrantsInvoiceReportService;
    private static volatile SegmentedLookupResultsService segmentedLookupResultsService;

    public ActionForward viewSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsInvoiceSummaryForm contractsGrantsInvoiceSummaryForm = (ContractsGrantsInvoiceSummaryForm)form;
        String lookupResultsSequenceNumber = contractsGrantsInvoiceSummaryForm.getLookupResultsSequenceNumber();
        if (StringUtils.isNotBlank((CharSequence)lookupResultsSequenceNumber)) {
            String personId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            Collection<ContractsGrantsInvoiceLookupResult> contractsGrantsInvoiceLookupResults = this.getContractsGrantsInvoiceResultsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId);
            contractsGrantsInvoiceSummaryForm.setContractsGrantsInvoiceLookupResults(contractsGrantsInvoiceLookupResults);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createInvoices(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsInvoiceSummaryForm contractsGrantsInvoiceSummaryForm = (ContractsGrantsInvoiceSummaryForm)form;
        ContractsGrantsInvoiceCreateDocumentService cgInvoiceDocumentCreateService = (ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class);
        String lookupResultsSequenceNumber = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            lookupResultsSequenceNumber = StringUtils.substringBetween((String)parameterName, (String)".number", (String)".");
        }
        Collection<ContractsGrantsInvoiceLookupResult> lookupResults = this.getContractsGrantsInvoiceResultsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        contractsGrantsInvoiceSummaryForm.setAwardInvoiced(true);
        int validationErrors = 0;
        int validAwards = 0;
        List<ErrorMessage> errorMessages = null;
        for (ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult : lookupResults) {
            Collection<ContractsAndGrantsBillingAward> awards = this.setupSelectedAccountsForValidationAndInvoiceCreation(contractsGrantsInvoiceLookupResult.getAwards(), contractsGrantsInvoiceLookupResult);
            ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
            awards = cgInvoiceDocumentCreateService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
            validationErrors += contractsGrantsInvoiceDocumentErrorLogs.size();
            validAwards += awards.size();
            if (awards.size() <= 0) continue;
            errorMessages = cgInvoiceDocumentCreateService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        }
        if (validationErrors > 0) {
            KNSGlobalVariables.getMessageList().add("error.document.awards.invalid", new String[0]);
        }
        if (validAwards > 0) {
            KNSGlobalVariables.getMessageList().add("message.document.contractsGrantsInvoice.batchSent", new String[0]);
        }
        if (ObjectUtils.isNotNull(errorMessages)) {
            KNSGlobalVariables.getMessageList().addAll(errorMessages);
        }
        return mapping.findForward("basic");
    }

    private Collection<ContractsAndGrantsBillingAward> setupSelectedAccountsForValidationAndInvoiceCreation(Collection<ContractsAndGrantsBillingAward> awards, ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult) {
        for (ContractsAndGrantsBillingAward award : awards) {
            if (!ArConstants.BillingFrequencyValues.isMilestone((Billable)award) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award)) continue;
            for (ContractsGrantsInvoiceLookupResultAward lookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
                if (!StringUtils.equals((CharSequence)award.getProposalNumber(), (CharSequence)lookupResultAward.getProposalNumber())) continue;
                award.getSelectedAccounts().add(lookupResultAward.getChartOfAccountsCode() + lookupResultAward.getAccountNumber());
            }
        }
        return awards;
    }

    protected Collection<ContractsGrantsInvoiceLookupResult> getContractsGrantsInvoiceResultsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) throws Exception {
        return ContractsGrantsInvoiceSummaryAction.getContractsGrantsInvoiceReportService().getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(this.getAwardAccountsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId));
    }

    protected Collection<ContractsAndGrantsBillingAwardAccount> getAwardAccountsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) throws Exception {
        KualiModuleService kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        Set selectedObjectIds = ContractsGrantsInvoiceSummaryAction.getSegmentedLookupResultsService().retrieveSetOfSelectedObjectIds(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        for (String selectedObjectId : selectedObjectIds) {
            String[] keys = selectedObjectId.split("-");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("proposalNumber", keys[0]);
            map.put("chartOfAccountsCode", keys[1]);
            map.put("accountNumber", keys[2]);
            map.put("active", true);
            List awardAccount = kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAwardAccount.class).getExternalizableBusinessObjectsList(ContractsAndGrantsBillingAwardAccount.class, map);
            if (!ObjectUtils.isNotNull((Object)awardAccount)) continue;
            awardAccounts.addAll(awardAccount);
        }
        return awardAccounts;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public static ContractsGrantsInvoiceReportService getContractsGrantsInvoiceReportService() {
        if (contractsGrantsInvoiceReportService == null) {
            contractsGrantsInvoiceReportService = (ContractsGrantsInvoiceReportService)SpringContext.getBean(ContractsGrantsInvoiceReportService.class);
        }
        return contractsGrantsInvoiceReportService;
    }

    public static SegmentedLookupResultsService getSegmentedLookupResultsService() {
        if (segmentedLookupResultsService == null) {
            segmentedLookupResultsService = (SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class);
        }
        return segmentedLookupResultsService;
    }
}

