/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.batch.dataaccess.impl;

import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.batch.dataaccess.impl.FiscalYearMakerImpl;
import org.kuali.kfs.sys.businessobject.FiscalYearBasedBusinessObject;

import java.util.ArrayList;
import java.util.List;

public class ContractsGrantsInvoiceObjectCodeFiscalYearMakerImpl extends FiscalYearMakerImpl {

    @Override
    public void changeForNewYear(final Integer baseFiscalYear, final FiscalYearBasedBusinessObject currentRecord) {
        super.changeForNewYear(baseFiscalYear, currentRecord);

        final ContractsGrantsInvoiceObjectCode reportDefinition = (ContractsGrantsInvoiceObjectCode) currentRecord;
        // null out PK field so a record can be created successfully for the new FY
        reportDefinition.setInvoiceObjectCodeIdentifier(null);
    }

    /**
     * Overridden to return list of fields to use for comparing current FY records with future FY records since
     * the PK is synthetic and is nulled out (so new records can be persisted successfully) before a comparison can be
     * performed.
     *
     * @return list of fields that should be considered PK fields for comparing between current FY and next FY records.
     */
    @Override
    public List<String> getPrimaryKeyPropertyNames() {
        final List<String> primaryKeyPropertyNames = new ArrayList<>();
        primaryKeyPropertyNames.add(KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR);
        primaryKeyPropertyNames.add(ArPropertyConstants.ContractsGrantsInvoiceObjectCodeFields.FUND_GROUP_CODE);
        primaryKeyPropertyNames.add(ArPropertyConstants.ContractsGrantsInvoiceObjectCodeFields.SUB_FUND_GROUP_TYPE_CODE);
        primaryKeyPropertyNames.add(ArPropertyConstants.ContractsGrantsInvoiceObjectCodeFields.SUB_FUND_GROUP_CODE);
        primaryKeyPropertyNames.add(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE);
        return primaryKeyPropertyNames;
    }
}
