/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Date;

/**
 * Milestone Report
 */
public class ContractsGrantsMilestoneReport extends TransientBusinessObjectBase implements MutableInactivatable {

    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String milestoneNumber;
    private KualiDecimal milestoneAmount;
    private Date milestoneExpectedCompletionDate;
    private Date milestoneActualCompletionDate;
    private String documentNumber;
    private boolean billed;
    private boolean active;
    private ContractsAndGrantsAward award;
    private Account account;
    private Chart chart;

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(final String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getMilestoneNumber() {
        return milestoneNumber;
    }

    public void setMilestoneNumber(final String milestoneNumber) {
        this.milestoneNumber = milestoneNumber;
    }

    public KualiDecimal getMilestoneAmount() {
        return milestoneAmount;
    }

    public void setMilestoneAmount(final KualiDecimal milestoneAmount) {
        this.milestoneAmount = milestoneAmount;
    }

    public boolean isBilled() {
        return billed;
    }

    public void setBilled(final boolean billed) {
        this.billed = billed;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

    public Date getMilestoneExpectedCompletionDate() {
        return milestoneExpectedCompletionDate;
    }

    public void setMilestoneExpectedCompletionDate(final Date milestoneExpectedCompletionDate) {
        this.milestoneExpectedCompletionDate = milestoneExpectedCompletionDate;
    }

    public Date getMilestoneActualCompletionDate() {
        return milestoneActualCompletionDate;
    }

    public void setMilestoneActualCompletionDate(final Date milestoneActualCompletionDate) {
        this.milestoneActualCompletionDate = milestoneActualCompletionDate;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(final String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(final String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public ContractsAndGrantsAward getAward() {
        return award;
    }

    public void setAward(final ContractsAndGrantsAward award) {
        this.award = award;
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(final Account account) {
        this.account = account;
    }

    public Chart getChart() {
        return chart;
    }

    public void setChart(final Chart chart) {
        this.chart = chart;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }
}
