/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressEmail;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.ar.ArKeyConstants;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.context.SpringContext;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CustomerAddress extends PersistableBusinessObjectBase implements Comparable<CustomerAddress>,
        AccountsReceivableCustomerAddress {

    private String customerNumber;
    private Integer customerAddressIdentifier;
    private String customerAddressName;
    private String customerLine1StreetAddress;
    private String customerLine2StreetAddress;
    private String customerCityName;
    private String customerStateCode;
    private String customerZipCode;
    private String customerCountryCode;
    private String customerAddressInternationalProvinceName;
    private String customerInternationalMailCode;
    private String customerAddressTypeCode;
    private Date customerAddressEndDate;
    private List<AccountsReceivableCustomerAddressEmail> customerAddressEmails = new ArrayList<>();
    private CustomerAddressType customerAddressType;
    private Customer customer;
    private Country customerCountry;

    // Invoice Template link

    private String customerInvoiceTemplateCode;
    private InvoiceTemplate customerInvoiceTemplate;

    // Invoice Indicator link

    private String invoiceTransmissionMethodCode;
    private InvoiceTransmissionMethod invoiceTransmissionMethod;

    private Integer customerCopiesToPrint;
    private Integer customerEnvelopesToPrintQuantity;

    private transient String customerAddressEmailsAsString;

    public CustomerAddress() {
    }

    @Override
    public String getCustomerNumber() {
        return customerNumber;
    }

    @Override
    public void setCustomerNumber(final String customerNumber) {
        this.customerNumber = customerNumber;
    }

    @Override
    public Integer getCustomerAddressIdentifier() {
        return customerAddressIdentifier;
    }

    public void setCustomerAddressIdentifier(final Integer customerAddressIdentifier) {
        this.customerAddressIdentifier = customerAddressIdentifier;
    }

    @Override
    public String getCustomerAddressName() {
        return customerAddressName;
    }

    @Override
    public void setCustomerAddressName(final String customerAddressName) {
        this.customerAddressName = customerAddressName;
    }

    @Override
    public String getCustomerLine1StreetAddress() {
        return customerLine1StreetAddress;
    }

    @Override
    public void setCustomerLine1StreetAddress(final String customerLine1StreetAddress) {
        this.customerLine1StreetAddress = customerLine1StreetAddress;
    }

    @Override
    public String getCustomerLine2StreetAddress() {
        return customerLine2StreetAddress;
    }

    @Override
    public void setCustomerLine2StreetAddress(final String customerLine2StreetAddress) {
        this.customerLine2StreetAddress = customerLine2StreetAddress;
    }

    @Override
    public String getCustomerCityName() {
        return customerCityName;
    }

    @Override
    public void setCustomerCityName(final String customerCityName) {
        this.customerCityName = customerCityName;
    }

    @Override
    public String getCustomerStateCode() {
        return customerStateCode;
    }

    @Override
    public void setCustomerStateCode(final String customerStateCode) {
        this.customerStateCode = customerStateCode;
    }

    @Override
    public String getCustomerZipCode() {
        return customerZipCode;
    }

    @Override
    public void setCustomerZipCode(final String customerZipCode) {
        this.customerZipCode = customerZipCode;
    }

    @Override
    public String getCustomerAddressInternationalProvinceName() {
        return customerAddressInternationalProvinceName;
    }

    public void setCustomerAddressInternationalProvinceName(final String customerAddressInternationalProvinceName) {
        this.customerAddressInternationalProvinceName = customerAddressInternationalProvinceName;
    }

    @Override
    public String getCustomerCountryCode() {
        return customerCountryCode;
    }

    @Override
    public void setCustomerCountryCode(final String customerCountryCode) {
        this.customerCountryCode = customerCountryCode;
    }

    @Override
    public String getCustomerInternationalMailCode() {
        return customerInternationalMailCode;
    }

    public void setCustomerInternationalMailCode(final String customerInternationalMailCode) {
        this.customerInternationalMailCode = customerInternationalMailCode;
    }

    @Override
    public String getCustomerAddressTypeCode() {
        return customerAddressTypeCode;
    }

    @Override
    public void setCustomerAddressTypeCode(final String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    @Override
    public Date getCustomerAddressEndDate() {
        return customerAddressEndDate;
    }

    public void setCustomerAddressEndDate(final Date customerAddressEndDate) {
        this.customerAddressEndDate = customerAddressEndDate;
    }

    @Override
    public List<AccountsReceivableCustomerAddressEmail> getCustomerAddressEmails() {
        return customerAddressEmails;
    }

    @Override
    public void setCustomerAddressEmails(final List<AccountsReceivableCustomerAddressEmail> customerAddressEmails) {
        this.customerAddressEmails = customerAddressEmails;
    }

    @Override
    public String getCustomerAddressEmailsAsString() {
        return customerAddressEmails.stream().map(AccountsReceivableCustomerAddressEmail::getCustomerEmailAddress)
               .collect(Collectors.joining(", "));
    }

    public CustomerAddressType getCustomerAddressType() {
        return customerAddressType;
    }

    @Deprecated
    public void setCustomerAddressType(final CustomerAddressType customerAddressType) {
        this.customerAddressType = customerAddressType;
    }

    public Customer getCustomer() {
        return customer;
    }

    @Deprecated
    public void setCustomer(final Customer customer) {
        this.customer = customer;
    }

    @Override
    public String getInvoiceTransmissionMethodCode() {
        return invoiceTransmissionMethodCode;
    }

    public void setInvoiceTransmissionMethodCode(final String invoiceTransmissionMethodCode) {
        this.invoiceTransmissionMethodCode = invoiceTransmissionMethodCode;
    }

    public Country getCustomerCountry() {
        return customerCountry;
    }

    @Deprecated
    public void setCustomerCountry(final Country customerCountry) {
        this.customerCountry = customerCountry;
    }

    @Override
    public int compareTo(final CustomerAddress address) {
        if (!StringUtils.equalsIgnoreCase(getCustomerNumber(), address.getCustomerNumber())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(getCustomerAddressName(), address.getCustomerAddressName())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(
                getCustomerLine1StreetAddress(),
                address.getCustomerLine1StreetAddress())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(
                getCustomerLine2StreetAddress(),
                address.getCustomerLine2StreetAddress())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(getCustomerCityName(), address.getCustomerCityName())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(getCustomerStateCode(), address.getCustomerStateCode())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(getCustomerZipCode(), address.getCustomerZipCode())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(getCustomerCountryCode(), address.getCustomerCountryCode())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(
                getCustomerAddressInternationalProvinceName(),
                address.getCustomerAddressInternationalProvinceName())) {
            return -1;
        }
        if (!StringUtils.equalsIgnoreCase(getCustomerAddressTypeCode(), address.getCustomerAddressTypeCode())) {
            return -1;
        }
        if (getCustomerAddressIdentifier() != null && address.getCustomerAddressIdentifier() != null
            && getCustomerAddressIdentifier().compareTo(address.getCustomerAddressIdentifier()) != 0
            || getCustomerAddressIdentifier() == null && address.getCustomerAddressIdentifier() != null
            || getCustomerAddressIdentifier() != null && address.getCustomerAddressIdentifier() == null) {
            return -1;
        }
        if (!CollectionUtils.isEqualCollection(getCustomerAddressEmails(), address.getCustomerAddressEmails())) {
            return -1;
        }
        return 0;
    }

    @Override
    protected void beforeInsert() {
        super.beforeInsert();
        final CustomerAddressService customerAddressService = SpringContext.getBean(CustomerAddressService.class);
        final int customerAddressIdentifier = customerAddressService.getNextCustomerAddressIdentifier();
        setCustomerAddressIdentifier(customerAddressIdentifier);
    }

    @Override
    public AccountsReceivableCustomerAddressType getAccountsReceivableCustomerAddressType() {
        return customerAddressType;
    }

    @Override
    public void setCustomerAddressTypeCodeAsPrimary() {
        setCustomerAddressTypeCode(ArKeyConstants.CustomerConstants.CUSTOMER_ADDRESS_TYPE_CODE_PRIMARY);
    }

    @Override
    public void setCustomerAddressTypeCodeAsAlternate() {
        setCustomerAddressTypeCode(ArKeyConstants.CustomerConstants.CUSTOMER_ADDRESS_TYPE_CODE_ALTERNATE);
    }

    @Override
    public AccountsReceivableCustomer getAccountsReceivableCustomer() {
        return customer;
    }

    @Override
    public String getCustomerInvoiceTemplateCode() {
        return customerInvoiceTemplateCode;
    }

    public void setCustomerInvoiceTemplateCode(final String customerInvoiceTemplateCode) {
        this.customerInvoiceTemplateCode = customerInvoiceTemplateCode;
    }

    public InvoiceTemplate getCustomerInvoiceTemplate() {
        return customerInvoiceTemplate;
    }

    public void setCustomerInvoiceTemplate(final InvoiceTemplate customerInvoiceTemplate) {
        this.customerInvoiceTemplate = customerInvoiceTemplate;
    }

    public InvoiceTransmissionMethod getInvoiceTransmissionMethod() {
        return invoiceTransmissionMethod;
    }

    public void setInvoiceTransmissionMethod(final InvoiceTransmissionMethod invoiceTransmissionMethod) {
        this.invoiceTransmissionMethod = invoiceTransmissionMethod;
    }

    @Override
    public Integer getCustomerCopiesToPrint() {
        return customerCopiesToPrint;
    }

    public void setCustomerCopiesToPrint(final Integer customerCopiesToPrint) {
        this.customerCopiesToPrint = customerCopiesToPrint;
    }

    @Override
    public Integer getCustomerEnvelopesToPrintQuantity() {
        return customerEnvelopesToPrintQuantity;
    }

    public void setCustomerEnvelopesToPrintQuantity(final Integer customerEnvelopesToPrintQuantity) {
        this.customerEnvelopesToPrintQuantity = customerEnvelopesToPrintQuantity;
    }
}
