/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;

import java.sql.Date;

public class CustomerInvoiceLookup extends PersistableBusinessObjectBase {

    protected String invoiceNumber;
    protected String customerName;
    protected boolean openInvoiceIndicator;
    protected Date invoiceDueDate;
    protected Date billingDate;
    protected String billByChartOfAccountCode;
    protected String billedByOrganizationCode;

    protected AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(final String customerName) {
        this.customerName = customerName;
    }

    public boolean isOpenInvoiceIndicator() {
        return openInvoiceIndicator;
    }

    public void setOpenInvoiceIndicator(final boolean openInvoiceIndicator) {
        this.openInvoiceIndicator = openInvoiceIndicator;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(final String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Date getInvoiceDueDate() {
        return invoiceDueDate;
    }

    public void setInvoiceDueDate(final Date invoiceDueDate) {
        this.invoiceDueDate = invoiceDueDate;
    }

    public Date getBillingDate() {
        return billingDate;
    }

    public void setBillingDate(final Date billingDate) {
        this.billingDate = billingDate;
    }

    public String getBillByChartOfAccountCode() {
        return billByChartOfAccountCode;
    }

    public void setBillByChartOfAccountCode(final String billByChartOfAccountCode) {
        this.billByChartOfAccountCode = billByChartOfAccountCode;
    }

    public String getBilledByOrganizationCode() {
        return billedByOrganizationCode;
    }

    public void setBilledByOrganizationCode(final String billedByOrganizationCode) {
        this.billedByOrganizationCode = billedByOrganizationCode;
    }

    public AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(final AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }
}
