/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.options;

import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.DunningLetterTemplate;
import org.kuali.kfs.module.ar.document.service.DunningLetterService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.util.ConcreteKeyValue;
import org.kuali.kfs.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

public class DunningLetterTemplateValuesFinder extends KeyValuesBase {
    private BusinessObjectService businessObjectService;
    private DunningLetterService dunningLetterService;

    @Override
    public List<KeyValue> getKeyValues() {
        final List<KeyValue> keyValues = new ArrayList<>();

        final Person currentUser = GlobalVariables.getUserSession().getPerson();

        final List<DunningLetterTemplate> boList = (List<DunningLetterTemplate>) getBusinessObjectService().findAll(DunningLetterTemplate.class);
        for (final DunningLetterTemplate element : boList) {
            if (!element.isRestrictUseByChartOrg() && element.isActive()) {
                keyValues.add(new ConcreteKeyValue(element.getDunningLetterTemplateCode(), element.getDunningLetterTemplateDescription()));
            } else {
                if (getDunningLetterService().isValidOrganizationForTemplate(element, currentUser) && element.isActive()) {
                    keyValues.add(new ConcreteKeyValue(element.getDunningLetterTemplateCode(), element.getDunningLetterTemplateDescription()));
                }
            }
        }

        return keyValues;
    }

    public BusinessObjectService getBusinessObjectService() {
        // This values finder is referenced in a JSP tag, so injection doesn't work there. However, injection does work
        // when this values finder is referenced in the Dunning Campaign document, so it is wired up that way in the
        // spring config file. Hopefully, the tag can get refactored at some point and this SpringContext call can be
        // eliminated.
        if (businessObjectService == null) {
            businessObjectService = SpringContext.getBean(BusinessObjectService.class);
        }
        return businessObjectService;
    }

    public void setBusinessObjectService(final BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private DunningLetterService getDunningLetterService() {
        if (dunningLetterService == null) {
            dunningLetterService = SpringContext.getBean(DunningLetterService.class);
        }
        return dunningLetterService;
    }

    void setDunningLetterService(final DunningLetterService dunningLetterService) {
        this.dunningLetterService = dunningLetterService;
    }
}
