/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.service;

import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;

import java.sql.Date;

public interface InvoiceRecurrenceDocumentService {

    /**
     * @param document
     * @param customerInvoiceDetail
     * @return {@code true} if customer invoice detail amount can be taxed.
     */
    boolean isCustomerInvoiceDetailTaxable(CustomerInvoiceDocument document, CustomerInvoiceDetail customerInvoiceDetail);

    /**
     * @param document
     * @return the appropriate postal code for taxation
     */
    String getPostalCodeForTaxation(CustomerInvoiceDocument document);

    /**
     * @param invoiceNumber
     * @return {@code true} if the invoice has an approved status.
     */
    boolean isInvoiceApproved(String invoiceNumber);

    /**
     * @param beginDate
     * @return {@code true} if the begin date is valid.
     */
    boolean isValidRecurrenceBeginDate(Date beginDate);

    /**
     * @param beginDate
     * @param endDate
     * @return {@code true} if the end date is valid.
     */
    boolean isValidRecurrenceEndDate(Date beginDate, Date endDate);

    /**
     * @param beginDate
     * @param endDate
     * @param totalRecurrenceNumber
     * @param intervalCode
     * @return {@code true} if the end date and number of recurrences are valid if entered together.
     */
    boolean isValidEndDateAndTotalRecurrenceNumber(Date beginDate, Date endDate, Integer totalRecurrenceNumber, String intervalCode);

    /**
     * @param endDate
     * @param totalRecurrenceNumber
     * @return {@code true} if one of the end date or the number of recurrences is entered.
     */
    boolean isValidEndDateOrTotalRecurrenceNumber(Date endDate, Integer totalRecurrenceNumber);

    /**
     * @param totalRecurrenceNumber
     * @param intervalCode
     * @return {@code true} if the number of recurrences is not more than the maximum allowed.
     */
    boolean isValidMaximumNumberOfRecurrences(Integer totalRecurrenceNumber, String intervalCode);

    /**
     * @param initiator
     * @return {@code true} if the initiator is valid.
     */
    boolean isValidInitiator(String initiator);

}
