/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.dataaccess.NonAppliedHoldingDao;
import org.kuali.kfs.module.ar.document.service.NonAppliedHoldingService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Transactional
public class NonAppliedHoldingServiceImpl implements NonAppliedHoldingService {

    private NonAppliedHoldingDao nonAppliedHoldingDao;

    @Override
    public Collection<NonAppliedHolding> getNonAppliedHoldingsForCustomer(final Customer customer) {
        return null == customer ? null : getNonAppliedHoldingsForCustomer(customer.getCustomerNumber());
    }

    @Override
    public Collection<NonAppliedHolding> getNonAppliedHoldingsForCustomer(final String customerNumber) {
        if (StringUtils.isBlank(customerNumber)) {
            throw new IllegalArgumentException("The parameter [customerNumber] passed in was blank or null.");
        }
        final List<NonAppliedHolding> nonAppliedHoldings = new ArrayList<>();
        //TODO WARNING this is going to degrade badly performance wise as the db fills up,
        //     this needs to be solved properly with a flag in the NonAppliedHolding
        final Collection<NonAppliedHolding> tempList = nonAppliedHoldingDao.getNonAppliedHoldingsForCustomer(customerNumber);
        for (final NonAppliedHolding nonAppliedHolding : tempList) {
            if (nonAppliedHolding.getAvailableUnappliedAmount().isPositive()) {
                nonAppliedHoldings.add(nonAppliedHolding);
            }
        }
        return nonAppliedHoldings;
    }

    @Override
    public Collection<NonAppliedHolding> getNonAppliedHoldingsByListOfDocumentNumbers(final List<String> docNumbers) {
        if (docNumbers == null) {
            throw new IllegalArgumentException("The parameter [docNumbers] passed in was null.");
        }
        if (docNumbers.isEmpty()) {
            return new ArrayList<>();
        }

        return nonAppliedHoldingDao.getNonAppliedHoldingsByListOfDocumentNumbers(docNumbers);
    }

    public void setNonAppliedHoldingDao(final NonAppliedHoldingDao nonAppliedHoldingDao) {
        this.nonAppliedHoldingDao = nonAppliedHoldingDao;
    }

}
