/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.service.FinalBilledIndicatorValidationService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Action class for Final Billed Indicator Document.
 */
public class FinalBilledIndicatorAction extends KualiTransactionalDocumentActionBase {

    private FinalBilledIndicatorValidationService finalBilledIndicatorValidationService;

    /**
     * This method adds an entry to the list of entries.
     *
     * @param mapping
     * @param actionForm
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward addInvoiceEntry(
            final ActionMapping mapping, final ActionForm actionForm, final HttpServletRequest request,
            final HttpServletResponse response) throws Exception {
        final FinalBilledIndicatorForm form = (FinalBilledIndicatorForm) actionForm;
        final FinalBilledIndicatorDocument document = form.getFinalBilledIndicatorDocument();
        final FinalBilledIndicatorEntry newUnfinalizeInvoiceEntry = form.getInvoiceEntry();
        if (getFinalBilledIndicatorValidationService().validateEntry(newUnfinalizeInvoiceEntry)) {
            document.addInvoiceEntry(newUnfinalizeInvoiceEntry);
            form.setInvoiceEntry(new FinalBilledIndicatorEntry());
        }
        return mapping.findForward(KFSConstants.MAPPING_BASIC);
    }

    /**
     * This method removes an entry to the list of entries.
     *
     * @param mapping
     * @param actionForm
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward deleteInvoiceEntry(
            final ActionMapping mapping, final ActionForm actionForm, final HttpServletRequest request,
            final HttpServletResponse response) throws Exception {
        final FinalBilledIndicatorForm form = (FinalBilledIndicatorForm) actionForm;
        final FinalBilledIndicatorDocument document = form.getFinalBilledIndicatorDocument();
        final int deleteIndex = getLineToDelete(request);
        document.removeInvoiceEntry(deleteIndex);
        return mapping.findForward(KFSConstants.MAPPING_BASIC);
    }

    @Override
    public void doProcessingAfterPost(final KualiForm actionForm, final HttpServletRequest request) {
        final FinalBilledIndicatorForm form = (FinalBilledIndicatorForm) actionForm;
        final FinalBilledIndicatorDocument document = form.getFinalBilledIndicatorDocument();
        getFinalBilledIndicatorValidationService().validateDocument(document);
        super.doProcessingAfterPost(actionForm, request);
    }

    private FinalBilledIndicatorValidationService getFinalBilledIndicatorValidationService() {
        if (finalBilledIndicatorValidationService == null) {
            finalBilledIndicatorValidationService = SpringContext.getBean(FinalBilledIndicatorValidationService.class);
        }
        return finalBilledIndicatorValidationService;
    }
}
