/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.report.util;

import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.util.Map;

public class CustomerAgingReportDataHolder {

    private Map<String, Object> knownCustomers;
    private KualiDecimal total0to30;
    private KualiDecimal total31to60;
    private KualiDecimal total61to90;
    private KualiDecimal total91toSYSPR;
    private KualiDecimal totalSYSPRplus1orMore;
    private KualiDecimal totalAmountDue;

    public Map<String, Object> getKnownCustomers() {
        return knownCustomers;
    }

    public void setKnownCustomers(final Map<String, Object> knownCustomers) {
        this.knownCustomers = knownCustomers;
    }

    public KualiDecimal getTotal0to30() {
        return total0to30;
    }

    public void setTotal0to30(final KualiDecimal total0to30) {
        this.total0to30 = total0to30;
    }

    public KualiDecimal getTotal31to60() {
        return total31to60;
    }

    public void setTotal31to60(final KualiDecimal total31to60) {
        this.total31to60 = total31to60;
    }

    public KualiDecimal getTotal61to90() {
        return total61to90;
    }

    public void setTotal61to90(final KualiDecimal total61to90) {
        this.total61to90 = total61to90;
    }

    public KualiDecimal getTotal91toSYSPR() {
        return total91toSYSPR;
    }

    public void setTotal91toSYSPR(final KualiDecimal total91toSYSPR) {
        this.total91toSYSPR = total91toSYSPR;
    }

    public KualiDecimal getTotalSYSPRplus1orMore() {
        return totalSYSPRplus1orMore;
    }

    public void setTotalSYSPRplus1orMore(final KualiDecimal totalSYSPRplus1orMore) {
        this.totalSYSPRplus1orMore = totalSYSPRplus1orMore;
    }

    public KualiDecimal getTotalAmountDue() {
        return totalAmountDue;
    }

    public void setTotalAmountDue(final KualiDecimal totalAmountDue) {
        this.totalAmountDue = totalAmountDue;
    }

    /**
     * This method clears all the amount fields and resets them to zero.
     */
    public void clearAllAmounts() {
        total0to30 = KualiDecimal.ZERO;
        total31to60 = KualiDecimal.ZERO;
        total61to90 = KualiDecimal.ZERO;
        total91toSYSPR = KualiDecimal.ZERO;
        totalSYSPRplus1orMore = KualiDecimal.ZERO;
        totalAmountDue = KualiDecimal.ZERO;
    }
}
